/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.player.Player;

public class FollowTemptation
extends Behavior<PathfinderMob> {
    public static final int TEMPTATION_COOLDOWN = 100;
    public static final double DEFAULT_CLOSE_ENOUGH_DIST = 2.5;
    public static final double BACKED_UP_CLOSE_ENOUGH_DIST = 3.5;
    private final Function<LivingEntity, Float> speedModifier;
    private final Function<LivingEntity, Double> closeEnoughDistance;
    private final boolean lookInTheEyes;

    public FollowTemptation(Function<LivingEntity, Float> var02) {
        this(var02, var0 -> 2.5);
    }

    public FollowTemptation(Function<LivingEntity, Float> var0, Function<LivingEntity, Double> var1) {
        this(var0, var1, false);
    }

    public FollowTemptation(Function<LivingEntity, Float> var0, Function<LivingEntity, Double> var1, boolean var2) {
        super((Map)Util.make(() -> {
            ImmutableMap.Builder var0 = ImmutableMap.builder();
            var0.put(MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED);
            var0.put(MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED);
            var0.put(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT);
            var0.put(MemoryModuleType.IS_TEMPTED, (Object)MemoryStatus.VALUE_ABSENT);
            var0.put(MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_PRESENT);
            var0.put(MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT);
            var0.put(MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT);
            return var0.build();
        }));
        this.speedModifier = var0;
        this.closeEnoughDistance = var1;
        this.lookInTheEyes = var2;
    }

    protected float getSpeedModifier(PathfinderMob var0) {
        return this.speedModifier.apply(var0).floatValue();
    }

    private Optional<Player> getTemptingPlayer(PathfinderMob var0) {
        return var0.getBrain().getMemory(MemoryModuleType.TEMPTING_PLAYER);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, PathfinderMob var1, long var2) {
        return this.getTemptingPlayer(var1).isPresent() && !var1.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET) && !var1.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void start(ServerLevel var0, PathfinderMob var1, long var2) {
        var1.getBrain().setMemory(MemoryModuleType.IS_TEMPTED, true);
    }

    @Override
    protected void stop(ServerLevel var0, PathfinderMob var1, long var2) {
        Brain<?> var4 = var1.getBrain();
        var4.setMemory(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, 100);
        var4.eraseMemory(MemoryModuleType.IS_TEMPTED);
        var4.eraseMemory(MemoryModuleType.WALK_TARGET);
        var4.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    @Override
    protected void tick(ServerLevel var0, PathfinderMob var1, long var2) {
        Player var4 = this.getTemptingPlayer(var1).get();
        Brain<?> var5 = var1.getBrain();
        var5.setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(var4, true));
        double var6 = this.closeEnoughDistance.apply(var1);
        if (var1.distanceToSqr(var4) < Mth.square(var6)) {
            var5.eraseMemory(MemoryModuleType.WALK_TARGET);
        } else {
            var5.setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new EntityTracker(var4, this.lookInTheEyes, this.lookInTheEyes), this.getSpeedModifier(var1), 2));
        }
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (PathfinderMob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (PathfinderMob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (PathfinderMob)livingEntity, l);
    }
}

