/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class StopAttackingIfTargetInvalid {
    private static final int TIMEOUT_TO_GET_WITHIN_ATTACK_RANGE = 200;

    public static <E extends Mob> BehaviorControl<E> create(TargetErasedCallback<E> behaviorattacktargetforget_b) {
        return StopAttackingIfTargetInvalid.create((worldserver, entityliving) -> false, behaviorattacktargetforget_b, true);
    }

    public static <E extends Mob> BehaviorControl<E> create(StopAttackCondition behaviorattacktargetforget_a) {
        return StopAttackingIfTargetInvalid.create(behaviorattacktargetforget_a, (worldserver, entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends Mob> BehaviorControl<E> create() {
        return StopAttackingIfTargetInvalid.create((worldserver, entityliving) -> false, (worldserver, entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends Mob> BehaviorControl<E> create(StopAttackCondition behaviorattacktargetforget_a, TargetErasedCallback<E> behaviorattacktargetforget_b, boolean flag) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.present(MemoryModuleType.ATTACK_TARGET), behaviorbuilder_b.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i) -> {
            LivingEntity entityliving = (LivingEntity)behaviorbuilder_b.get(memoryaccessor);
            if (!(!entityinsentient.canAttack(entityliving) || flag && StopAttackingIfTargetInvalid.isTiredOfTryingToReachTarget(entityinsentient, behaviorbuilder_b.tryGet(memoryaccessor1)) || !entityliving.isAlive() || entityliving.level() != entityinsentient.level() || behaviorattacktargetforget_a.test(worldserver, entityliving))) {
                return true;
            }
            LivingEntity old = entityinsentient.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, null, old != null && !old.isAlive() ? EntityTargetEvent.TargetReason.TARGET_DIED : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() != null) {
                entityinsentient.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, ((CraftLivingEntity)event.getTarget()).getHandle());
                return true;
            }
            behaviorattacktargetforget_b.accept(worldserver, entityinsentient, entityliving);
            memoryaccessor.erase();
            return true;
        }));
    }

    private static boolean isTiredOfTryingToReachTarget(LivingEntity entityliving, Optional<Long> optional) {
        return optional.isPresent() && entityliving.level().getGameTime() - optional.get() > 200L;
    }

    @FunctionalInterface
    public static interface StopAttackCondition {
        public boolean test(ServerLevel var1, LivingEntity var2);
    }

    @FunctionalInterface
    public static interface TargetErasedCallback<E> {
        public void accept(ServerLevel var1, E var2, LivingEntity var3);
    }
}

