/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriConsumer;

public class TransportItemsBetweenContainers
extends Behavior<PathfinderMob> {
    public static final int TARGET_INTERACTION_TIME = 60;
    private static final int VISITED_POSITIONS_MEMORY_TIME = 6000;
    private static final int TRANSPORTED_ITEM_MAX_STACK_SIZE = 16;
    private static final int MAX_VISITED_POSITIONS = 10;
    private static final int MAX_UNREACHABLE_POSITIONS = 50;
    private static final int PASSENGER_MOB_TARGET_SEARCH_DISTANCE = 1;
    private static final int IDLE_COOLDOWN = 140;
    private static final double CLOSE_ENOUGH_TO_START_QUEUING_DISTANCE = 3.0;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_DISTANCE = 0.5;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_PATH_END_DISTANCE = 1.0;
    private static final double CLOSE_ENOUGH_TO_CONTINUE_INTERACTING_WITH_TARGET = 2.0;
    private final float speedModifier;
    private final int horizontalSearchDistance;
    private final int verticalSearchDistance;
    private final Predicate<BlockState> sourceBlockType;
    private final Predicate<BlockState> destinationBlockType;
    private final Predicate<TransportItemTarget> shouldQueueForTarget;
    private final Consumer<PathfinderMob> onStartTravelling;
    private final Map<ContainerInteractionState, OnTargetReachedInteraction> onTargetInteractionActions;
    @Nullable
    private TransportItemTarget target = null;
    private TransportItemState state;
    @Nullable
    private ContainerInteractionState interactionState;
    private int ticksSinceReachingTarget;

    public TransportItemsBetweenContainers(float var0, Predicate<BlockState> var1, Predicate<BlockState> var2, int var3, int var4, Map<ContainerInteractionState, OnTargetReachedInteraction> var5, Consumer<PathfinderMob> var6, Predicate<TransportItemTarget> var7) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.VISITED_BLOCK_POSITIONS, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = var0;
        this.sourceBlockType = var1;
        this.destinationBlockType = var2;
        this.horizontalSearchDistance = var3;
        this.verticalSearchDistance = var4;
        this.onStartTravelling = var6;
        this.shouldQueueForTarget = var7;
        this.onTargetInteractionActions = var5;
        this.state = TransportItemState.TRAVELLING;
    }

    @Override
    protected void start(ServerLevel var0, PathfinderMob var1, long var2) {
        PathNavigation pathNavigation = var1.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation var4 = (GroundPathNavigation)pathNavigation;
            var4.setCanPathToTargetsBelowSurface(true);
        }
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, PathfinderMob var1) {
        return !var1.isLeashed();
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, PathfinderMob var1, long var2) {
        return var1.getBrain().getMemory(MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS).isEmpty() && !var1.isPanicking() && !var1.isLeashed();
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected void tick(ServerLevel var0, PathfinderMob var1, long var2) {
        boolean var4 = this.updateInvalidTarget(var0, var1);
        if (this.target == null) {
            this.stop(var0, var1, var2);
            return;
        }
        if (var4) {
            return;
        }
        if (this.state.equals((Object)TransportItemState.QUEUING)) {
            this.onQueuingForTarget(this.target, var0, var1);
        }
        if (this.state.equals((Object)TransportItemState.TRAVELLING)) {
            this.onTravelToTarget(this.target, var0, var1);
        }
        if (this.state.equals((Object)TransportItemState.INTERACTING)) {
            this.onReachedTarget(this.target, var0, var1);
        }
    }

    private boolean updateInvalidTarget(ServerLevel var0, PathfinderMob var1) {
        if (!this.hasValidTarget(var0, var1)) {
            this.stopTargetingCurrentTarget(var1);
            Optional<TransportItemTarget> var2 = this.getTransportTarget(var0, var1);
            if (var2.isPresent()) {
                this.target = var2.get();
                this.onStartTravelling(var1);
                this.setVisitedBlockPos(var1, var0, this.target.pos);
                return true;
            }
            this.enterCooldownAfterNoMatchingTargetFound(var1);
            return true;
        }
        return false;
    }

    private void onQueuingForTarget(TransportItemTarget var0, Level var1, PathfinderMob var2) {
        if (!this.isAnotherMobInteractingWithTarget(var0, var1)) {
            this.resumeTravelling(var2);
        }
    }

    protected void onTravelToTarget(TransportItemTarget var0, Level var1, PathfinderMob var2) {
        if (this.isWithinTargetDistance(3.0, var0, var1, var2, this.getCenterPos(var2)) && this.isAnotherMobInteractingWithTarget(var0, var1)) {
            this.startQueuing(var2);
        } else if (this.isWithinTargetDistance(TransportItemsBetweenContainers.getInteractionRange(var2), var0, var1, var2, this.getCenterPos(var2))) {
            this.startOnReachedTargetInteraction(var0, var2);
        } else {
            this.walkTowardsTarget(var2);
        }
    }

    private Vec3 getCenterPos(PathfinderMob var0) {
        return this.setMiddleYPosition(var0, var0.position());
    }

    protected void onReachedTarget(TransportItemTarget var0, Level var12, PathfinderMob var22) {
        if (!this.isWithinTargetDistance(2.0, var0, var12, var22, this.getCenterPos(var22))) {
            this.onStartTravelling(var22);
        } else {
            ++this.ticksSinceReachingTarget;
            this.onTargetInteraction(var0, var22);
            if (this.ticksSinceReachingTarget >= 60) {
                this.doReachedTargetInteraction(var22, var0.container, this::pickUpItems, (var1, var2) -> this.stopTargetingCurrentTarget(var22), this::putDownItem, (var1, var2) -> this.stopTargetingCurrentTarget(var22));
                this.onStartTravelling(var22);
            }
        }
    }

    private void startQueuing(PathfinderMob var0) {
        this.stopInPlace(var0);
        this.setTransportingState(TransportItemState.QUEUING);
    }

    private void resumeTravelling(PathfinderMob var0) {
        this.setTransportingState(TransportItemState.TRAVELLING);
        this.walkTowardsTarget(var0);
    }

    private void walkTowardsTarget(PathfinderMob var0) {
        if (this.target != null) {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)var0, this.target.pos, this.speedModifier, 0);
        }
    }

    private void startOnReachedTargetInteraction(TransportItemTarget var0, PathfinderMob var1) {
        this.doReachedTargetInteraction(var1, var0.container, this.onReachedInteraction(ContainerInteractionState.PICKUP_ITEM), this.onReachedInteraction(ContainerInteractionState.PICKUP_NO_ITEM), this.onReachedInteraction(ContainerInteractionState.PLACE_ITEM), this.onReachedInteraction(ContainerInteractionState.PLACE_NO_ITEM));
        this.setTransportingState(TransportItemState.INTERACTING);
    }

    private void onStartTravelling(PathfinderMob var0) {
        this.onStartTravelling.accept(var0);
        this.setTransportingState(TransportItemState.TRAVELLING);
        this.interactionState = null;
        this.ticksSinceReachingTarget = 0;
    }

    private BiConsumer<PathfinderMob, Container> onReachedInteraction(ContainerInteractionState var0) {
        return (var1, var2) -> this.setInteractionState(var0);
    }

    private void setTransportingState(TransportItemState var0) {
        this.state = var0;
    }

    private void setInteractionState(ContainerInteractionState var0) {
        this.interactionState = var0;
    }

    private void onTargetInteraction(TransportItemTarget var0, PathfinderMob var1) {
        var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(var0.pos));
        this.stopInPlace(var1);
        if (this.interactionState != null) {
            Optional.ofNullable(this.onTargetInteractionActions.get((Object)this.interactionState)).ifPresent(var2 -> var2.accept(var1, var0, this.ticksSinceReachingTarget));
        }
    }

    private void doReachedTargetInteraction(PathfinderMob var0, Container var1, BiConsumer<PathfinderMob, Container> var2, BiConsumer<PathfinderMob, Container> var3, BiConsumer<PathfinderMob, Container> var4, BiConsumer<PathfinderMob, Container> var5) {
        if (TransportItemsBetweenContainers.isPickingUpItems(var0)) {
            if (TransportItemsBetweenContainers.matchesGettingItemsRequirement(var1)) {
                var2.accept(var0, var1);
            } else {
                var3.accept(var0, var1);
            }
        } else if (TransportItemsBetweenContainers.matchesLeavingItemsRequirement(var0, var1)) {
            var4.accept(var0, var1);
        } else {
            var5.accept(var0, var1);
        }
    }

    private Optional<TransportItemTarget> getTransportTarget(ServerLevel var0, PathfinderMob var1) {
        AABB var2 = this.getTargetSearchArea(var1);
        Set<GlobalPos> var3 = TransportItemsBetweenContainers.getVisitedPositions(var1);
        Set<GlobalPos> var4 = TransportItemsBetweenContainers.getUnreachablePositions(var1);
        List<ChunkPos> var5 = ChunkPos.rangeClosed(new ChunkPos(var1.blockPosition()), Math.floorDiv(this.getHorizontalSearchDistance(var1), 16) + 1).toList();
        TransportItemTarget var6 = null;
        double var7 = 3.4028234663852886E38;
        for (ChunkPos var10 : var5) {
            LevelChunk var11 = var0.getChunkSource().getChunkNow(var10.x, var10.z);
            if (var11 == null) continue;
            for (BlockEntity var13 : var11.getBlockEntities().values()) {
                TransportItemTarget var17;
                ChestBlockEntity var14;
                double var15;
                if (!(var13 instanceof ChestBlockEntity) || !((var15 = (var14 = (ChestBlockEntity)var13).getBlockPos().distToCenterSqr(var1.position())) < var7) || (var17 = this.isTargetValidToPick(var1, var0, var14, var3, var4, var2)) == null) continue;
                var6 = var17;
                var7 = var15;
            }
        }
        return var6 == null ? Optional.empty() : Optional.of(var6);
    }

    @Nullable
    private TransportItemTarget isTargetValidToPick(PathfinderMob var0, Level var1, BlockEntity var2, Set<GlobalPos> var3, Set<GlobalPos> var4, AABB var5) {
        BlockPos var6 = var2.getBlockPos();
        boolean var7 = var5.contains(var6.getX(), var6.getY(), var6.getZ());
        if (!var7) {
            return null;
        }
        TransportItemTarget var8 = TransportItemTarget.tryCreatePossibleTarget(var2, var1);
        if (var8 == null) {
            return null;
        }
        boolean var9 = this.isWantedBlock(var0, var8.state) && !this.isPositionAlreadyVisited(var3, var4, var8, var1) && !this.isContainerLocked(var8);
        return var9 ? var8 : null;
    }

    private boolean isContainerLocked(TransportItemTarget var0) {
        BaseContainerBlockEntity var1;
        BlockEntity blockEntity = var0.blockEntity;
        return blockEntity instanceof BaseContainerBlockEntity && (var1 = (BaseContainerBlockEntity)blockEntity).isLocked();
    }

    private boolean hasValidTarget(Level var0, PathfinderMob var1) {
        boolean var2;
        boolean bl = var2 = this.target != null && this.isWantedBlock(var1, this.target.state) && this.targetHasNotChanged(var0, this.target);
        if (var2 && !this.isTargetBlocked(var0, this.target)) {
            if (!this.state.equals((Object)TransportItemState.TRAVELLING)) {
                return true;
            }
            if (this.hasValidTravellingPath(var0, this.target, var1)) {
                return true;
            }
            this.markVisitedBlockPosAsUnreachable(var1, var0, this.target.pos);
        }
        return false;
    }

    private boolean hasValidTravellingPath(Level var0, TransportItemTarget var1, PathfinderMob var2) {
        Path var3 = var2.getNavigation().getPath() == null ? var2.getNavigation().createPath(var1.pos, 0) : var2.getNavigation().getPath();
        Vec3 var4 = this.getPositionToReachTargetFrom(var3, var2);
        boolean var5 = this.isWithinTargetDistance(TransportItemsBetweenContainers.getInteractionRange(var2), var1, var0, var2, var4);
        boolean var6 = var3 == null && !var5;
        return var6 || this.targetIsReachableFromPosition(var0, var5, var4, var1, var2);
    }

    private Vec3 getPositionToReachTargetFrom(@Nullable Path var0, PathfinderMob var1) {
        boolean var2 = var0 == null || var0.getEndNode() == null;
        Vec3 var3 = var2 ? var1.position() : var0.getEndNode().asBlockPos().getBottomCenter();
        return this.setMiddleYPosition(var1, var3);
    }

    private Vec3 setMiddleYPosition(PathfinderMob var0, Vec3 var1) {
        return var1.add(0.0, var0.getBoundingBox().getYsize() / 2.0, 0.0);
    }

    private boolean isTargetBlocked(Level var0, TransportItemTarget var1) {
        return ChestBlock.isChestBlockedAt(var0, var1.pos);
    }

    private boolean targetHasNotChanged(Level var0, TransportItemTarget var1) {
        return var1.blockEntity.equals(var0.getBlockEntity(var1.pos));
    }

    private Stream<TransportItemTarget> getConnectedTargets(TransportItemTarget var0, Level var1) {
        if (var0.state.getValueOrElse(ChestBlock.TYPE, ChestType.SINGLE) != ChestType.SINGLE) {
            TransportItemTarget var2 = TransportItemTarget.tryCreatePossibleTarget(ChestBlock.getConnectedBlockPos(var0.pos, var0.state), var1);
            return var2 != null ? Stream.of(var0, var2) : Stream.of(var0);
        }
        return Stream.of(var0);
    }

    private AABB getTargetSearchArea(PathfinderMob var0) {
        int var1 = this.getHorizontalSearchDistance(var0);
        return new AABB(var0.blockPosition()).inflate(var1, this.getVerticalSearchDistance(var0), var1);
    }

    private int getHorizontalSearchDistance(PathfinderMob var0) {
        return var0.isPassenger() ? 1 : this.horizontalSearchDistance;
    }

    private int getVerticalSearchDistance(PathfinderMob var0) {
        return var0.isPassenger() ? 1 : this.verticalSearchDistance;
    }

    private static Set<GlobalPos> getVisitedPositions(PathfinderMob var0) {
        return var0.getBrain().getMemory(MemoryModuleType.VISITED_BLOCK_POSITIONS).orElse(Set.of());
    }

    private static Set<GlobalPos> getUnreachablePositions(PathfinderMob var0) {
        return var0.getBrain().getMemory(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS).orElse(Set.of());
    }

    private boolean isPositionAlreadyVisited(Set<GlobalPos> var0, Set<GlobalPos> var12, TransportItemTarget var22, Level var3) {
        return this.getConnectedTargets(var22, var3).map(var1 -> new GlobalPos(var3.dimension(), var1.pos)).anyMatch(var2 -> var0.contains(var2) || var12.contains(var2));
    }

    private static boolean hasFinishedPath(PathfinderMob var0) {
        return var0.getNavigation().getPath() != null && var0.getNavigation().getPath().isDone();
    }

    protected void setVisitedBlockPos(PathfinderMob var0, Level var1, BlockPos var2) {
        HashSet<GlobalPos> var3 = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(var0));
        var3.add(new GlobalPos(var1.dimension(), var2));
        if (var3.size() > 10) {
            this.enterCooldownAfterNoMatchingTargetFound(var0);
        } else {
            var0.getBrain().setMemoryWithExpiry(MemoryModuleType.VISITED_BLOCK_POSITIONS, var3, 6000L);
        }
    }

    protected void markVisitedBlockPosAsUnreachable(PathfinderMob var0, Level var1, BlockPos var2) {
        HashSet<GlobalPos> var3 = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(var0));
        var3.remove(new GlobalPos(var1.dimension(), var2));
        HashSet<GlobalPos> var4 = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getUnreachablePositions(var0));
        var4.add(new GlobalPos(var1.dimension(), var2));
        if (var4.size() > 50) {
            this.enterCooldownAfterNoMatchingTargetFound(var0);
        } else {
            var0.getBrain().setMemoryWithExpiry(MemoryModuleType.VISITED_BLOCK_POSITIONS, var3, 6000L);
            var0.getBrain().setMemoryWithExpiry(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS, var4, 6000L);
        }
    }

    private boolean isWantedBlock(PathfinderMob var0, BlockState var1) {
        return TransportItemsBetweenContainers.isPickingUpItems(var0) ? this.sourceBlockType.test(var1) : this.destinationBlockType.test(var1);
    }

    private static double getInteractionRange(PathfinderMob var0) {
        return TransportItemsBetweenContainers.hasFinishedPath(var0) ? 1.0 : 0.5;
    }

    private boolean isWithinTargetDistance(double var0, TransportItemTarget var2, Level var3, PathfinderMob var4, Vec3 var5) {
        AABB var6 = var4.getBoundingBox();
        AABB var7 = AABB.ofSize(var5, var6.getXsize(), var6.getYsize(), var6.getZsize());
        return var2.state.getCollisionShape(var3, var2.pos).bounds().inflate(var0, 0.5, var0).move(var2.pos).intersects(var7);
    }

    private boolean targetIsReachableFromPosition(Level var0, boolean var1, Vec3 var2, TransportItemTarget var3, PathfinderMob var4) {
        return var1 && this.canSeeAnyTargetSide(var3, var0, var4, var2);
    }

    private boolean canSeeAnyTargetSide(TransportItemTarget var0, Level var12, PathfinderMob var2, Vec3 var32) {
        Vec3 var4 = var0.pos.getCenter();
        return Direction.stream().map(var1 -> var4.add(0.5 * (double)var1.getStepX(), 0.5 * (double)var1.getStepY(), 0.5 * (double)var1.getStepZ())).map(var3 -> var12.clip(new ClipContext(var32, (Vec3)var3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, var2))).anyMatch(var1 -> var1.getType() == HitResult.Type.BLOCK && var1.getBlockPos().equals(var0.pos));
    }

    private boolean isAnotherMobInteractingWithTarget(TransportItemTarget var0, Level var1) {
        return this.getConnectedTargets(var0, var1).anyMatch(this.shouldQueueForTarget);
    }

    private static boolean isPickingUpItems(PathfinderMob var0) {
        return var0.getMainHandItem().isEmpty();
    }

    private static boolean matchesGettingItemsRequirement(Container var0) {
        return !var0.isEmpty();
    }

    private static boolean matchesLeavingItemsRequirement(PathfinderMob var0, Container var1) {
        return var1.isEmpty() || TransportItemsBetweenContainers.hasItemMatchingHandItem(var0, var1);
    }

    private static boolean hasItemMatchingHandItem(PathfinderMob var0, Container var1) {
        ItemStack var2 = var0.getMainHandItem();
        for (ItemStack var4 : var1) {
            if (!ItemStack.isSameItem(var4, var2)) continue;
            return true;
        }
        return false;
    }

    private void pickUpItems(PathfinderMob var0, Container var1) {
        var0.setItemSlot(EquipmentSlot.MAINHAND, TransportItemsBetweenContainers.pickupItemFromContainer(var1));
        var0.setGuaranteedDrop(EquipmentSlot.MAINHAND);
        var1.setChanged();
        this.clearMemoriesAfterMatchingTargetFound(var0);
    }

    private void putDownItem(PathfinderMob var0, Container var1) {
        ItemStack var2 = TransportItemsBetweenContainers.addItemsToContainer(var0, var1);
        var1.setChanged();
        var0.setItemSlot(EquipmentSlot.MAINHAND, var2);
        if (var2.isEmpty()) {
            this.clearMemoriesAfterMatchingTargetFound(var0);
        } else {
            this.stopTargetingCurrentTarget(var0);
        }
    }

    private static ItemStack pickupItemFromContainer(Container var0) {
        int var1 = 0;
        for (ItemStack var3 : var0) {
            if (!var3.isEmpty()) {
                int var4 = Math.min(var3.getCount(), 16);
                return var0.removeItem(var1, var4);
            }
            ++var1;
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack addItemsToContainer(PathfinderMob var0, Container var1) {
        int var2 = 0;
        ItemStack var3 = var0.getMainHandItem();
        for (ItemStack var5 : var1) {
            if (var5.isEmpty()) {
                var1.setItem(var2, var3);
                return ItemStack.EMPTY;
            }
            if (ItemStack.isSameItemSameComponents(var5, var3) && var5.getCount() < var5.getMaxStackSize()) {
                int var6 = var5.getMaxStackSize() - var5.getCount();
                int var7 = Math.min(var6, var3.getCount());
                var5.setCount(var5.getCount() + var7);
                var3.setCount(var3.getCount() - var6);
                var1.setItem(var2, var5);
                if (var3.isEmpty()) {
                    return ItemStack.EMPTY;
                }
            }
            ++var2;
        }
        return var3;
    }

    protected void stopTargetingCurrentTarget(PathfinderMob var0) {
        this.ticksSinceReachingTarget = 0;
        this.target = null;
        var0.getNavigation().stop();
        var0.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    protected void clearMemoriesAfterMatchingTargetFound(PathfinderMob var0) {
        this.stopTargetingCurrentTarget(var0);
        var0.getBrain().eraseMemory(MemoryModuleType.VISITED_BLOCK_POSITIONS);
        var0.getBrain().eraseMemory(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS);
    }

    private void enterCooldownAfterNoMatchingTargetFound(PathfinderMob var0) {
        this.stopTargetingCurrentTarget(var0);
        var0.getBrain().setMemory(MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, 140);
        var0.getBrain().eraseMemory(MemoryModuleType.VISITED_BLOCK_POSITIONS);
        var0.getBrain().eraseMemory(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS);
    }

    @Override
    protected void stop(ServerLevel var0, PathfinderMob var1, long var2) {
        this.onStartTravelling(var1);
        PathNavigation pathNavigation = var1.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation var4 = (GroundPathNavigation)pathNavigation;
            var4.setCanPathToTargetsBelowSurface(false);
        }
    }

    private void stopInPlace(PathfinderMob var0) {
        var0.getNavigation().stop();
        var0.setXxa(0.0f);
        var0.setYya(0.0f);
        var0.setSpeed(0.0f);
        var0.setDeltaMovement(0.0, var0.getDeltaMovement().y, 0.0);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.canStillUse(serverLevel, (PathfinderMob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (PathfinderMob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (PathfinderMob)livingEntity, l);
    }

    public static final class TransportItemTarget
    extends Record {
        final BlockPos pos;
        final Container container;
        final BlockEntity blockEntity;
        final BlockState state;

        public TransportItemTarget(BlockPos var0, Container var1, BlockEntity var2, BlockState var3) {
            this.pos = var0;
            this.container = var1;
            this.blockEntity = var2;
            this.state = var3;
        }

        @Nullable
        public static TransportItemTarget tryCreatePossibleTarget(BlockEntity var0, Level var1) {
            BlockPos var2 = var0.getBlockPos();
            BlockState var3 = var0.getBlockState();
            Container var4 = TransportItemTarget.getBlockEntityContainer(var0, var3, var1, var2);
            if (var4 != null) {
                return new TransportItemTarget(var2, var4, var0, var3);
            }
            return null;
        }

        @Nullable
        public static TransportItemTarget tryCreatePossibleTarget(BlockPos var0, Level var1) {
            BlockEntity var2 = var1.getBlockEntity(var0);
            return var2 == null ? null : TransportItemTarget.tryCreatePossibleTarget(var2, var1);
        }

        @Nullable
        private static Container getBlockEntityContainer(BlockEntity var0, BlockState var1, Level var2, BlockPos var3) {
            Block block = var1.getBlock();
            if (block instanceof ChestBlock) {
                ChestBlock var4 = (ChestBlock)block;
                return ChestBlock.getContainer(var4, var1, var2, var3, false);
            }
            if (var0 instanceof Container) {
                Container var5 = (Container)((Object)var0);
                return var5;
            }
            return null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TransportItemTarget.class, "pos;container;blockEntity;state", "pos", "container", "blockEntity", "state"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TransportItemTarget.class, "pos;container;blockEntity;state", "pos", "container", "blockEntity", "state"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TransportItemTarget.class, "pos;container;blockEntity;state", "pos", "container", "blockEntity", "state"}, this, var0);
        }

        public BlockPos pos() {
            return this.pos;
        }

        public Container container() {
            return this.container;
        }

        public BlockEntity blockEntity() {
            return this.blockEntity;
        }

        public BlockState state() {
            return this.state;
        }
    }

    public static enum TransportItemState {
        TRAVELLING,
        QUEUING,
        INTERACTING;

    }

    public static enum ContainerInteractionState {
        PICKUP_ITEM,
        PICKUP_NO_ITEM,
        PLACE_ITEM,
        PLACE_NO_ITEM;

    }

    @FunctionalInterface
    public static interface OnTargetReachedInteraction
    extends TriConsumer<PathfinderMob, TransportItemTarget, Integer> {
    }
}

