/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;

public class FollowMobGoal
extends Goal {
    private final Mob mob;
    private final Predicate<Mob> followPredicate;
    @Nullable
    private Mob followingMob;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;
    private final float areaSize;

    public FollowMobGoal(Mob var0, double var12, float var3, float var4) {
        this.mob = var0;
        this.followPredicate = var1 -> var1 != null && var0.getClass() != var1.getClass();
        this.speedModifier = var12;
        this.navigation = var0.getNavigation();
        this.stopDistance = var3;
        this.areaSize = var4;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(var0.getNavigation() instanceof GroundPathNavigation) && !(var0.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    @Override
    public boolean canUse() {
        List<Mob> var0 = this.mob.level().getEntitiesOfClass(Mob.class, this.mob.getBoundingBox().inflate(this.areaSize), this.followPredicate);
        if (!var0.isEmpty()) {
            for (Mob var2 : var0) {
                if (var2.isInvisible()) continue;
                this.followingMob = var2;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canContinueToUse() {
        return this.followingMob != null && !this.navigation.isDone() && this.mob.distanceToSqr(this.followingMob) > (double)(this.stopDistance * this.stopDistance);
    }

    @Override
    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
        this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    public void stop() {
        this.followingMob = null;
        this.navigation.stop();
        this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    @Override
    public void tick() {
        double var4;
        double var2;
        if (this.followingMob == null || this.mob.isLeashed()) {
            return;
        }
        this.mob.getLookControl().setLookAt(this.followingMob, 10.0f, this.mob.getMaxHeadXRot());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.adjustedTickDelay(10);
        double var0 = this.mob.getX() - this.followingMob.getX();
        double var6 = var0 * var0 + (var2 = this.mob.getY() - this.followingMob.getY()) * var2 + (var4 = this.mob.getZ() - this.followingMob.getZ()) * var4;
        if (var6 <= (double)(this.stopDistance * this.stopDistance)) {
            this.navigation.stop();
            LookControl var8 = this.followingMob.getLookControl();
            if (var6 <= (double)this.stopDistance || var8.getWantedX() == this.mob.getX() && var8.getWantedY() == this.mob.getY() && var8.getWantedZ() == this.mob.getZ()) {
                double var9 = this.followingMob.getX() - this.mob.getX();
                double var11 = this.followingMob.getZ() - this.mob.getZ();
                this.navigation.moveTo(this.mob.getX() - var9, this.mob.getY(), this.mob.getZ() - var11, this.speedModifier);
            }
            return;
        }
        this.navigation.moveTo(this.followingMob, this.speedModifier);
    }
}

