/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.memory;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class NearestVisibleLivingEntities {
    private static final NearestVisibleLivingEntities EMPTY = new NearestVisibleLivingEntities();
    private final List<LivingEntity> nearbyEntities;
    private final Predicate<LivingEntity> lineOfSightTest;

    private NearestVisibleLivingEntities() {
        this.nearbyEntities = List.of();
        this.lineOfSightTest = var0 -> false;
    }

    public NearestVisibleLivingEntities(ServerLevel var0, LivingEntity var1, List<LivingEntity> var22) {
        this.nearbyEntities = var22;
        Object2BooleanOpenHashMap var3 = new Object2BooleanOpenHashMap(var22.size());
        Predicate<LivingEntity> var4 = var2 -> Sensor.isEntityTargetable(var0, var1, var2);
        this.lineOfSightTest = var2 -> var3.computeIfAbsent(var2, var4);
    }

    public static NearestVisibleLivingEntities empty() {
        return EMPTY;
    }

    public Optional<LivingEntity> findClosest(Predicate<LivingEntity> var0) {
        for (LivingEntity var2 : this.nearbyEntities) {
            if (!var0.test(var2) || !this.lineOfSightTest.test(var2)) continue;
            return Optional.of(var2);
        }
        return Optional.empty();
    }

    public Iterable<LivingEntity> findAll(Predicate<LivingEntity> var0) {
        return Iterables.filter(this.nearbyEntities, var1 -> var0.test((LivingEntity)var1) && this.lineOfSightTest.test((LivingEntity)var1));
    }

    public Stream<LivingEntity> find(Predicate<LivingEntity> var0) {
        return this.nearbyEntities.stream().filter(var1 -> var0.test((LivingEntity)var1) && this.lineOfSightTest.test((LivingEntity)var1));
    }

    public boolean contains(LivingEntity var0) {
        return this.nearbyEntities.contains(var0) && this.lineOfSightTest.test(var0);
    }

    public boolean contains(Predicate<LivingEntity> var0) {
        for (LivingEntity var2 : this.nearbyEntities) {
            if (!var0.test(var2) || !this.lineOfSightTest.test(var2)) continue;
            return true;
        }
        return false;
    }
}

