/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;

public interface Bucketable {
    public boolean fromBucket();

    public void setFromBucket(boolean var1);

    public void saveToBucketTag(ItemStack var1);

    public void loadFromBucketTag(CompoundTag var1);

    public ItemStack getBucketItemStack();

    public SoundEvent getPickupSound();

    @Deprecated
    public static void saveDefaultDataToBucketTag(Mob entityinsentient, ItemStack itemstack) {
        itemstack.copyFrom(DataComponents.CUSTOM_NAME, entityinsentient);
        CustomData.update(DataComponents.BUCKET_ENTITY_DATA, itemstack, nbttagcompound -> {
            if (entityinsentient.isNoAi()) {
                nbttagcompound.putBoolean("NoAI", entityinsentient.isNoAi());
            }
            if (entityinsentient.isSilent()) {
                nbttagcompound.putBoolean("Silent", entityinsentient.isSilent());
            }
            if (entityinsentient.isNoGravity()) {
                nbttagcompound.putBoolean("NoGravity", entityinsentient.isNoGravity());
            }
            if (entityinsentient.hasGlowingTag()) {
                nbttagcompound.putBoolean("Glowing", entityinsentient.hasGlowingTag());
            }
            if (entityinsentient.isInvulnerable()) {
                nbttagcompound.putBoolean("Invulnerable", entityinsentient.isInvulnerable());
            }
            nbttagcompound.putFloat("Health", entityinsentient.getHealth());
        });
    }

    @Deprecated
    public static void loadDefaultDataFromBucketTag(Mob entityinsentient, CompoundTag nbttagcompound) {
        Optional<Boolean> optional = nbttagcompound.getBoolean("NoAI");
        Objects.requireNonNull(entityinsentient);
        optional.ifPresent(entityinsentient::setNoAi);
        optional = nbttagcompound.getBoolean("Silent");
        Objects.requireNonNull(entityinsentient);
        optional.ifPresent(entityinsentient::setSilent);
        optional = nbttagcompound.getBoolean("NoGravity");
        Objects.requireNonNull(entityinsentient);
        optional.ifPresent(entityinsentient::setNoGravity);
        optional = nbttagcompound.getBoolean("Glowing");
        Objects.requireNonNull(entityinsentient);
        optional.ifPresent(entityinsentient::setGlowingTag);
        optional = nbttagcompound.getBoolean("Invulnerable");
        Objects.requireNonNull(entityinsentient);
        optional.ifPresent(entityinsentient::setInvulnerable);
        Optional<Float> optional2 = nbttagcompound.getFloat("Health");
        Objects.requireNonNull(entityinsentient);
        optional2.ifPresent(entityinsentient::setHealth);
    }

    public static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player entityhuman, InteractionHand enumhand, T t0) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (itemstack.getItem() == Items.WATER_BUCKET && t0.isAlive()) {
            ItemStack itemstack1 = ((Bucketable)((Object)t0)).getBucketItemStack();
            ((Bucketable)((Object)t0)).saveToBucketTag(itemstack1);
            PlayerBucketEntityEvent playerBucketFishEvent = CraftEventFactory.callPlayerFishBucketEvent(t0, entityhuman, itemstack, itemstack1, enumhand);
            itemstack1 = CraftItemStack.asNMSCopy(playerBucketFishEvent.getEntityBucket());
            if (playerBucketFishEvent.isCancelled()) {
                ((ServerPlayer)entityhuman).containerMenu.sendAllDataToRemote();
                t0.getBukkitEntity().update((ServerPlayer)entityhuman);
                t0.refreshEntityData((ServerPlayer)entityhuman);
                return Optional.of(InteractionResult.FAIL);
            }
            t0.playSound(((Bucketable)((Object)t0)).getPickupSound(), 1.0f, 1.0f);
            ItemStack itemstack2 = ItemUtils.createFilledResult(itemstack, entityhuman, itemstack1, false);
            entityhuman.setItemInHand(enumhand, itemstack2);
            Level world = t0.level();
            if (!world.isClientSide()) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)entityhuman, itemstack1);
            }
            t0.discard(EntityRemoveEvent.Cause.PICKUP);
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }
}

