/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.FishHook;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class FishingHook
extends Projectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomSource syncronizedRandom = RandomSource.create();
    private boolean biting;
    private int outOfWaterTime;
    private static final int MAX_OUT_OF_WATER_TIME = 10;
    public static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.defineId(FishingHook.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.defineId(FishingHook.class, EntityDataSerializers.BOOLEAN);
    private int life;
    private int nibble;
    public int timeUntilLured;
    public int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    @Nullable
    public Entity hookedIn;
    public FishHookState currentState = FishHookState.FLYING;
    private final int luck;
    private final int lureSpeed;
    private final InterpolationHandler interpolationHandler = new InterpolationHandler(this);
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private FishingHook(EntityType<? extends FishingHook> entitytypes, Level world, int i, int j) {
        super((EntityType<? extends Projectile>)entitytypes, world);
        this.luck = Math.max(0, i);
        this.lureSpeed = Math.max(0, j);
    }

    public FishingHook(EntityType<? extends FishingHook> entitytypes, Level world) {
        this(entitytypes, world, 0, 0);
    }

    public FishingHook(Player entityhuman, Level world, int i, int j) {
        this(EntityType.FISHING_BOBBER, world, i, j);
        this.setOwner(entityhuman);
        float f = entityhuman.getXRot();
        float f1 = entityhuman.getYRot();
        float f2 = Mth.cos(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = Mth.sin(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -Mth.cos(-f * ((float)Math.PI / 180));
        float f5 = Mth.sin(-f * ((float)Math.PI / 180));
        double d0 = entityhuman.getX() - (double)f3 * 0.3;
        double d1 = entityhuman.getEyeY();
        double d2 = entityhuman.getZ() - (double)f2 * 0.3;
        this.snapTo(d0, d1, d2, f1, f);
        Vec3 vec3d = new Vec3(-f3, Mth.clamp(-(f5 / f4), -5.0f, 5.0f), -f2);
        double d3 = vec3d.length();
        vec3d = vec3d.multiply(0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement(vec3d);
        this.setYRot((float)(Mth.atan2(vec3d.x, vec3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2(vec3d.y, vec3d.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    @Override
    @Nonnull
    public InterpolationHandler getInterpolation() {
        return this.interpolationHandler;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_HOOKED_ENTITY, 0);
        datawatcher_a.define(DATA_BITING, false);
    }

    @Override
    protected boolean shouldBounceOnWorldBorder() {
        return true;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (DATA_HOOKED_ENTITY.equals(datawatcherobject)) {
            int i = this.getEntityData().get(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedIn = i > 0 ? this.level().getEntity(i - 1) : null;
        }
        if (DATA_BITING.equals(datawatcherobject)) {
            this.biting = this.getEntityData().get(DATA_BITING);
            if (this.biting) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4f * Mth.nextFloat(this.syncronizedRandom, 0.6f, 1.0f), this.getDeltaMovement().z);
            }
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = 64.0;
        return d0 < 4096.0;
    }

    @Override
    public void tick() {
        this.syncronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
        this.getInterpolation().interpolate();
        super.tick();
        Player entityhuman = this.getPlayerOwner();
        if (entityhuman == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.level().isClientSide() || !this.shouldStopFishing(entityhuman)) {
            boolean flag;
            if (this.onGround()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos blockposition = this.blockPosition();
            FluidState fluid = this.level().getFluidState(blockposition);
            if (fluid.is(FluidTags.WATER)) {
                f = fluid.getHeight(this.level(), blockposition);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == FishHookState.FLYING) {
                if (this.hookedIn != null) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.currentState = FishHookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                    this.currentState = FishHookState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == FishHookState.HOOKED_IN_ENTITY) {
                    if (this.hookedIn != null) {
                        if (!this.hookedIn.isRemoved() && this.hookedIn.canInteractWithLevel() && this.hookedIn.level().dimension() == this.level().dimension()) {
                            this.setPos(this.hookedIn.getX(), this.hookedIn.getY(0.8), this.hookedIn.getZ());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = FishHookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == FishHookState.BOBBING) {
                    Vec3 vec3d = this.getDeltaMovement();
                    double d0 = this.getY() + vec3d.y - (double)blockposition.getY() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.setDeltaMovement(vec3d.x * 0.9, vec3d.y - d0 * (double)this.random.nextFloat() * 0.2, vec3d.z * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockposition);
                    }
                    if (flag) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
                        }
                        if (!this.level().isClientSide()) {
                            this.catchingFish(blockposition);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                    }
                }
            }
            if (!fluid.is(FluidTags.WATER) && !this.onGround() && this.hookedIn == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.applyEffectsFromBlocks();
            this.updateRotation();
            if (this.currentState == FishHookState.FLYING && (this.onGround() || this.horizontalCollision)) {
                this.setDeltaMovement(Vec3.ZERO);
            }
            double d1 = 0.92;
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
            this.reapplyPosition();
        }
    }

    private boolean shouldStopFishing(Player entityhuman) {
        if (entityhuman.canInteractWithLevel()) {
            ItemStack itemstack = entityhuman.getMainHandItem();
            ItemStack itemstack1 = entityhuman.getOffhandItem();
            boolean flag = itemstack.is(Items.FISHING_ROD);
            boolean flag1 = itemstack1.is(Items.FISHING_ROD);
            if ((flag || flag1) && this.distanceToSqr(entityhuman) <= 1024.0) {
                return false;
            }
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void checkCollision() {
        HitResult movingobjectposition = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        this.preHitTargetOrDeflectSelf(movingobjectposition);
    }

    @Override
    protected boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) || entity.isAlive() && entity instanceof ItemEntity;
    }

    @Override
    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        if (!this.level().isClientSide()) {
            this.setHookedEntity(movingobjectpositionentity.getEntity());
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult movingobjectpositionblock) {
        super.onHitBlock(movingobjectpositionblock);
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(movingobjectpositionblock.distanceTo(this)));
    }

    public void setHookedEntity(@Nullable Entity entity) {
        this.hookedIn = entity;
        this.getEntityData().set(DATA_HOOKED_ENTITY, entity == null ? 0 : entity.getId() + 1);
    }

    private void catchingFish(BlockPos blockposition) {
        ServerLevel worldserver = (ServerLevel)this.level();
        int i = 1;
        BlockPos blockposition1 = blockposition.above();
        if (this.rainInfluenced && this.random.nextFloat() < 0.25f && this.level().isRainingAt(blockposition1)) {
            ++i;
        }
        if (this.skyInfluenced && this.random.nextFloat() < 0.5f && !this.level().canSeeSky(blockposition1)) {
            --i;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.getEntityData().set(DATA_BITING, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)this.getPlayerOwner().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                double d2;
                double d1;
                this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float f1 = Mth.sin(f);
                float f2 = Mth.cos(f);
                double d0 = this.getX() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                BlockState iblockdata = worldserver.getBlockState(BlockPos.containing(d0, (d1 = (double)((float)Mth.floor(this.getY()) + 1.0f)) - 1.0, d2 = this.getZ() + (double)(f2 * (float)this.timeUntilHooked * 0.1f)));
                if (iblockdata.is(Blocks.WATER)) {
                    if (this.random.nextFloat() < 0.15f) {
                        worldserver.sendParticles(ParticleTypes.BUBBLE, d0, d1 - (double)0.1f, d2, 1, f1, 0.1, f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.sendParticles(ParticleTypes.FISHING, d0, d1, d2, 0, f4, 0.01, -f3, 1.0);
                    worldserver.sendParticles(ParticleTypes.FISHING, d0, d1, d2, 0, -f4, 0.01, f3, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)this.getPlayerOwner().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return;
                }
                this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                double d3 = this.getY() + 0.5;
                worldserver.sendParticles(ParticleTypes.BUBBLE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                worldserver.sendParticles(ParticleTypes.FISHING, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                this.nibble = Mth.nextInt(this.random, 20, 40);
                this.getEntityData().set(DATA_BITING, true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.random.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = Mth.nextFloat(this.random, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.nextFloat(this.random, 25.0f, 60.0f);
                double d4 = this.getX() + (double)(Mth.sin(f6) * f7) * 0.1;
                BlockState iblockdata1 = worldserver.getBlockState(BlockPos.containing(d4, (d5 = (double)((float)Mth.floor(this.getY()) + 1.0f)) - 1.0, d6 = this.getZ() + (double)(Mth.cos(f6) * f7) * 0.1));
                if (iblockdata1.is(Blocks.WATER)) {
                    worldserver.sendParticles(ParticleTypes.SPLASH, d4, d5, d6, 2 + this.random.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.nextFloat(this.random, this.minLureAngle, this.maxLureAngle);
                this.timeUntilHooked = Mth.nextInt(this.random, this.minLureTime, this.maxLureTime);
            }
        } else {
            this.timeUntilLured = Mth.nextInt(this.random, this.minWaitTime, this.maxWaitTime);
            this.timeUntilLured -= this.applyLure ? this.lureSpeed : 0;
        }
    }

    private boolean calculateOpenWater(BlockPos blockposition) {
        OpenWaterType entityfishinghook_waterposition = OpenWaterType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            OpenWaterType entityfishinghook_waterposition1 = this.getOpenWaterTypeForArea(blockposition.offset(-2, i, -2), blockposition.offset(2, i, 2));
            switch (entityfishinghook_waterposition1.ordinal()) {
                case 0: {
                    if (entityfishinghook_waterposition != OpenWaterType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (entityfishinghook_waterposition != OpenWaterType.ABOVE_WATER) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            entityfishinghook_waterposition = entityfishinghook_waterposition1;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(BlockPos blockposition, BlockPos blockposition1) {
        return BlockPos.betweenClosedStream(blockposition, blockposition1).map(this::getOpenWaterTypeForBlock).reduce((entityfishinghook_waterposition, entityfishinghook_waterposition1) -> entityfishinghook_waterposition == entityfishinghook_waterposition1 ? entityfishinghook_waterposition : OpenWaterType.INVALID).orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(BlockPos blockposition) {
        BlockState iblockdata = this.level().getBlockState(blockposition);
        if (!iblockdata.isAir() && !iblockdata.is(Blocks.LILY_PAD)) {
            FluidState fluid = iblockdata.getFluidState();
            return fluid.is(FluidTags.WATER) && fluid.isSource() && iblockdata.getCollisionShape(this.level(), blockposition).isEmpty() ? OpenWaterType.INSIDE_WATER : OpenWaterType.INVALID;
        }
        return OpenWaterType.ABOVE_WATER;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
    }

    public int retrieve(ItemStack itemstack) {
        Player entityhuman = this.getPlayerOwner();
        if (!this.level().isClientSide() && entityhuman != null && !this.shouldStopFishing(entityhuman)) {
            PlayerFishEvent playerFishEvent;
            int i = 0;
            if (this.hookedIn != null) {
                playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)this.hookedIn.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_ENTITY);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                this.pullEntity(this.hookedIn);
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)entityhuman, itemstack, this, Collections.emptyList());
                this.level().broadcastEntityEvent(this, (byte)31);
                i = this.hookedIn instanceof ItemEntity ? 3 : 5;
            } else if (this.nibble > 0) {
                LootParams lootparams = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.TOOL, itemstack).withParameter(LootContextParams.THIS_ENTITY, this).withLuck((float)this.luck + entityhuman.getLuck()).create(LootContextParamSets.FISHING);
                LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
                ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams);
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)entityhuman, itemstack, this, (Collection<ItemStack>)list);
                for (ItemStack itemstack1 : list) {
                    ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemstack1);
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)entityitem.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.random.nextInt(6) + 1);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent2);
                    if (playerFishEvent2.isCancelled()) {
                        return 0;
                    }
                    double d0 = entityhuman.getX() - this.getX();
                    double d1 = entityhuman.getY() - this.getY();
                    double d2 = entityhuman.getZ() - this.getZ();
                    double d3 = 0.1;
                    entityitem.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.level().addFreshEntity(entityitem);
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        entityhuman.level().addFreshEntity(new ExperienceOrb(entityhuman.level(), entityhuman.getX(), entityhuman.getY() + 0.5, entityhuman.getZ() + 0.5, playerFishEvent2.getExpToDrop()));
                    }
                    if (!itemstack1.is(ItemTags.FISHES)) continue;
                    entityhuman.awardStat(Stats.FISH_CAUGHT, 1);
                }
                i = 1;
            }
            if (this.onGround()) {
                playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.IN_GROUND);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                i = 2;
            }
            if (i == 0) {
                playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.REEL_IN);
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i;
        }
        return 0;
    }

    @Override
    public void handleEntityEvent(byte b0) {
        Player entityhuman;
        Entity entity;
        if (b0 == 31 && this.level().isClientSide() && (entity = this.hookedIn) instanceof Player && (entityhuman = (Player)entity).isLocalPlayer()) {
            this.pullEntity(this.hookedIn);
        }
        super.handleEntityEvent(b0);
    }

    public void pullEntity(Entity entity) {
        Entity entity1 = this.getOwner();
        if (entity1 != null) {
            Vec3 vec3d = new Vec3(entity1.getX() - this.getX(), entity1.getY() - this.getY(), entity1.getZ() - this.getZ()).scale(0.1);
            entity.setDeltaMovement(entity.getDeltaMovement().add(vec3d));
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.updateOwnerInfo(null);
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    @Override
    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable FishingHook entityfishinghook) {
        Player entityhuman = this.getPlayerOwner();
        if (entityhuman != null) {
            entityhuman.fishing = entityfishinghook;
        }
    }

    @Nullable
    public Player getPlayerOwner() {
        Player entityhuman1;
        Entity entity = this.getOwner();
        Player entityhuman = entity instanceof Player ? (entityhuman1 = (Player)entity) : null;
        return entityhuman;
    }

    @Nullable
    public Entity getHookedIn() {
        return this.hookedIn;
    }

    @Override
    public boolean canUsePortal(boolean flag) {
        return false;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entitytrackerentry) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entitytrackerentry, entity == null ? this.getId() : entity.getId());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        if (this.getPlayerOwner() == null) {
            int i = packetplayoutspawnentity.getData();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.level().getEntity(i), (Object)i);
            this.discard(null);
        }
    }

    public static enum FishHookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    private static enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

