/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;

public class LlamaSpit
extends Projectile {
    public LlamaSpit(EntityType<? extends LlamaSpit> entitytypes, Level world) {
        super((EntityType<? extends Projectile>)entitytypes, world);
    }

    public LlamaSpit(Level world, Llama entityllama) {
        this((EntityType<? extends LlamaSpit>)EntityType.LLAMA_SPIT, world);
        this.setOwner(entityllama);
        this.setPos(entityllama.getX() - (double)(entityllama.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin(entityllama.yBodyRot * ((float)Math.PI / 180)), entityllama.getEyeY() - (double)0.1f, entityllama.getZ() + (double)(entityllama.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos(entityllama.yBodyRot * ((float)Math.PI / 180)));
    }

    @Override
    protected double getDefaultGravity() {
        return 0.06;
    }

    @Override
    public void tick() {
        super.tick();
        Vec3 vec3d = this.getDeltaMovement();
        HitResult movingobjectposition = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        this.preHitTargetOrDeflectSelf(movingobjectposition);
        double d0 = this.getX() + vec3d.x;
        double d1 = this.getY() + vec3d.y;
        double d2 = this.getZ() + vec3d.z;
        this.updateRotation();
        float f = 0.99f;
        if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.isInWater()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.setDeltaMovement(vec3d.scale(0.99f));
            this.applyGravity();
            this.setPos(d0, d1, d2);
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            ServerLevel worldserver;
            LivingEntity entityliving = (LivingEntity)entity;
            entity = movingobjectpositionentity.getEntity();
            DamageSource damagesource = this.damageSources().spit(this, entityliving);
            Level world = this.level();
            if (world instanceof ServerLevel && entity.hurtServer(worldserver = (ServerLevel)world, damagesource, 1.0f)) {
                EnchantmentHelper.doPostAttackEffects(worldserver, entity, damagesource);
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult movingobjectpositionblock) {
        super.onHitBlock(movingobjectpositionblock);
        if (!this.level().isClientSide()) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        Vec3 vec3d = packetplayoutspawnentity.getMovement();
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            this.level().addParticle(ParticleTypes.SPIT, this.getX(), this.getY(), this.getZ(), vec3d.x * d0, vec3d.y, vec3d.z * d0);
        }
        this.setDeltaMovement(vec3d);
    }
}

