/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class SpectralArrow
extends AbstractArrow {
    private static final int DEFAULT_DURATION = 200;
    public int duration = 200;

    public SpectralArrow(EntityType<? extends SpectralArrow> entitytypes, Level world) {
        super((EntityType<? extends AbstractArrow>)entitytypes, world);
    }

    public SpectralArrow(Level world, LivingEntity entityliving, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        super(EntityType.SPECTRAL_ARROW, entityliving, world, itemstack, itemstack1);
    }

    public SpectralArrow(Level world, double d0, double d1, double d2, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        super(EntityType.SPECTRAL_ARROW, d0, d1, d2, world, itemstack, itemstack1);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide() && !this.isInGround()) {
            this.level().addParticle(SpellParticleOption.create(ParticleTypes.EFFECT, -1, 1.0f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void doPostHurtEffects(LivingEntity entityliving) {
        super.doPostHurtEffects(entityliving);
        MobEffectInstance mobeffect = new MobEffectInstance(MobEffects.GLOWING, this.duration, 0);
        entityliving.addEffect(mobeffect, this.getEffectSource(), EntityPotionEffectEvent.Cause.ARROW);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.duration = valueinput.getIntOr("Duration", 200);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putInt("Duration", this.duration);
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(Items.SPECTRAL_ARROW);
    }
}

