/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class ThrowableProjectile
extends Projectile {
    private static final float MIN_CAMERA_DISTANCE_SQUARED = 12.25f;

    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> entitytypes, Level world) {
        super((EntityType<? extends Projectile>)entitytypes, world);
    }

    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> entitytypes, double d0, double d1, double d2, Level world) {
        this(entitytypes, world);
        this.setPos(d0, d1, d2);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        if (this.tickCount < 2 && d0 < 12.25) {
            return false;
        }
        double d1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return d0 < (d1 *= 64.0) * d1;
    }

    @Override
    public boolean canUsePortal(boolean flag) {
        return true;
    }

    @Override
    public void tick() {
        this.handleFirstTickBubbleColumn();
        this.applyGravity();
        this.applyInertia();
        HitResult movingobjectposition = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        Vec3 vec3d = movingobjectposition.getType() != HitResult.Type.MISS ? movingobjectposition.getLocation() : this.position().add(this.getDeltaMovement());
        this.setPos(vec3d);
        this.updateRotation();
        this.applyEffectsFromBlocks();
        super.tick();
        if (movingobjectposition.getType() != HitResult.Type.MISS && this.isAlive()) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
        }
    }

    private void applyInertia() {
        float f;
        Vec3 vec3d = this.getDeltaMovement();
        Vec3 vec3d1 = this.position();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f1 = 0.25f;
                this.level().addParticle(ParticleTypes.BUBBLE, vec3d1.x - vec3d.x * 0.25, vec3d1.y - vec3d.y * 0.25, vec3d1.z - vec3d.z * 0.25, vec3d.x, vec3d.y, vec3d.z);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.setDeltaMovement(vec3d.scale(f));
    }

    private void handleFirstTickBubbleColumn() {
        if (this.firstTick) {
            for (BlockPos blockposition : BlockPos.betweenClosed(this.getBoundingBox())) {
                BlockState iblockdata = this.level().getBlockState(blockposition);
                if (!iblockdata.is(Blocks.BUBBLE_COLUMN)) continue;
                iblockdata.entityInside(this.level(), blockposition, this, InsideBlockEffectApplier.NOOP, true);
            }
        }
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }
}

