/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.variant;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class VariantUtils {
    public static final String TAG_VARIANT = "variant";

    public static <T> Holder<T> getDefaultOrAny(RegistryAccess var0, ResourceKey<T> var1) {
        HolderLookup.RegistryLookup var2 = var0.lookupOrThrow(var1.registryKey());
        return (Holder)var2.get(var1).or(((Registry)var2)::getAny).orElseThrow();
    }

    public static <T> Holder<T> getAny(RegistryAccess var0, ResourceKey<? extends Registry<T>> var1) {
        return var0.lookupOrThrow(var1).getAny().orElseThrow();
    }

    public static <T> void writeVariant(ValueOutput var0, Holder<T> var12) {
        var12.unwrapKey().ifPresent(var1 -> var0.store(TAG_VARIANT, ResourceLocation.CODEC, var1.location()));
    }

    public static <T> Optional<Holder<T>> readVariant(ValueInput var0, ResourceKey<? extends Registry<T>> var12) {
        return var0.read(TAG_VARIANT, ResourceLocation.CODEC).map(var1 -> ResourceKey.create(var12, var1)).flatMap(var0.lookup()::get);
    }

    public static <T extends PriorityProvider<SpawnContext, ?>> Optional<Holder.Reference<T>> selectVariantToSpawn(SpawnContext var0, ResourceKey<Registry<T>> var1) {
        ServerLevelAccessor var2 = var0.level();
        Stream var3 = var2.registryAccess().lookupOrThrow(var1).listElements();
        return PriorityProvider.pick(var3, Holder::value, var2.getRandom(), var0);
    }
}

