/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public abstract class AbstractCraftingMenu
extends RecipeBookMenu {
    private final int width;
    private final int height;
    public final TransientCraftingContainer m;
    public final ResultContainer resultSlots = new ResultContainer();

    public AbstractCraftingMenu(MenuType<?> containers, int i, int j, int k, Inventory playerInventory) {
        super(containers, i);
        this.width = j;
        this.height = k;
        this.m = new TransientCraftingContainer((AbstractContainerMenu)this, j, k, playerInventory.player);
        this.m.resultInventory = this.resultSlots;
    }

    protected Slot addResultSlot(Player entityhuman, int i, int j) {
        return this.addSlot(new ResultSlot(entityhuman, this.m, this.resultSlots, 0, i, j));
    }

    protected void addCraftingGridSlots(int i, int j) {
        for (int k = 0; k < this.width; ++k) {
            for (int l = 0; l < this.height; ++l) {
                this.addSlot(new Slot(this.m, l + k * this.width, i + l * 18, j + k * 18));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean flag, boolean flag1, RecipeHolder<?> recipeholder, ServerLevel worldserver, Inventory playerinventory) {
        RecipeBookMenu.PostPlaceAction containerrecipebook_a;
        RecipeHolder<CraftingRecipe> recipeholder1 = recipeholder;
        this.beginPlacingRecipe();
        try {
            List<Slot> list = this.getInputGridSlots();
            containerrecipebook_a = ServerPlaceRecipe.placeRecipe(new ServerPlaceRecipe.CraftingMenuAccess<CraftingRecipe>(){

                @Override
                public void fillCraftSlotsStackedContents(StackedItemContents stackeditemcontents) {
                    AbstractCraftingMenu.this.fillCraftSlotsStackedContents(stackeditemcontents);
                }

                @Override
                public void clearCraftingContent() {
                    AbstractCraftingMenu.this.resultSlots.clearContent();
                    AbstractCraftingMenu.this.m.clearContent();
                }

                @Override
                public boolean recipeMatches(RecipeHolder<CraftingRecipe> recipeholder2) {
                    return recipeholder2.value().matches(AbstractCraftingMenu.this.m.asCraftInput(), AbstractCraftingMenu.this.owner().level());
                }
            }, this.width, this.height, list, list, playerinventory, recipeholder1, flag, flag1);
        }
        finally {
            this.finishPlacingRecipe(worldserver, recipeholder1);
        }
        return containerrecipebook_a;
    }

    protected void beginPlacingRecipe() {
    }

    protected void finishPlacingRecipe(ServerLevel worldserver, RecipeHolder<CraftingRecipe> recipeholder) {
    }

    public abstract Slot getResultSlot();

    public abstract List<Slot> getInputGridSlots();

    public int getGridWidth() {
        return this.width;
    }

    public int getGridHeight() {
        return this.height;
    }

    protected abstract Player owner();

    @Override
    public void fillCraftSlotsStackedContents(StackedItemContents stackeditemcontents) {
        this.m.fillStackedContents(stackeditemcontents);
    }
}

