/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CrafterSlot;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.NonInteractiveResultSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.CrafterBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryCrafter;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.CraftCrafterView;
import org.bukkit.entity.HumanEntity;

public class CrafterMenu
extends AbstractContainerMenu
implements ContainerListener {
    private CraftCrafterView bukkitEntity = null;
    protected static final int SLOT_COUNT = 9;
    private static final int INV_SLOT_START = 9;
    private static final int INV_SLOT_END = 36;
    private static final int USE_ROW_SLOT_START = 36;
    private static final int USE_ROW_SLOT_END = 45;
    private final ResultContainer resultContainer = new ResultContainer();
    private final ContainerData containerData;
    private final Player player;
    private final CraftingContainer container;

    @Override
    public CraftCrafterView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryCrafter inventory = new CraftInventoryCrafter(this.container, this.resultContainer);
        this.bukkitEntity = new CraftCrafterView((HumanEntity)this.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    @Override
    public void startOpen() {
        super.startOpen();
        this.refreshRecipeResult();
    }

    public CrafterMenu(int i, Inventory playerinventory) {
        super(MenuType.CRAFTER_3x3, i);
        this.player = playerinventory.player;
        this.containerData = new SimpleContainerData(10);
        this.container = new TransientCraftingContainer(this, 3, 3);
        this.addSlots(playerinventory);
    }

    public CrafterMenu(int i, Inventory playerinventory, CraftingContainer inventorycrafting, ContainerData icontainerproperties) {
        super(MenuType.CRAFTER_3x3, i);
        this.player = playerinventory.player;
        this.containerData = icontainerproperties;
        this.container = inventorycrafting;
        CrafterMenu.checkContainerSize(inventorycrafting, 9);
        inventorycrafting.startOpen(playerinventory.player);
        this.addSlots(playerinventory);
        this.addSlotListener(this);
    }

    private void addSlots(Inventory playerinventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = j + i * 3;
                this.addSlot(new CrafterSlot(this.container, k, 26 + j * 18, 17 + i * 18, this));
            }
        }
        this.addStandardInventorySlots(playerinventory, 8, 84);
        this.addSlot(new NonInteractiveResultSlot(this.resultContainer, 0, 134, 35));
        this.addDataSlots(this.containerData);
        this.refreshRecipeResult();
    }

    public void setSlotState(int i, boolean flag) {
        CrafterSlot crafterslot = (CrafterSlot)this.getSlot(i);
        this.containerData.set(crafterslot.index, flag ? 0 : 1);
        this.broadcastChanges();
    }

    public boolean isSlotDisabled(int i) {
        return i > -1 && i < 9 ? this.containerData.get(i) == 1 : false;
    }

    public boolean isPowered() {
        return this.containerData.get(9) == 1;
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i < 9 ? !this.moveItemStackTo(itemstack1, 9, 45, true) : !this.moveItemStackTo(itemstack1, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.container.stillValid(entityhuman);
    }

    private void refreshRecipeResult() {
        if (!this.opened) {
            return;
        }
        Player entityhuman = this.player;
        if (entityhuman instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entityhuman;
            ServerLevel worldserver = entityplayer.level();
            CraftingInput craftinginput = this.container.asCraftInput();
            Optional<RecipeHolder<CraftingRecipe>> recipe = CrafterBlock.getPotentialResults(worldserver, craftinginput);
            ItemStack itemstack = recipe.map(recipeholder -> ((CraftingRecipe)recipeholder.value()).assemble(craftinginput, worldserver.registryAccess())).orElse(ItemStack.EMPTY);
            itemstack = CraftEventFactory.callPreCraftEvent(this.container, this.resultContainer, itemstack, this.getBukkitView(), recipe);
            this.resultContainer.setItem(0, itemstack);
        }
    }

    public Container getContainer() {
        return this.container;
    }

    @Override
    public void slotChanged(AbstractContainerMenu container, int i, ItemStack itemstack) {
        this.refreshRecipeResult();
    }

    @Override
    public void dataChanged(AbstractContainerMenu container, int i, int j) {
    }
}

