/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockItem
extends Item {
    @Deprecated
    private final Block block;

    public BlockItem(Block block, Item.Properties item_info) {
        super(item_info);
        this.block = block;
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        InteractionResult enuminteractionresult = this.place(new BlockPlaceContext(itemactioncontext));
        return !enuminteractionresult.consumesAction() && itemactioncontext.getItemInHand().has(DataComponents.CONSUMABLE) ? super.use(itemactioncontext.getLevel(), itemactioncontext.getPlayer(), itemactioncontext.getHand()) : enuminteractionresult;
    }

    public InteractionResult place(BlockPlaceContext blockactioncontext) {
        if (!this.getBlock().isEnabled(blockactioncontext.getLevel().enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (!blockactioncontext.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockactioncontext1 = this.updatePlacementContext(blockactioncontext);
        if (blockactioncontext1 == null) {
            return InteractionResult.FAIL;
        }
        BlockState iblockdata = this.getPlacementState(blockactioncontext1);
        CraftBlockState blockstate = null;
        if (this instanceof PlaceOnWaterBlockItem || this instanceof SolidBucketItem) {
            blockstate = CraftBlockStates.getBlockState(blockactioncontext1.getLevel(), blockactioncontext1.getClickedPos());
        }
        if (iblockdata == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockactioncontext1, iblockdata)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockposition = blockactioncontext1.getClickedPos();
        Level world = blockactioncontext1.getLevel();
        Player entityhuman = blockactioncontext1.getPlayer();
        ItemStack itemstack = blockactioncontext1.getItemInHand();
        BlockState iblockdata1 = world.getBlockState(blockposition);
        if (iblockdata1.is(iblockdata.getBlock())) {
            BlockPlaceEvent placeEvent;
            iblockdata1 = this.updateBlockStateFromTag(blockposition, world, itemstack, iblockdata1);
            this.updateCustomBlockEntityTag(blockposition, world, entityhuman, itemstack, iblockdata1);
            BlockItem.updateBlockEntityComponents(world, blockposition, itemstack);
            iblockdata1.getBlock().setPlacedBy(world, blockposition, iblockdata1, entityhuman, itemstack);
            if (blockstate != null && (placeEvent = CraftEventFactory.callBlockPlaceEvent((ServerLevel)world, entityhuman, blockactioncontext1.getHand(), blockstate, blockposition.getX(), blockposition.getY(), blockposition.getZ())) != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                blockstate.update(true, false);
                if (this instanceof SolidBucketItem) {
                    ((ServerPlayer)entityhuman).getBukkitEntity().updateInventory();
                }
                return InteractionResult.FAIL;
            }
            if (entityhuman instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)entityhuman, blockposition, itemstack);
            }
        }
        SoundType soundeffecttype = iblockdata1.getSoundType();
        world.gameEvent(GameEvent.BLOCK_PLACE, blockposition, GameEvent.Context.of(entityhuman, iblockdata1));
        itemstack.consume(1, entityhuman);
        return InteractionResult.SUCCESS;
    }

    protected SoundEvent getPlaceSound(BlockState iblockdata) {
        return iblockdata.getSoundType().getPlaceSound();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext blockactioncontext) {
        return blockactioncontext;
    }

    private static void updateBlockEntityComponents(Level world, BlockPos blockposition, ItemStack itemstack) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity != null) {
            tileentity.applyComponentsFromItemStack(itemstack);
            tileentity.setChanged();
        }
    }

    protected boolean updateCustomBlockEntityTag(BlockPos blockposition, Level world, @Nullable Player entityhuman, ItemStack itemstack, BlockState iblockdata) {
        return BlockItem.updateCustomBlockEntityTag(world, entityhuman, blockposition, itemstack);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext blockactioncontext) {
        BlockState iblockdata = this.getBlock().getStateForPlacement(blockactioncontext);
        return iblockdata != null && this.canPlace(blockactioncontext, iblockdata) ? iblockdata : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos blockposition, Level world, ItemStack itemstack, BlockState iblockdata) {
        BlockItemStateProperties blockitemstateproperties = itemstack.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY);
        if (blockitemstateproperties.isEmpty()) {
            return iblockdata;
        }
        BlockState iblockdata1 = blockitemstateproperties.apply(iblockdata);
        if (iblockdata1 != iblockdata) {
            world.setBlock(blockposition, iblockdata1, 2);
        }
        return iblockdata1;
    }

    protected boolean canPlace(BlockPlaceContext blockactioncontext, BlockState iblockdata) {
        Player entityhuman = blockactioncontext.getPlayer();
        boolean defaultReturn = (!this.mustSurvive() || iblockdata.canSurvive(blockactioncontext.getLevel(), blockactioncontext.getClickedPos())) && blockactioncontext.getLevel().isUnobstructed(iblockdata, blockactioncontext.getClickedPos(), CollisionContext.placementContext(entityhuman));
        org.bukkit.entity.Player player = blockactioncontext.getPlayer() instanceof ServerPlayer ? (org.bukkit.entity.Player)blockactioncontext.getPlayer().getBukkitEntity() : null;
        BlockCanBuildEvent event = new BlockCanBuildEvent((org.bukkit.block.Block)CraftBlock.at(blockactioncontext.getLevel(), blockactioncontext.getClickedPos()), player, (BlockData)CraftBlockData.fromData(iblockdata), defaultReturn);
        blockactioncontext.getLevel().getCraftServer().getPluginManager().callEvent((Event)event);
        return event.isBuildable();
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext blockactioncontext, BlockState iblockdata) {
        return blockactioncontext.getLevel().setBlock(blockactioncontext.getClickedPos(), iblockdata, 11);
    }

    public static boolean updateCustomBlockEntityTag(Level world, @Nullable Player entityhuman, BlockPos blockposition, ItemStack itemstack) {
        BlockEntity tileentity;
        if (world.isClientSide()) {
            return false;
        }
        TypedEntityData<BlockEntityType<?>> typedentitydata = itemstack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (typedentitydata != null && (tileentity = world.getBlockEntity(blockposition)) != null) {
            BlockEntityType<?> tileentitytypes = tileentity.getType();
            if (tileentitytypes != typedentitydata.type()) {
                return false;
            }
            if (!tileentitytypes.onlyOpCanSetNbt() || entityhuman != null && (entityhuman.canUseGameMasterBlocks() || entityhuman.getAbilities().instabuild && entityhuman.getBukkitEntity().hasPermission("minecraft.nbt.place"))) {
                return typedentitydata.loadInto(tileentity, world.registryAccess());
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean shouldPrintOpWarning(ItemStack itemstack, @Nullable Player entityhuman) {
        TypedEntityData<BlockEntityType<?>> typedentitydata;
        if (entityhuman != null && entityhuman.getPermissionLevel() >= 2 && (typedentitydata = itemstack.get(DataComponents.BLOCK_ENTITY_DATA)) != null) {
            return typedentitydata.type().onlyOpCanSetNbt();
        }
        return false;
    }

    public Block getBlock() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> map, Item item) {
        map.put(this.getBlock(), item);
    }

    @Override
    public boolean canFitInsideContainerItems() {
        return !(this.getBlock() instanceof ShulkerBoxBlock);
    }

    @Override
    public void onDestroyed(ItemEntity entityitem) {
        ItemContainerContents itemcontainercontents = entityitem.getItem().set(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        if (itemcontainercontents != null) {
            ItemUtils.onContainerDestroyed(entityitem, itemcontainercontents.nonEmptyItemsCopy());
        }
    }

    public static void setBlockEntityData(ItemStack itemstack, BlockEntityType<?> tileentitytypes, TagValueOutput tagvalueoutput) {
        tagvalueoutput.discard("id");
        if (tagvalueoutput.isEmpty()) {
            itemstack.remove(DataComponents.BLOCK_ENTITY_DATA);
        } else {
            BlockEntity.addEntityType(tagvalueoutput, tileentitytypes);
            itemstack.set(DataComponents.BLOCK_ENTITY_DATA, TypedEntityData.of(tileentitytypes, tagvalueoutput.buildResult()));
        }
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.getBlock().requiredFeatures();
    }
}

