/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EnderpearlItem
extends Item {
    public static float PROJECTILE_SHOOT_POWER = 1.5f;

    public EnderpearlItem(Item.Properties item_info) {
        super(item_info);
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ServerLevel worldserver;
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (world instanceof ServerLevel && Projectile.spawnProjectileFromRotation(ThrownEnderpearl::new, worldserver = (ServerLevel)world, itemstack, entityhuman, 0.0f, PROJECTILE_SHOOT_POWER, 1.0f).isRemoved()) {
            if (entityhuman instanceof ServerPlayer) {
                ((ServerPlayer)entityhuman).getBukkitEntity().updateInventory();
            }
            return InteractionResult.FAIL;
        }
        world.playSound((Entity)null, entityhuman.getX(), entityhuman.getY(), entityhuman.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        entityhuman.awardStat(Stats.ITEM_USED.get(this));
        itemstack.consume(1, entityhuman);
        return InteractionResult.SUCCESS;
    }
}

