/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface SignalGetter
extends BlockGetter {
    public static final Direction[] DIRECTIONS = Direction.values();

    default public int getDirectSignal(BlockPos var0, Direction var1) {
        return this.getBlockState(var0).getDirectSignal(this, var0, var1);
    }

    default public int getDirectSignalTo(BlockPos var0) {
        int var1 = 0;
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.below(), Direction.DOWN))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.above(), Direction.UP))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.north(), Direction.NORTH))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.south(), Direction.SOUTH))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.west(), Direction.WEST))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.east(), Direction.EAST))) >= 15) {
            return var1;
        }
        return var1;
    }

    default public int getControlInputSignal(BlockPos var0, Direction var1, boolean var2) {
        BlockState var3 = this.getBlockState(var0);
        if (var2) {
            return DiodeBlock.isDiode(var3) ? this.getDirectSignal(var0, var1) : 0;
        }
        if (var3.is(Blocks.REDSTONE_BLOCK)) {
            return 15;
        }
        if (var3.is(Blocks.REDSTONE_WIRE)) {
            return var3.getValue(RedStoneWireBlock.POWER);
        }
        if (var3.isSignalSource()) {
            return this.getDirectSignal(var0, var1);
        }
        return 0;
    }

    default public boolean hasSignal(BlockPos var0, Direction var1) {
        return this.getSignal(var0, var1) > 0;
    }

    default public int getSignal(BlockPos var0, Direction var1) {
        BlockState var2 = this.getBlockState(var0);
        int var3 = var2.getSignal(this, var0, var1);
        if (var2.isRedstoneConductor(this, var0)) {
            return Math.max(var3, this.getDirectSignalTo(var0));
        }
        return var3;
    }

    default public boolean hasNeighborSignal(BlockPos var0) {
        if (this.getSignal(var0.below(), Direction.DOWN) > 0) {
            return true;
        }
        if (this.getSignal(var0.above(), Direction.UP) > 0) {
            return true;
        }
        if (this.getSignal(var0.north(), Direction.NORTH) > 0) {
            return true;
        }
        if (this.getSignal(var0.south(), Direction.SOUTH) > 0) {
            return true;
        }
        if (this.getSignal(var0.west(), Direction.WEST) > 0) {
            return true;
        }
        return this.getSignal(var0.east(), Direction.EAST) > 0;
    }

    default public int getBestNeighborSignal(BlockPos var0) {
        int var1 = 0;
        for (Direction var5 : DIRECTIONS) {
            int var6 = this.getSignal(var0.relative(var5), var5);
            if (var6 >= 15) {
                return 15;
            }
            if (var6 <= var1) continue;
            var1 = var6;
        }
        return var1;
    }
}

