/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BambooStalkBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<BambooStalkBlock> CODEC = BambooStalkBlock.simpleCodec(BambooStalkBlock::new);
    private static final VoxelShape SHAPE_SMALL = Block.column(6.0, 0.0, 16.0);
    private static final VoxelShape SHAPE_LARGE = Block.column(10.0, 0.0, 16.0);
    private static final VoxelShape SHAPE_COLLISION = Block.column(3.0, 0.0, 16.0);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    public static final EnumProperty<BambooLeaves> LEAVES = BlockStateProperties.BAMBOO_LEAVES;
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;
    public static final int MAX_HEIGHT = 16;
    public static final int STAGE_GROWING = 0;
    public static final int STAGE_DONE_GROWING = 1;
    public static final int AGE_THIN_BAMBOO = 0;
    public static final int AGE_THICK_BAMBOO = 1;

    public MapCodec<BambooStalkBlock> codec() {
        return CODEC;
    }

    public BambooStalkBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0)).setValue(LEAVES, BambooLeaves.NONE)).setValue(STAGE, 0));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(AGE, LEAVES, STAGE);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState iblockdata) {
        return true;
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        VoxelShape voxelshape = iblockdata.getValue(LEAVES) == BambooLeaves.LARGE ? SHAPE_LARGE : SHAPE_SMALL;
        return voxelshape.move(iblockdata.getOffset(blockposition));
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE_COLLISION.move(iblockdata.getOffset(blockposition));
    }

    @Override
    protected boolean isCollisionShapeFullBlock(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return false;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        FluidState fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        if (!fluid.isEmpty()) {
            return null;
        }
        BlockState iblockdata = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos().below());
        if (iblockdata.is(BlockTags.BAMBOO_PLANTABLE_ON)) {
            if (iblockdata.is(Blocks.BAMBOO_SAPLING)) {
                return (BlockState)this.defaultBlockState().setValue(AGE, 0);
            }
            if (iblockdata.is(Blocks.BAMBOO)) {
                int i = iblockdata.getValue(AGE) > 0 ? 1 : 0;
                return (BlockState)this.defaultBlockState().setValue(AGE, i);
            }
            BlockState iblockdata1 = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos().above());
            return iblockdata1.is(Blocks.BAMBOO) ? (BlockState)this.defaultBlockState().setValue(AGE, iblockdata1.getValue(AGE)) : Blocks.BAMBOO_SAPLING.defaultBlockState();
        }
        return null;
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (!iblockdata.canSurvive(worldserver, blockposition)) {
            worldserver.destroyBlock(blockposition, true);
        }
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return iblockdata.getValue(STAGE) == 0;
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        int i;
        if (iblockdata.getValue(STAGE) == 0 && randomsource.nextFloat() < (float)worldserver.spigotConfig.bambooModifier / 300.0f && worldserver.isEmptyBlock(blockposition.above()) && worldserver.getRawBrightness(blockposition.above(), 0) >= 9 && (i = this.getHeightBelowUpToMax(worldserver, blockposition) + 1) < 16) {
            this.growBamboo(iblockdata, worldserver, blockposition, randomsource, i);
        }
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        return iworldreader.getBlockState(blockposition.below()).is(BlockTags.BAMBOO_PLANTABLE_ON);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (!iblockdata.canSurvive(iworldreader, blockposition)) {
            scheduledtickaccess.scheduleTick(blockposition, this, 1);
        }
        return enumdirection == Direction.UP && iblockdata1.is(Blocks.BAMBOO) && iblockdata1.getValue(AGE) > iblockdata.getValue(AGE) ? (BlockState)iblockdata.cycle(AGE) : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        int j;
        int i = this.getHeightAboveUpToMax(iworldreader, blockposition);
        return i + (j = this.getHeightBelowUpToMax(iworldreader, blockposition)) + 1 < 16 && iworldreader.getBlockState(blockposition.above(i)).getValue(STAGE) != 1;
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel worldserver, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        int i = this.getHeightAboveUpToMax(worldserver, blockposition);
        int j = this.getHeightBelowUpToMax(worldserver, blockposition);
        int k = i + j + 1;
        int l = 1 + randomsource.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockposition1 = blockposition.above(i);
            BlockState iblockdata1 = worldserver.getBlockState(blockposition1);
            if (k >= 16 || !iblockdata1.is(Blocks.BAMBOO) || iblockdata1.getValue(STAGE) == 1 || !worldserver.isEmptyBlock(blockposition1.above())) {
                return;
            }
            this.growBamboo(iblockdata1, worldserver, blockposition1, randomsource, k);
            ++i;
            ++k;
        }
    }

    protected void growBamboo(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource, int i) {
        int k;
        BlockState iblockdata1 = world.getBlockState(blockposition.below());
        BlockPos blockposition1 = blockposition.below(2);
        BlockState iblockdata2 = world.getBlockState(blockposition1);
        BambooLeaves blockpropertybamboosize = BambooLeaves.NONE;
        boolean shouldUpdateOthers = false;
        if (i >= 1) {
            if (iblockdata1.is(Blocks.BAMBOO) && iblockdata1.getValue(LEAVES) != BambooLeaves.NONE) {
                if (iblockdata1.is(Blocks.BAMBOO) && iblockdata1.getValue(LEAVES) != BambooLeaves.NONE) {
                    blockpropertybamboosize = BambooLeaves.LARGE;
                    if (iblockdata2.is(Blocks.BAMBOO)) {
                        shouldUpdateOthers = true;
                    }
                }
            } else {
                blockpropertybamboosize = BambooLeaves.SMALL;
            }
        }
        int j = iblockdata.getValue(AGE) != 1 && !iblockdata2.is(Blocks.BAMBOO) ? 0 : 1;
        int n = k = (i < 11 || randomsource.nextFloat() >= 0.25f) && i != 15 ? 0 : 1;
        if (CraftEventFactory.handleBlockSpreadEvent(world, blockposition, blockposition.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AGE, j)).setValue(LEAVES, blockpropertybamboosize)).setValue(STAGE, k), 3) && shouldUpdateOthers) {
            world.setBlock(blockposition.below(), (BlockState)iblockdata1.setValue(LEAVES, BambooLeaves.SMALL), 3);
            world.setBlock(blockposition1, (BlockState)iblockdata2.setValue(LEAVES, BambooLeaves.NONE), 3);
        }
    }

    protected int getHeightAboveUpToMax(BlockGetter iblockaccess, BlockPos blockposition) {
        int i;
        for (i = 0; i < 16 && iblockaccess.getBlockState(blockposition.above(i + 1)).is(Blocks.BAMBOO); ++i) {
        }
        return i;
    }

    protected int getHeightBelowUpToMax(BlockGetter iblockaccess, BlockPos blockposition) {
        int i;
        for (i = 0; i < 16 && iblockaccess.getBlockState(blockposition.below(i + 1)).is(Blocks.BAMBOO); ++i) {
        }
        return i;
    }
}

