/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.OctahedralGroup;
import com.mojang.math.Quadrant;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;

public class BedBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<BedBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(BedBlock::getColor), BedBlock.propertiesCodec()).apply((Applicative)instance, BedBlock::new));
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    private static final Map<Direction, VoxelShape> SHAPES = Util.make(() -> {
        VoxelShape voxelshape = Block.box(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
        VoxelShape voxelshape1 = Shapes.rotate(voxelshape, OctahedralGroup.fromXYAngles(Quadrant.R0, Quadrant.R90));
        return Shapes.rotateHorizontal(Shapes.or(Block.column(16.0, 3.0, 9.0), voxelshape, voxelshape1));
    });
    private final DyeColor color;

    public MapCodec<BedBlock> codec() {
        return CODEC;
    }

    public BedBlock(DyeColor enumcolor, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.color = enumcolor;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, BedPart.FOOT)).setValue(OCCUPIED, false));
    }

    @Nullable
    public static Direction getBedOrientation(BlockGetter iblockaccess, BlockPos blockposition) {
        BlockState iblockdata = iblockaccess.getBlockState(blockposition);
        return iblockdata.getBlock() instanceof BedBlock ? (Direction)iblockdata.getValue(FACING) : null;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS_SERVER;
        }
        if (iblockdata.getValue(PART) != BedPart.HEAD && !(iblockdata = world.getBlockState(blockposition = blockposition.relative((Direction)iblockdata.getValue(FACING)))).is(this)) {
            return InteractionResult.CONSUME;
        }
        if (iblockdata.getValue(OCCUPIED).booleanValue()) {
            if (!this.kickVillagerOutOfBed(world, blockposition)) {
                entityhuman.displayClientMessage(Component.translatable("block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        BlockState finaliblockdata = iblockdata;
        BlockPos finalblockposition = blockposition;
        entityhuman.startSleepInBed(blockposition).ifLeft(entityhuman_enumbedresult -> {
            if (!world.dimensionType().bedWorks()) {
                this.explodeBed(finaliblockdata, world, finalblockposition);
            } else if (entityhuman_enumbedresult.getMessage() != null) {
                entityhuman.displayClientMessage(entityhuman_enumbedresult.getMessage(), true);
            }
        });
        return InteractionResult.SUCCESS_SERVER;
    }

    private InteractionResult explodeBed(BlockState iblockdata, Level world, BlockPos blockposition) {
        org.bukkit.block.BlockState blockState = CraftBlock.at(world, blockposition).getState();
        world.removeBlock(blockposition, false);
        BlockPos blockposition1 = blockposition.relative(((Direction)iblockdata.getValue(FACING)).getOpposite());
        if (world.getBlockState(blockposition1).getBlock() == this) {
            world.removeBlock(blockposition1, false);
        }
        Vec3 vec3d = blockposition.getCenter();
        world.explode((Entity)null, world.damageSources().badRespawnPointExplosion(vec3d, blockState), null, vec3d, 5.0f, true, Level.ExplosionInteraction.BLOCK);
        return InteractionResult.SUCCESS;
    }

    public static boolean canSetSpawn(Level world) {
        return true;
    }

    private boolean kickVillagerOutOfBed(Level world, BlockPos blockposition) {
        List<Villager> list = world.getEntitiesOfClass(Villager.class, new AABB(blockposition), LivingEntity::isSleeping);
        if (list.isEmpty()) {
            return false;
        }
        list.get(0).stopSleeping();
        return true;
    }

    @Override
    public void fallOn(Level world, BlockState iblockdata, BlockPos blockposition, Entity entity, double d0) {
        super.fallOn(world, iblockdata, blockposition, entity, d0 * 0.5);
    }

    @Override
    public void updateEntityMovementAfterFallOn(BlockGetter iblockaccess, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(iblockaccess, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3d = entity.getDeltaMovement();
        if (vec3d.y < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vec3d.x, -vec3d.y * (double)0.66f * d0, vec3d.z);
        }
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        return enumdirection == BedBlock.getNeighbourDirection(iblockdata.getValue(PART), (Direction)iblockdata.getValue(FACING)) ? (iblockdata1.is(this) && iblockdata1.getValue(PART) != iblockdata.getValue(PART) ? (BlockState)iblockdata.setValue(OCCUPIED, iblockdata1.getValue(OCCUPIED)) : Blocks.AIR.defaultBlockState()) : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    private static Direction getNeighbourDirection(BedPart blockpropertybedpart, Direction enumdirection) {
        return blockpropertybedpart == BedPart.FOOT ? enumdirection : enumdirection.getOpposite();
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        BlockPos blockposition1;
        BlockState iblockdata1;
        BedPart blockpropertybedpart;
        if (!world.isClientSide() && entityhuman.preventsBlockDrops() && (blockpropertybedpart = iblockdata.getValue(PART)) == BedPart.FOOT && (iblockdata1 = world.getBlockState(blockposition1 = blockposition.relative(BedBlock.getNeighbourDirection(blockpropertybedpart, (Direction)iblockdata.getValue(FACING))))).is(this) && iblockdata1.getValue(PART) == BedPart.HEAD) {
            world.setBlock(blockposition1, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(entityhuman, 2001, blockposition1, Block.getId(iblockdata1));
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        Direction enumdirection = blockactioncontext.getHorizontalDirection();
        BlockPos blockposition = blockactioncontext.getClickedPos();
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        Level world = blockactioncontext.getLevel();
        return world.getBlockState(blockposition1).canBeReplaced(blockactioncontext) && world.getWorldBorder().isWithinBounds(blockposition1) ? (BlockState)this.defaultBlockState().setValue(FACING, enumdirection) : null;
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPES.get(BedBlock.getConnectedDirection(iblockdata).getOpposite());
    }

    public static Direction getConnectedDirection(BlockState iblockdata) {
        Direction enumdirection = (Direction)iblockdata.getValue(FACING);
        return iblockdata.getValue(PART) == BedPart.HEAD ? enumdirection.getOpposite() : enumdirection;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState iblockdata) {
        BedPart blockpropertybedpart = iblockdata.getValue(PART);
        return blockpropertybedpart == BedPart.HEAD ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    private static boolean isBunkBed(BlockGetter iblockaccess, BlockPos blockposition) {
        return iblockaccess.getBlockState(blockposition.below()).getBlock() instanceof BedBlock;
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> entitytypes, CollisionGetter icollisionaccess, BlockPos blockposition, Direction enumdirection, float f) {
        Direction enumdirection2;
        Direction enumdirection1 = enumdirection.getClockWise();
        Direction direction = enumdirection2 = enumdirection1.isFacingAngle(f) ? enumdirection1.getOpposite() : enumdirection1;
        if (BedBlock.isBunkBed(icollisionaccess, blockposition)) {
            return BedBlock.findBunkBedStandUpPosition(entitytypes, icollisionaccess, blockposition, enumdirection, enumdirection2);
        }
        int[][] aint = BedBlock.bedStandUpOffsets(enumdirection, enumdirection2);
        Optional<Vec3> optional = BedBlock.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint, true);
        return optional.isPresent() ? optional : BedBlock.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint, false);
    }

    private static Optional<Vec3> findBunkBedStandUpPosition(EntityType<?> entitytypes, CollisionGetter icollisionaccess, BlockPos blockposition, Direction enumdirection, Direction enumdirection1) {
        int[][] aint = BedBlock.bedSurroundStandUpOffsets(enumdirection, enumdirection1);
        Optional<Vec3> optional = BedBlock.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPos blockposition1 = blockposition.below();
        Optional<Vec3> optional1 = BedBlock.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition1, aint, true);
        if (optional1.isPresent()) {
            return optional1;
        }
        int[][] aint1 = BedBlock.bedAboveStandUpOffsets(enumdirection);
        Optional<Vec3> optional2 = BedBlock.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint1, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Vec3> optional3 = BedBlock.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint, false);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vec3> optional4 = BedBlock.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition1, aint, false);
        return optional4.isPresent() ? optional4 : BedBlock.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint1, false);
    }

    private static Optional<Vec3> findStandUpPositionAtOffset(EntityType<?> entitytypes, CollisionGetter icollisionaccess, BlockPos blockposition, int[][] aint, boolean flag) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (int[] aint1 : aint) {
            blockposition_mutableblockposition.set(blockposition.getX() + aint1[0], blockposition.getY(), blockposition.getZ() + aint1[1]);
            Vec3 vec3d = DismountHelper.findSafeDismountLocation(entitytypes, icollisionaccess, blockposition_mutableblockposition, flag);
            if (vec3d == null) continue;
            return Optional.of(vec3d);
        }
        return Optional.empty();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, PART, OCCUPIED);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new BedBlockEntity(blockposition, iblockdata, this.color);
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable LivingEntity entityliving, ItemStack itemstack) {
        super.setPlacedBy(world, blockposition, iblockdata, entityliving, itemstack);
        if (!world.isClientSide()) {
            BlockPos blockposition1 = blockposition.relative((Direction)iblockdata.getValue(FACING));
            world.setBlock(blockposition1, (BlockState)iblockdata.setValue(PART, BedPart.HEAD), 3);
            if (world.captureBlockStates) {
                return;
            }
            world.updateNeighborsAt(blockposition, Blocks.AIR);
            iblockdata.updateNeighbourShapes(world, blockposition, 3);
        }
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    protected long getSeed(BlockState iblockdata, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.relative((Direction)iblockdata.getValue(FACING), iblockdata.getValue(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.getSeed(blockposition1.getX(), blockposition.getY(), blockposition1.getZ());
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    private static int[][] bedStandUpOffsets(Direction enumdirection, Direction enumdirection1) {
        return (int[][])ArrayUtils.addAll((Object[])BedBlock.bedSurroundStandUpOffsets(enumdirection, enumdirection1), (Object[])BedBlock.bedAboveStandUpOffsets(enumdirection));
    }

    private static int[][] bedSurroundStandUpOffsets(Direction enumdirection, Direction enumdirection1) {
        return new int[][]{{enumdirection1.getStepX(), enumdirection1.getStepZ()}, {enumdirection1.getStepX() - enumdirection.getStepX(), enumdirection1.getStepZ() - enumdirection.getStepZ()}, {enumdirection1.getStepX() - enumdirection.getStepX() * 2, enumdirection1.getStepZ() - enumdirection.getStepZ() * 2}, {-enumdirection.getStepX() * 2, -enumdirection.getStepZ() * 2}, {-enumdirection1.getStepX() - enumdirection.getStepX() * 2, -enumdirection1.getStepZ() - enumdirection.getStepZ() * 2}, {-enumdirection1.getStepX() - enumdirection.getStepX(), -enumdirection1.getStepZ() - enumdirection.getStepZ()}, {-enumdirection1.getStepX(), -enumdirection1.getStepZ()}, {-enumdirection1.getStepX() + enumdirection.getStepX(), -enumdirection1.getStepZ() + enumdirection.getStepZ()}, {enumdirection.getStepX(), enumdirection.getStepZ()}, {enumdirection1.getStepX() + enumdirection.getStepX(), enumdirection1.getStepZ() + enumdirection.getStepZ()}};
    }

    private static int[][] bedAboveStandUpOffsets(Direction enumdirection) {
        return new int[][]{{0, 0}, {-enumdirection.getStepX(), -enumdirection.getStepZ()}};
    }
}

