/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class EndPortalBlock
extends BaseEntityBlock
implements Portal {
    public static final MapCodec<EndPortalBlock> CODEC = EndPortalBlock.simpleCodec(EndPortalBlock::new);
    private static final VoxelShape SHAPE = Block.column(16.0, 6.0, 12.0);

    public MapCodec<EndPortalBlock> codec() {
        return CODEC;
    }

    protected EndPortalBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new TheEndPortalBlockEntity(blockposition, iblockdata);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, net.minecraft.world.entity.Entity entity) {
        return iblockdata.getShape(iblockaccess, blockposition);
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (entity.canUsePortal(false)) {
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), new Location((World)world.getWorld(), (double)blockposition.getX(), (double)blockposition.getY(), (double)blockposition.getZ()));
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!world.isClientSide() && world.dimension() == Level.END && entity instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                if (!entityplayer.seenCredits) {
                    entityplayer.showEndCredits();
                    return;
                }
            }
            entity.setAsInsidePortal(this, blockposition);
        }
    }

    @Override
    @Nullable
    public TeleportTransition getPortalDestination(ServerLevel worldserver, net.minecraft.world.entity.Entity entity, BlockPos blockposition) {
        CraftPortalEvent event;
        Set<Relative> set;
        float f1;
        float f;
        LevelData.RespawnData worlddata_a = worldserver.getRespawnData();
        ResourceKey<LevelStem> resourcekey = worldserver.getTypeKey();
        boolean flag = resourcekey == LevelStem.END;
        ResourceKey<Level> resourcekey1 = flag ? worlddata_a.dimension() : Level.END;
        BlockPos blockposition1 = flag ? worlddata_a.pos() : ServerLevel.END_SPAWN_POINT;
        ServerLevel worldserver1 = worldserver.getServer().getLevel(resourcekey1);
        if (worldserver1 == null) {
            return new TeleportTransition(PlayerTeleportEvent.TeleportCause.END_PORTAL);
        }
        Vec3 vec3d = blockposition1.getBottomCenter();
        if (!flag) {
            EndPlatformFeature.createEndPlatform(worldserver1, BlockPos.containing(vec3d).below(), true, entity);
            f = Direction.WEST.toYRot();
            f1 = 0.0f;
            set = Relative.union(Relative.DELTA, Set.of(Relative.X_ROT));
            if (entity instanceof ServerPlayer) {
                vec3d = vec3d.subtract(0.0, 1.0, 0.0);
            }
        } else {
            f = worlddata_a.yaw();
            f1 = worlddata_a.pitch();
            set = Relative.union(Relative.DELTA, Relative.ROTATION);
            if (entity instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                return entityplayer.findRespawnPositionAndUseSpawnBlock(false, TeleportTransition.DO_NOTHING, PlayerRespawnEvent.RespawnReason.END_PORTAL);
            }
            vec3d = entity.adjustSpawnLocation(worldserver1, blockposition1).getBottomCenter();
        }
        if ((event = entity.callPortalEvent(entity, CraftLocation.toBukkit(vec3d, (World)worldserver1.getWorld(), f, f1), PlayerTeleportEvent.TeleportCause.END_PORTAL, 0, 0)) == null) {
            return null;
        }
        Location to = event.getTo();
        return new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), entity.getDeltaMovement(), to.getYaw(), to.getPitch(), set, TeleportTransition.PLAY_PORTAL_SOUND.then(TeleportTransition.PLACE_PORTAL_TICKET), PlayerTeleportEvent.TeleportCause.END_PORTAL);
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        double d0 = (double)blockposition.getX() + randomsource.nextDouble();
        double d1 = (double)blockposition.getY() + 0.8;
        double d2 = (double)blockposition.getZ() + randomsource.nextDouble();
        world.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        return ItemStack.EMPTY;
    }

    @Override
    protected boolean canBeReplaced(BlockState iblockdata, Fluid fluidtype) {
        return false;
    }

    @Override
    protected RenderShape getRenderShape(BlockState iblockdata) {
        return RenderShape.INVISIBLE;
    }
}

