/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LavaCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LavaCauldronBlock> CODEC = LavaCauldronBlock.simpleCodec(LavaCauldronBlock::new);
    private static final VoxelShape SHAPE_INSIDE = Block.column(12.0, 4.0, 15.0);
    private static final VoxelShape FILLED_SHAPE = Shapes.or(AbstractCauldronBlock.SHAPE, SHAPE_INSIDE);

    public MapCodec<LavaCauldronBlock> codec() {
        return CODEC;
    }

    public LavaCauldronBlock(BlockBehaviour.Properties var0) {
        super(var0, CauldronInteraction.LAVA);
    }

    @Override
    protected double getContentHeight(BlockState var0) {
        return 0.9375;
    }

    @Override
    public boolean isFull(BlockState var0) {
        return true;
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(BlockState var0, BlockGetter var1, BlockPos var2, Entity var3) {
        return FILLED_SHAPE;
    }

    @Override
    protected void entityInside(BlockState var0, Level var1, BlockPos var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        var4.apply(InsideBlockEffectType.CLEAR_FREEZE);
        var4.apply(InsideBlockEffectType.LAVA_IGNITE);
        var4.runAfter(InsideBlockEffectType.LAVA_IGNITE, Entity::lavaHurt);
    }

    @Override
    protected int getAnalogOutputSignal(BlockState var0, Level var1, BlockPos var2, Direction var3) {
        return 3;
    }
}

