/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PitcherCropBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final MapCodec<PitcherCropBlock> CODEC = PitcherCropBlock.simpleCodec(PitcherCropBlock::new);
    public static final int MAX_AGE = 4;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static final EnumProperty<DoubleBlockHalf> HALF = DoublePlantBlock.HALF;
    private static final int DOUBLE_PLANT_AGE_INTERSECTION = 3;
    private static final int BONEMEAL_INCREASE = 1;
    private static final VoxelShape SHAPE_BULB = Block.column(6.0, -1.0, 3.0);
    private static final VoxelShape SHAPE_CROP = Block.column(10.0, -1.0, 5.0);
    private final Function<BlockState, VoxelShape> shapes = this.makeShapes();

    public MapCodec<PitcherCropBlock> codec() {
        return CODEC;
    }

    public PitcherCropBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        int[] var0 = new int[]{0, 9, 11, 22, 26};
        return this.getShapeForEachState(var1 -> {
            int var2 = (var1.getValue(AGE) == 0 ? 4 : 6) + var0[var1.getValue(AGE)];
            int var3 = var1.getValue(AGE) == 0 ? 6 : 10;
            return switch (var1.getValue(HALF)) {
                default -> throw new MatchException(null, null);
                case DoubleBlockHalf.LOWER -> Block.column(var3, -1.0, Math.min(16, -1 + var2));
                case DoubleBlockHalf.UPPER -> Block.column(var3, 0.0, Math.max(0, -1 + var2 - 16));
            };
        });
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        return this.defaultBlockState();
    }

    @Override
    public VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.shapes.apply(var0);
    }

    @Override
    public VoxelShape getCollisionShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        if (var0.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return var0.getValue(AGE) == 0 ? SHAPE_BULB : SHAPE_CROP;
        }
        return Shapes.empty();
    }

    @Override
    public BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (PitcherCropBlock.isDouble(var0.getValue(AGE))) {
            return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        }
        return var0.canSurvive(var1, var3) ? var0 : Blocks.AIR.defaultBlockState();
    }

    @Override
    public boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        if (PitcherCropBlock.isLower(var0) && !PitcherCropBlock.sufficientLight(var1, var2)) {
            return false;
        }
        return super.canSurvive(var0, var1, var2);
    }

    @Override
    protected boolean mayPlaceOn(BlockState var0, BlockGetter var1, BlockPos var2) {
        return var0.is(Blocks.FARMLAND);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(AGE);
        super.createBlockStateDefinition(var0);
    }

    @Override
    public void entityInside(BlockState var0, Level var1, BlockPos var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        if (var1 instanceof ServerLevel) {
            ServerLevel var6 = (ServerLevel)var1;
            if (var3 instanceof Ravager && var6.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                var6.destroyBlock(var2, true, var3);
            }
        }
    }

    @Override
    public boolean canBeReplaced(BlockState var0, BlockPlaceContext var1) {
        return false;
    }

    @Override
    public void setPlacedBy(Level var0, BlockPos var1, BlockState var2, LivingEntity var3, ItemStack var4) {
    }

    @Override
    public boolean isRandomlyTicking(BlockState var0) {
        return var0.getValue(HALF) == DoubleBlockHalf.LOWER && !this.isMaxAge(var0);
    }

    @Override
    public void randomTick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        boolean var5;
        float var4 = CropBlock.getGrowthSpeed(this, var1, var2);
        boolean bl = var5 = var3.nextInt((int)(25.0f / var4) + 1) == 0;
        if (var5) {
            this.grow(var1, var0, var2, 1);
        }
    }

    private void grow(ServerLevel var0, BlockState var1, BlockPos var2, int var3) {
        int var4 = Math.min(var1.getValue(AGE) + var3, 4);
        if (!this.canGrow(var0, var2, var1, var4)) {
            return;
        }
        BlockState var5 = (BlockState)var1.setValue(AGE, var4);
        var0.setBlock(var2, var5, 2);
        if (PitcherCropBlock.isDouble(var4)) {
            var0.setBlock(var2.above(), (BlockState)var5.setValue(HALF, DoubleBlockHalf.UPPER), 3);
        }
    }

    private static boolean canGrowInto(LevelReader var0, BlockPos var1) {
        BlockState var2 = var0.getBlockState(var1);
        return var2.isAir() || var2.is(Blocks.PITCHER_CROP);
    }

    private static boolean sufficientLight(LevelReader var0, BlockPos var1) {
        return CropBlock.hasSufficientLight(var0, var1);
    }

    private static boolean isLower(BlockState var0) {
        return var0.is(Blocks.PITCHER_CROP) && var0.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    private static boolean isDouble(int var0) {
        return var0 >= 3;
    }

    private boolean canGrow(LevelReader var0, BlockPos var1, BlockState var2, int var3) {
        return !this.isMaxAge(var2) && PitcherCropBlock.sufficientLight(var0, var1) && (!PitcherCropBlock.isDouble(var3) || PitcherCropBlock.canGrowInto(var0, var1.above()));
    }

    private boolean isMaxAge(BlockState var0) {
        return var0.getValue(AGE) >= 4;
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader var0, BlockPos var1, BlockState var2) {
        if (PitcherCropBlock.isLower(var2)) {
            return new PosAndState(var1, var2);
        }
        BlockPos var3 = var1.below();
        BlockState var4 = var0.getBlockState(var3);
        if (PitcherCropBlock.isLower(var4)) {
            return new PosAndState(var3, var4);
        }
        return null;
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        PosAndState var3 = this.getLowerHalf(var0, var1, var2);
        if (var3 == null) {
            return false;
        }
        return this.canGrow(var0, var3.pos, var3.state, var3.state.getValue(AGE) + 1);
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        PosAndState var4 = this.getLowerHalf(var0, var2, var3);
        if (var4 == null) {
            return;
        }
        this.grow(var0, var4.state, var4.pos, 1);
    }

    static final class PosAndState
    extends Record {
        final BlockPos pos;
        final BlockState state;

        PosAndState(BlockPos var0, BlockState var1) {
            this.pos = var0;
            this.state = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PosAndState.class, "pos;state", "pos", "state"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PosAndState.class, "pos;state", "pos", "state"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PosAndState.class, "pos;state", "pos", "state"}, this, var0);
        }

        public BlockPos pos() {
            return this.pos;
        }

        public BlockState state() {
            return this.state;
        }
    }
}

