/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;

public class RailState {
    private final Level level;
    private final BlockPos pos;
    private final BaseRailBlock block;
    private BlockState state;
    private final boolean isStraight;
    private final List<BlockPos> connections = Lists.newArrayList();

    public RailState(Level var0, BlockPos var1, BlockState var2) {
        this.level = var0;
        this.pos = var1;
        this.state = var2;
        this.block = (BaseRailBlock)var2.getBlock();
        RailShape var3 = var2.getValue(this.block.getShapeProperty());
        this.isStraight = this.block.isStraight();
        this.updateConnections(var3);
    }

    public List<BlockPos> getConnections() {
        return this.connections;
    }

    private void updateConnections(RailShape var0) {
        this.connections.clear();
        switch (var0) {
            case NORTH_SOUTH: {
                this.connections.add(this.pos.north());
                this.connections.add(this.pos.south());
                break;
            }
            case EAST_WEST: {
                this.connections.add(this.pos.west());
                this.connections.add(this.pos.east());
                break;
            }
            case ASCENDING_EAST: {
                this.connections.add(this.pos.west());
                this.connections.add(this.pos.east().above());
                break;
            }
            case ASCENDING_WEST: {
                this.connections.add(this.pos.west().above());
                this.connections.add(this.pos.east());
                break;
            }
            case ASCENDING_NORTH: {
                this.connections.add(this.pos.north().above());
                this.connections.add(this.pos.south());
                break;
            }
            case ASCENDING_SOUTH: {
                this.connections.add(this.pos.north());
                this.connections.add(this.pos.south().above());
                break;
            }
            case SOUTH_EAST: {
                this.connections.add(this.pos.east());
                this.connections.add(this.pos.south());
                break;
            }
            case SOUTH_WEST: {
                this.connections.add(this.pos.west());
                this.connections.add(this.pos.south());
                break;
            }
            case NORTH_WEST: {
                this.connections.add(this.pos.west());
                this.connections.add(this.pos.north());
                break;
            }
            case NORTH_EAST: {
                this.connections.add(this.pos.east());
                this.connections.add(this.pos.north());
            }
        }
    }

    private void removeSoftConnections() {
        for (int var0 = 0; var0 < this.connections.size(); ++var0) {
            RailState var1 = this.getRail(this.connections.get(var0));
            if (var1 == null || !var1.connectsTo(this)) {
                this.connections.remove(var0--);
                continue;
            }
            this.connections.set(var0, var1.pos);
        }
    }

    private boolean hasRail(BlockPos var0) {
        return BaseRailBlock.isRail(this.level, var0) || BaseRailBlock.isRail(this.level, var0.above()) || BaseRailBlock.isRail(this.level, var0.below());
    }

    @Nullable
    private RailState getRail(BlockPos var0) {
        BlockPos var1 = var0;
        BlockState var2 = this.level.getBlockState(var1);
        if (BaseRailBlock.isRail(var2)) {
            return new RailState(this.level, var1, var2);
        }
        var1 = var0.above();
        var2 = this.level.getBlockState(var1);
        if (BaseRailBlock.isRail(var2)) {
            return new RailState(this.level, var1, var2);
        }
        var1 = var0.below();
        var2 = this.level.getBlockState(var1);
        if (BaseRailBlock.isRail(var2)) {
            return new RailState(this.level, var1, var2);
        }
        return null;
    }

    private boolean connectsTo(RailState var0) {
        return this.hasConnection(var0.pos);
    }

    private boolean hasConnection(BlockPos var0) {
        for (int var1 = 0; var1 < this.connections.size(); ++var1) {
            BlockPos var2 = this.connections.get(var1);
            if (var2.getX() != var0.getX() || var2.getZ() != var0.getZ()) continue;
            return true;
        }
        return false;
    }

    protected int countPotentialConnections() {
        int var0 = 0;
        for (Direction var2 : Direction.Plane.HORIZONTAL) {
            if (!this.hasRail(this.pos.relative(var2))) continue;
            ++var0;
        }
        return var0;
    }

    private boolean canConnectTo(RailState var0) {
        return this.connectsTo(var0) || this.connections.size() != 2;
    }

    private void connectTo(RailState var0) {
        this.connections.add(var0.pos);
        BlockPos var1 = this.pos.north();
        BlockPos var2 = this.pos.south();
        BlockPos var3 = this.pos.west();
        BlockPos var4 = this.pos.east();
        boolean var5 = this.hasConnection(var1);
        boolean var6 = this.hasConnection(var2);
        boolean var7 = this.hasConnection(var3);
        boolean var8 = this.hasConnection(var4);
        RailShape var9 = null;
        if (var5 || var6) {
            var9 = RailShape.NORTH_SOUTH;
        }
        if (var7 || var8) {
            var9 = RailShape.EAST_WEST;
        }
        if (!this.isStraight) {
            if (var6 && var8 && !var5 && !var7) {
                var9 = RailShape.SOUTH_EAST;
            }
            if (var6 && var7 && !var5 && !var8) {
                var9 = RailShape.SOUTH_WEST;
            }
            if (var5 && var7 && !var6 && !var8) {
                var9 = RailShape.NORTH_WEST;
            }
            if (var5 && var8 && !var6 && !var7) {
                var9 = RailShape.NORTH_EAST;
            }
        }
        if (var9 == RailShape.NORTH_SOUTH) {
            if (BaseRailBlock.isRail(this.level, var1.above())) {
                var9 = RailShape.ASCENDING_NORTH;
            }
            if (BaseRailBlock.isRail(this.level, var2.above())) {
                var9 = RailShape.ASCENDING_SOUTH;
            }
        }
        if (var9 == RailShape.EAST_WEST) {
            if (BaseRailBlock.isRail(this.level, var4.above())) {
                var9 = RailShape.ASCENDING_EAST;
            }
            if (BaseRailBlock.isRail(this.level, var3.above())) {
                var9 = RailShape.ASCENDING_WEST;
            }
        }
        if (var9 == null) {
            var9 = RailShape.NORTH_SOUTH;
        }
        this.state = (BlockState)this.state.setValue(this.block.getShapeProperty(), var9);
        this.level.setBlock(this.pos, this.state, 3);
    }

    private boolean hasNeighborRail(BlockPos var0) {
        RailState var1 = this.getRail(var0);
        if (var1 == null) {
            return false;
        }
        var1.removeSoftConnections();
        return var1.canConnectTo(this);
    }

    public RailState place(boolean var0, boolean var1, RailShape var2) {
        boolean var17;
        boolean var13;
        BlockPos var3 = this.pos.north();
        BlockPos var4 = this.pos.south();
        BlockPos var5 = this.pos.west();
        BlockPos var6 = this.pos.east();
        boolean var7 = this.hasNeighborRail(var3);
        boolean var8 = this.hasNeighborRail(var4);
        boolean var9 = this.hasNeighborRail(var5);
        boolean var10 = this.hasNeighborRail(var6);
        RailShape var11 = null;
        boolean var12 = var7 || var8;
        boolean bl = var13 = var9 || var10;
        if (var12 && !var13) {
            var11 = RailShape.NORTH_SOUTH;
        }
        if (var13 && !var12) {
            var11 = RailShape.EAST_WEST;
        }
        boolean var14 = var8 && var10;
        boolean var15 = var8 && var9;
        boolean var16 = var7 && var10;
        boolean bl2 = var17 = var7 && var9;
        if (!this.isStraight) {
            if (var14 && !var7 && !var9) {
                var11 = RailShape.SOUTH_EAST;
            }
            if (var15 && !var7 && !var10) {
                var11 = RailShape.SOUTH_WEST;
            }
            if (var17 && !var8 && !var10) {
                var11 = RailShape.NORTH_WEST;
            }
            if (var16 && !var8 && !var9) {
                var11 = RailShape.NORTH_EAST;
            }
        }
        if (var11 == null) {
            if (var12 && var13) {
                var11 = var2;
            } else if (var12) {
                var11 = RailShape.NORTH_SOUTH;
            } else if (var13) {
                var11 = RailShape.EAST_WEST;
            }
            if (!this.isStraight) {
                if (var0) {
                    if (var14) {
                        var11 = RailShape.SOUTH_EAST;
                    }
                    if (var15) {
                        var11 = RailShape.SOUTH_WEST;
                    }
                    if (var16) {
                        var11 = RailShape.NORTH_EAST;
                    }
                    if (var17) {
                        var11 = RailShape.NORTH_WEST;
                    }
                } else {
                    if (var17) {
                        var11 = RailShape.NORTH_WEST;
                    }
                    if (var16) {
                        var11 = RailShape.NORTH_EAST;
                    }
                    if (var15) {
                        var11 = RailShape.SOUTH_WEST;
                    }
                    if (var14) {
                        var11 = RailShape.SOUTH_EAST;
                    }
                }
            }
        }
        if (var11 == RailShape.NORTH_SOUTH) {
            if (BaseRailBlock.isRail(this.level, var3.above())) {
                var11 = RailShape.ASCENDING_NORTH;
            }
            if (BaseRailBlock.isRail(this.level, var4.above())) {
                var11 = RailShape.ASCENDING_SOUTH;
            }
        }
        if (var11 == RailShape.EAST_WEST) {
            if (BaseRailBlock.isRail(this.level, var6.above())) {
                var11 = RailShape.ASCENDING_EAST;
            }
            if (BaseRailBlock.isRail(this.level, var5.above())) {
                var11 = RailShape.ASCENDING_WEST;
            }
        }
        if (var11 == null) {
            var11 = var2;
        }
        this.updateConnections(var11);
        this.state = (BlockState)this.state.setValue(this.block.getShapeProperty(), var11);
        if (var1 || this.level.getBlockState(this.pos) != this.state) {
            this.level.setBlock(this.pos, this.state, 3);
            for (int var18 = 0; var18 < this.connections.size(); ++var18) {
                RailState var19 = this.getRail(this.connections.get(var18));
                if (var19 == null) continue;
                var19.removeSoftConnections();
                if (!var19.canConnectTo(this)) continue;
                var19.connectTo(this);
            }
        }
        return this;
    }

    public BlockState getState() {
        return this.state;
    }
}

