/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeaPickleBlock
extends VegetationBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<SeaPickleBlock> CODEC = SeaPickleBlock.simpleCodec(SeaPickleBlock::new);
    public static final int MAX_PICKLES = 4;
    public static final IntegerProperty PICKLES = BlockStateProperties.PICKLES;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_ONE = Block.column(4.0, 0.0, 6.0);
    private static final VoxelShape SHAPE_TWO = Block.column(10.0, 0.0, 6.0);
    private static final VoxelShape SHAPE_THREE = Block.column(12.0, 0.0, 6.0);
    private static final VoxelShape SHAPE_FOUR = Block.column(12.0, 0.0, 7.0);

    public MapCodec<SeaPickleBlock> codec() {
        return CODEC;
    }

    protected SeaPickleBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PICKLES, 1)).setValue(WATERLOGGED, true));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        BlockState var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var1.is(this)) {
            return (BlockState)var1.setValue(PICKLES, Math.min(4, var1.getValue(PICKLES) + 1));
        }
        FluidState var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var3 = var2.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(var0).setValue(WATERLOGGED, var3);
    }

    public static boolean isDead(BlockState var0) {
        return var0.getValue(WATERLOGGED) == false;
    }

    @Override
    protected boolean mayPlaceOn(BlockState var0, BlockGetter var1, BlockPos var2) {
        return !var0.getCollisionShape(var1, var2).getFaceShape(Direction.UP).isEmpty() || var0.isFaceSturdy(var1, var2, Direction.UP);
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        BlockPos var3 = var2.below();
        return this.mayPlaceOn(var1.getBlockState(var3), var1, var3);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (!var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean canBeReplaced(BlockState var0, BlockPlaceContext var1) {
        if (!var1.isSecondaryUseActive() && var1.getItemInHand().is(this.asItem()) && var0.getValue(PICKLES) < 4) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return switch (var0.getValue(PICKLES)) {
            default -> SHAPE_ONE;
            case 2 -> SHAPE_TWO;
            case 3 -> SHAPE_THREE;
            case 4 -> SHAPE_FOUR;
        };
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(PICKLES, WATERLOGGED);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        return !SeaPickleBlock.isDead(var2) && var0.getBlockState(var1.below()).is(BlockTags.CORAL_BLOCKS);
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        int var4 = 5;
        int var5 = 1;
        int var6 = 2;
        int var7 = 0;
        int var8 = var2.getX() - 2;
        int var9 = 0;
        for (int var10 = 0; var10 < 5; ++var10) {
            for (int var11 = 0; var11 < var5; ++var11) {
                int var12 = 2 + var2.getY() - 1;
                for (int var13 = var12 - 2; var13 < var12; ++var13) {
                    BlockState var15;
                    BlockPos var14 = new BlockPos(var8 + var10, var13, var2.getZ() - var9 + var11);
                    if (var14 == var2 || var1.nextInt(6) != 0 || !var0.getBlockState(var14).is(Blocks.WATER) || !(var15 = var0.getBlockState(var14.below())).is(BlockTags.CORAL_BLOCKS)) continue;
                    var0.setBlock(var14, (BlockState)Blocks.SEA_PICKLE.defaultBlockState().setValue(PICKLES, var1.nextInt(4) + 1), 3);
                }
            }
            if (var7 < 2) {
                var5 += 2;
                ++var9;
            } else {
                var5 -= 2;
                --var9;
            }
            ++var7;
        }
        var0.setBlock(var2, (BlockState)var3.setValue(PICKLES, 4), 2);
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }
}

