/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface SegmentableBlock {
    public static final int MIN_SEGMENT = 1;
    public static final int MAX_SEGMENT = 4;
    public static final IntegerProperty AMOUNT = BlockStateProperties.SEGMENT_AMOUNT;

    default public Function<BlockState, VoxelShape> getShapeCalculator(EnumProperty<Direction> var0, IntegerProperty var1) {
        Map<Direction, VoxelShape> var2 = Shapes.rotateHorizontal(Block.box(0.0, 0.0, 0.0, 8.0, this.getShapeHeight(), 8.0));
        return var3 -> {
            VoxelShape var4 = Shapes.empty();
            Direction var5 = (Direction)var3.getValue(var0);
            int var6 = var3.getValue(var1);
            for (int var7 = 0; var7 < var6; ++var7) {
                var4 = Shapes.or(var4, (VoxelShape)var2.get(var5));
                var5 = var5.getCounterClockWise();
            }
            return var4.singleEncompassing();
        };
    }

    default public IntegerProperty getSegmentAmountProperty() {
        return AMOUNT;
    }

    default public double getShapeHeight() {
        return 1.0;
    }

    default public boolean canBeReplaced(BlockState var0, BlockPlaceContext var1, IntegerProperty var2) {
        return !var1.isSecondaryUseActive() && var1.getItemInHand().is(var0.getBlock().asItem()) && var0.getValue(var2) < 4;
    }

    default public BlockState getStateForPlacement(BlockPlaceContext var0, Block var1, IntegerProperty var2, EnumProperty<Direction> var3) {
        BlockState var4 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var4.is(var1)) {
            return (BlockState)var4.setValue(var2, Math.min(4, var4.getValue(var2) + 1));
        }
        return (BlockState)var1.defaultBlockState().setValue(var3, var0.getHorizontalDirection().getOpposite());
    }
}

