/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<WallBlock> CODEC = WallBlock.simpleCodec(WallBlock::new);
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final EnumProperty<WallSide> EAST = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> NORTH = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> SOUTH = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST = BlockStateProperties.WEST_WALL;
    public static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST)));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Function<BlockState, VoxelShape> shapes;
    private final Function<BlockState, VoxelShape> collisionShapes;
    private static final VoxelShape TEST_SHAPE_POST = Block.column(2.0, 0.0, 16.0);
    private static final Map<Direction, VoxelShape> TEST_SHAPES_WALL = Shapes.rotateHorizontal(Block.boxZ(2.0, 16.0, 0.0, 9.0));

    public MapCodec<WallBlock> codec() {
        return CODEC;
    }

    public WallBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(UP, true)).setValue(NORTH, WallSide.NONE)).setValue(EAST, WallSide.NONE)).setValue(SOUTH, WallSide.NONE)).setValue(WEST, WallSide.NONE)).setValue(WATERLOGGED, false));
        this.shapes = this.makeShapes(16.0f, 14.0f);
        this.collisionShapes = this.makeShapes(24.0f, 24.0f);
    }

    private Function<BlockState, VoxelShape> makeShapes(float var0, float var1) {
        VoxelShape var2 = Block.column(8.0, 0.0, var0);
        int var32 = 6;
        Map<Direction, VoxelShape> var4 = Shapes.rotateHorizontal(Block.boxZ(6.0, 0.0, var1, 0.0, 11.0));
        Map<Direction, VoxelShape> var5 = Shapes.rotateHorizontal(Block.boxZ(6.0, 0.0, var0, 0.0, 11.0));
        return this.getShapeForEachState(var3 -> {
            VoxelShape var4 = var3.getValue(UP) != false ? var2 : Shapes.empty();
            for (Map.Entry<Direction, EnumProperty<WallSide>> var6 : PROPERTY_BY_DIRECTION.entrySet()) {
                var4 = Shapes.or(var4, switch ((WallSide)var3.getValue(var6.getValue())) {
                    default -> throw new MatchException(null, null);
                    case WallSide.NONE -> Shapes.empty();
                    case WallSide.LOW -> (VoxelShape)var4.get(var6.getKey());
                    case WallSide.TALL -> (VoxelShape)var5.get(var6.getKey());
                });
            }
            return var4;
        }, WATERLOGGED);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.collisionShapes.apply(var0);
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }

    private boolean connectsTo(BlockState var0, boolean var1, Direction var2) {
        Block var3 = var0.getBlock();
        boolean var4 = var3 instanceof FenceGateBlock && FenceGateBlock.connectsToDirection(var0, var2);
        return var0.is(BlockTags.WALLS) || !WallBlock.isExceptionForConnection(var0) && var1 || var3 instanceof IronBarsBlock || var4;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        Level var1 = var0.getLevel();
        BlockPos var2 = var0.getClickedPos();
        FluidState var3 = var0.getLevel().getFluidState(var0.getClickedPos());
        BlockPos var4 = var2.north();
        BlockPos var5 = var2.east();
        BlockPos var6 = var2.south();
        BlockPos var7 = var2.west();
        BlockPos var8 = var2.above();
        BlockState var9 = var1.getBlockState(var4);
        BlockState var10 = var1.getBlockState(var5);
        BlockState var11 = var1.getBlockState(var6);
        BlockState var12 = var1.getBlockState(var7);
        BlockState var13 = var1.getBlockState(var8);
        boolean var14 = this.connectsTo(var9, var9.isFaceSturdy(var1, var4, Direction.SOUTH), Direction.SOUTH);
        boolean var15 = this.connectsTo(var10, var10.isFaceSturdy(var1, var5, Direction.WEST), Direction.WEST);
        boolean var16 = this.connectsTo(var11, var11.isFaceSturdy(var1, var6, Direction.NORTH), Direction.NORTH);
        boolean var17 = this.connectsTo(var12, var12.isFaceSturdy(var1, var7, Direction.EAST), Direction.EAST);
        BlockState var18 = (BlockState)this.defaultBlockState().setValue(WATERLOGGED, var3.getType() == Fluids.WATER);
        return this.updateShape(var1, var18, var8, var13, var14, var15, var16, var17);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        if (var4 == Direction.DOWN) {
            return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        }
        if (var4 == Direction.UP) {
            return this.topUpdate(var1, var0, var5, var6);
        }
        return this.sideUpdate(var1, var3, var0, var5, var6, var4);
    }

    private static boolean isConnected(BlockState var0, Property<WallSide> var1) {
        return var0.getValue(var1) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape var0, VoxelShape var1) {
        return !Shapes.joinIsNotEmpty(var1, var0, BooleanOp.ONLY_FIRST);
    }

    private BlockState topUpdate(LevelReader var0, BlockState var1, BlockPos var2, BlockState var3) {
        boolean var4 = WallBlock.isConnected(var1, NORTH);
        boolean var5 = WallBlock.isConnected(var1, EAST);
        boolean var6 = WallBlock.isConnected(var1, SOUTH);
        boolean var7 = WallBlock.isConnected(var1, WEST);
        return this.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    private BlockState sideUpdate(LevelReader var0, BlockPos var1, BlockState var2, BlockPos var3, BlockState var4, Direction var5) {
        Direction var6 = var5.getOpposite();
        boolean var7 = var5 == Direction.NORTH ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : WallBlock.isConnected(var2, NORTH);
        boolean var8 = var5 == Direction.EAST ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : WallBlock.isConnected(var2, EAST);
        boolean var9 = var5 == Direction.SOUTH ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : WallBlock.isConnected(var2, SOUTH);
        boolean var10 = var5 == Direction.WEST ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : WallBlock.isConnected(var2, WEST);
        BlockPos var11 = var1.above();
        BlockState var12 = var0.getBlockState(var11);
        return this.updateShape(var0, var2, var11, var12, var7, var8, var9, var10);
    }

    private BlockState updateShape(LevelReader var0, BlockState var1, BlockPos var2, BlockState var3, boolean var4, boolean var5, boolean var6, boolean var7) {
        VoxelShape var8 = var3.getCollisionShape(var0, var2).getFaceShape(Direction.DOWN);
        BlockState var9 = this.updateSides(var1, var4, var5, var6, var7, var8);
        return (BlockState)var9.setValue(UP, this.shouldRaisePost(var9, var3, var8));
    }

    private boolean shouldRaisePost(BlockState var0, BlockState var1, VoxelShape var2) {
        boolean var13;
        boolean var12;
        boolean var3;
        boolean bl = var3 = var1.getBlock() instanceof WallBlock && var1.getValue(UP) != false;
        if (var3) {
            return true;
        }
        WallSide var4 = var0.getValue(NORTH);
        WallSide var5 = var0.getValue(SOUTH);
        WallSide var6 = var0.getValue(EAST);
        WallSide var7 = var0.getValue(WEST);
        boolean var8 = var5 == WallSide.NONE;
        boolean var9 = var7 == WallSide.NONE;
        boolean var10 = var6 == WallSide.NONE;
        boolean var11 = var4 == WallSide.NONE;
        boolean bl2 = var12 = var11 && var8 && var9 && var10 || var11 != var8 || var9 != var10;
        if (var12) {
            return true;
        }
        boolean bl3 = var13 = var4 == WallSide.TALL && var5 == WallSide.TALL || var6 == WallSide.TALL && var7 == WallSide.TALL;
        if (var13) {
            return false;
        }
        return var1.is(BlockTags.WALL_POST_OVERRIDE) || WallBlock.isCovered(var2, TEST_SHAPE_POST);
    }

    private BlockState updateSides(BlockState var0, boolean var1, boolean var2, boolean var3, boolean var4, VoxelShape var5) {
        return (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, this.makeWallState(var1, var5, TEST_SHAPES_WALL.get(Direction.NORTH)))).setValue(EAST, this.makeWallState(var2, var5, TEST_SHAPES_WALL.get(Direction.EAST)))).setValue(SOUTH, this.makeWallState(var3, var5, TEST_SHAPES_WALL.get(Direction.SOUTH)))).setValue(WEST, this.makeWallState(var4, var5, TEST_SHAPES_WALL.get(Direction.WEST)));
    }

    private WallSide makeWallState(boolean var0, VoxelShape var1, VoxelShape var2) {
        if (var0) {
            if (WallBlock.isCovered(var1, var2)) {
                return WallSide.TALL;
            }
            return WallSide.LOW;
        }
        return WallSide.NONE;
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState var0) {
        return var0.getValue(WATERLOGGED) == false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(UP, NORTH, EAST, WEST, SOUTH, WATERLOGGED);
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            }
        }
        return var0;
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            }
        }
        return super.mirror(var0, var1);
    }
}

