/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BrewingStartEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BrewingStandBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    public static final int FUEL_USES = 20;
    public static final int DATA_BREW_TIME = 0;
    public static final int DATA_FUEL_USES = 1;
    public static final int NUM_DATA_VALUES = 2;
    private static final short DEFAULT_BREW_TIME = 0;
    private static final byte DEFAULT_FUEL = 0;
    private static final Component DEFAULT_NAME = Component.translatable("container.brewing");
    private NonNullList<net.minecraft.world.item.ItemStack> items;
    public int brewTime;
    private boolean[] lastPotionCount;
    private Item ingredient;
    public int fuel;
    protected final ContainerData dataAccess;
    private int lastTick = MinecraftServer.currentTick;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.items;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public BrewingStandBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.BREWING_STAND, blockposition, iblockdata);
        this.items = NonNullList.withSize(5, net.minecraft.world.item.ItemStack.EMPTY);
        this.dataAccess = new ContainerData(){

            @Override
            public int get(int i) {
                return switch (i) {
                    case 0 -> BrewingStandBlockEntity.this.brewTime;
                    case 1 -> BrewingStandBlockEntity.this.fuel;
                    default -> 0;
                };
            }

            @Override
            public void set(int i, int j) {
                switch (i) {
                    case 0: {
                        BrewingStandBlockEntity.this.brewTime = j;
                        break;
                    }
                    case 1: {
                        BrewingStandBlockEntity.this.fuel = j;
                    }
                }
            }

            @Override
            public int getCount() {
                return 2;
            }
        };
    }

    @Override
    protected Component getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    public static void serverTick(Level world, BlockPos blockposition, BlockState iblockdata, BrewingStandBlockEntity tileentitybrewingstand) {
        net.minecraft.world.item.ItemStack itemstack = tileentitybrewingstand.items.get(4);
        if (tileentitybrewingstand.fuel <= 0 && itemstack.is(ItemTags.BREWING_FUEL)) {
            BrewingStandFuelEvent event = new BrewingStandFuelEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)CraftItemStack.asCraftMirror(itemstack), 20);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            tileentitybrewingstand.fuel = event.getFuelPower();
            if (tileentitybrewingstand.fuel > 0 && event.isConsuming()) {
                itemstack.shrink(1);
            }
            BrewingStandBlockEntity.setChanged(world, blockposition, iblockdata);
        }
        boolean flag = BrewingStandBlockEntity.isBrewable(world.potionBrewing(), tileentitybrewingstand.items);
        boolean flag1 = tileentitybrewingstand.brewTime > 0;
        net.minecraft.world.item.ItemStack itemstack1 = tileentitybrewingstand.items.get(3);
        int elapsedTicks = MinecraftServer.currentTick - tileentitybrewingstand.lastTick;
        tileentitybrewingstand.lastTick = MinecraftServer.currentTick;
        if (flag1) {
            boolean flag2;
            tileentitybrewingstand.brewTime -= elapsedTicks;
            boolean bl = flag2 = tileentitybrewingstand.brewTime <= 0;
            if (flag2 && flag) {
                BrewingStandBlockEntity.doBrew(world, blockposition, tileentitybrewingstand.items, tileentitybrewingstand);
            } else if (!flag || !itemstack1.is(tileentitybrewingstand.ingredient)) {
                tileentitybrewingstand.brewTime = 0;
            }
            BrewingStandBlockEntity.setChanged(world, blockposition, iblockdata);
        } else if (flag && tileentitybrewingstand.fuel > 0) {
            --tileentitybrewingstand.fuel;
            BrewingStartEvent event = new BrewingStartEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)CraftItemStack.asCraftMirror(itemstack1), 400);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            tileentitybrewingstand.brewTime = event.getTotalBrewTime();
            tileentitybrewingstand.ingredient = itemstack1.getItem();
            BrewingStandBlockEntity.setChanged(world, blockposition, iblockdata);
        }
        boolean[] aboolean = tileentitybrewingstand.getPotionBits();
        if (!Arrays.equals(aboolean, tileentitybrewingstand.lastPotionCount)) {
            tileentitybrewingstand.lastPotionCount = aboolean;
            BlockState iblockdata1 = iblockdata;
            if (!(iblockdata.getBlock() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.HAS_BOTTLE.length; ++i) {
                iblockdata1 = (BlockState)iblockdata1.setValue(BrewingStandBlock.HAS_BOTTLE[i], aboolean[i]);
            }
            world.setBlock(blockposition, iblockdata1, 2);
        }
    }

    private boolean[] getPotionBits() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (this.items.get(i).isEmpty()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private static boolean isBrewable(PotionBrewing potionbrewer, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(3);
        if (itemstack.isEmpty()) {
            return false;
        }
        if (!potionbrewer.isIngredient(itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            net.minecraft.world.item.ItemStack itemstack1 = nonnulllist.get(i);
            if (itemstack1.isEmpty() || !potionbrewer.hasMix(itemstack1, itemstack)) continue;
            return true;
        }
        return false;
    }

    private static void doBrew(Level world, BlockPos blockposition, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, BrewingStandBlockEntity tileentitybrewingstand) {
        int i;
        net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(3);
        PotionBrewing potionbrewer = world.potionBrewing();
        InventoryHolder owner = tileentitybrewingstand.getOwner();
        ArrayList<CraftItemStack> brewResults = new ArrayList<CraftItemStack>(3);
        for (i = 0; i < 3; ++i) {
            brewResults.add(i, CraftItemStack.asCraftMirror(potionbrewer.mix(itemstack, nonnulllist.get(i))));
        }
        if (owner != null) {
            BrewEvent event = new BrewEvent((Block)CraftBlock.at(world, blockposition), (BrewerInventory)owner.getInventory(), brewResults, tileentitybrewingstand.fuel);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        for (i = 0; i < 3; ++i) {
            if (i < brewResults.size()) {
                nonnulllist.set(i, CraftItemStack.asNMSCopy((ItemStack)brewResults.get(i)));
                continue;
            }
            nonnulllist.set(i, net.minecraft.world.item.ItemStack.EMPTY);
        }
        itemstack.shrink(1);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.getItem().getCraftingRemainder();
        if (!itemstack1.isEmpty()) {
            if (itemstack.isEmpty()) {
                itemstack = itemstack1;
            } else {
                Containers.dropItemStack(world, blockposition.getX(), blockposition.getY(), blockposition.getZ(), itemstack1);
            }
        }
        nonnulllist.set(3, itemstack);
        world.levelEvent(1035, blockposition, 0);
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.items = NonNullList.withSize(this.getContainerSize(), net.minecraft.world.item.ItemStack.EMPTY);
        ContainerHelper.loadAllItems(valueinput, this.items);
        this.brewTime = valueinput.getShortOr("BrewTime", (short)0);
        if (this.brewTime > 0) {
            this.ingredient = this.items.get(3).getItem();
        }
        this.fuel = valueinput.getByteOr("Fuel", (byte)0);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        valueoutput.putShort("BrewTime", (short)this.brewTime);
        ContainerHelper.saveAllItems(valueoutput, this.items);
        valueoutput.putByte("Fuel", (byte)this.fuel);
    }

    @Override
    public boolean canPlaceItem(int i, net.minecraft.world.item.ItemStack itemstack) {
        if (i == 3) {
            PotionBrewing potionbrewer = this.level != null ? this.level.potionBrewing() : PotionBrewing.EMPTY;
            return potionbrewer.isIngredient(itemstack);
        }
        return i == 4 ? itemstack.is(ItemTags.BREWING_FUEL) : (itemstack.is(Items.POTION) || itemstack.is(Items.SPLASH_POTION) || itemstack.is(Items.LINGERING_POTION) || itemstack.is(Items.GLASS_BOTTLE)) && this.getItem(i).isEmpty();
    }

    @Override
    public int[] getSlotsForFace(Direction enumdirection) {
        return enumdirection == Direction.UP ? SLOTS_FOR_UP : (enumdirection == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_SIDES);
    }

    @Override
    public boolean canPlaceItemThroughFace(int i, net.minecraft.world.item.ItemStack itemstack, @Nullable Direction enumdirection) {
        return this.canPlaceItem(i, itemstack);
    }

    @Override
    public boolean canTakeItemThroughFace(int i, net.minecraft.world.item.ItemStack itemstack, Direction enumdirection) {
        return i == 3 ? itemstack.is(Items.GLASS_BOTTLE) : true;
    }

    @Override
    protected AbstractContainerMenu createMenu(int i, Inventory playerinventory) {
        return new BrewingStandMenu(i, playerinventory, this, this.dataAccess);
    }
}

