/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CopperGolemStatueBlockEntity
extends BlockEntity {
    public CopperGolemStatueBlockEntity(BlockPos var0, BlockState var1) {
        super(BlockEntityType.COPPER_GOLEM_STATUE, var0, var1);
    }

    public void createStatue(CopperGolem var0) {
        this.setComponents(DataComponentMap.builder().addAll(this.components()).set(DataComponents.CUSTOM_NAME, var0.getCustomName()).build());
        super.setChanged();
    }

    @Nullable
    public CopperGolem removeStatue(BlockState var0) {
        CopperGolem var1 = EntityType.COPPER_GOLEM.create(this.level, EntitySpawnReason.TRIGGERED);
        if (var1 != null) {
            var1.setCustomName(this.components().get(DataComponents.CUSTOM_NAME));
            return this.initCopperGolem(var0, var1);
        }
        return null;
    }

    private CopperGolem initCopperGolem(BlockState var0, CopperGolem var1) {
        BlockPos var2 = this.getBlockPos();
        var1.snapTo(var2.getCenter().x, var2.getY(), var2.getCenter().z, var0.getValue(CopperGolemStatueBlock.FACING).toYRot(), 0.0f);
        var1.yHeadRot = var1.getYRot();
        var1.yBodyRot = var1.getYRot();
        var1.playSpawnSound();
        return var1;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    public ItemStack getItem(ItemStack var0, CopperGolemStatueBlock.Pose var1) {
        var0.applyComponents(this.collectComponents());
        var0.set(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY.with(CopperGolemStatueBlock.POSE, var1));
        return var0;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

