/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SkullBlockEntity
extends BlockEntity {
    private static final String TAG_PROFILE = "profile";
    private static final String TAG_NOTE_BLOCK_SOUND = "note_block_sound";
    private static final String TAG_CUSTOM_NAME = "custom_name";
    @Nullable
    public ResolvableProfile owner;
    @Nullable
    public ResourceLocation noteBlockSound;
    private int animationTickCount;
    private boolean isAnimating;
    @Nullable
    private Component customName;

    public SkullBlockEntity(BlockPos var0, BlockState var1) {
        super(BlockEntityType.SKULL, var0, var1);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.storeNullable(TAG_PROFILE, ResolvableProfile.CODEC, this.owner);
        var0.storeNullable(TAG_NOTE_BLOCK_SOUND, ResourceLocation.CODEC, this.noteBlockSound);
        var0.storeNullable(TAG_CUSTOM_NAME, ComponentSerialization.CODEC, this.customName);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.owner = var0.read(TAG_PROFILE, ResolvableProfile.CODEC).orElse(null);
        this.noteBlockSound = var0.read(TAG_NOTE_BLOCK_SOUND, ResourceLocation.CODEC).orElse(null);
        this.customName = SkullBlockEntity.parseCustomNameSafe(var0, TAG_CUSTOM_NAME);
    }

    public static void animation(Level var0, BlockPos var1, BlockState var2, SkullBlockEntity var3) {
        if (var2.hasProperty(SkullBlock.POWERED) && var2.getValue(SkullBlock.POWERED).booleanValue()) {
            var3.isAnimating = true;
            ++var3.animationTickCount;
        } else {
            var3.isAnimating = false;
        }
    }

    public float getAnimation(float var0) {
        if (this.isAnimating) {
            return (float)this.animationTickCount + var0;
        }
        return this.animationTickCount;
    }

    @Nullable
    public ResolvableProfile getOwnerProfile() {
        return this.owner;
    }

    @Nullable
    public ResourceLocation getNoteBlockSound() {
        return this.noteBlockSound;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider var0) {
        return this.saveCustomOnly(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        super.applyImplicitComponents(var0);
        this.owner = var0.get(DataComponents.PROFILE);
        this.noteBlockSound = var0.get(DataComponents.NOTE_BLOCK_SOUND);
        this.customName = var0.get(DataComponents.CUSTOM_NAME);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.PROFILE, this.owner);
        var0.set(DataComponents.NOTE_BLOCK_SOUND, this.noteBlockSound);
        var0.set(DataComponents.CUSTOM_NAME, this.customName);
    }

    @Override
    public void removeComponentsFromTag(ValueOutput var0) {
        super.removeComponentsFromTag(var0);
        var0.discard(TAG_PROFILE);
        var0.discard(TAG_NOTE_BLOCK_SOUND);
        var0.discard(TAG_CUSTOM_NAME);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

