/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public final class TrialSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final TrialSpawnerStateData data = new TrialSpawnerStateData();
    public FullConfig config;
    public final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    public boolean isOminous;

    public TrialSpawner(FullConfig trialspawner_b, StateAccessor trialspawner_c, PlayerDetector playerdetector, PlayerDetector.EntitySelector playerdetector_a) {
        this.config = trialspawner_b;
        this.stateAccessor = trialspawner_c;
        this.playerDetector = playerdetector;
        this.entitySelector = playerdetector_a;
    }

    public TrialSpawnerConfig activeConfig() {
        return this.isOminous ? this.config.ominous().value() : this.config.normal.value();
    }

    public TrialSpawnerConfig normalConfig() {
        return this.config.normal.value();
    }

    public TrialSpawnerConfig ominousConfig() {
        return this.config.ominous.value();
    }

    public void load(ValueInput valueinput) {
        Optional<TrialSpawnerStateData.Packed> optional = valueinput.read(TrialSpawnerStateData.Packed.MAP_CODEC);
        TrialSpawnerStateData trialspawnerdata = this.data;
        Objects.requireNonNull(this.data);
        optional.ifPresent(trialspawnerdata::apply);
        this.config = valueinput.read(FullConfig.MAP_CODEC).orElse(FullConfig.DEFAULT);
    }

    public void store(ValueOutput valueoutput) {
        valueoutput.store(TrialSpawnerStateData.Packed.MAP_CODEC, this.data.pack());
        valueoutput.store(FullConfig.MAP_CODEC, this.config);
    }

    public void applyOminous(ServerLevel worldserver, BlockPos blockposition) {
        worldserver.setBlock(blockposition, (BlockState)worldserver.getBlockState(blockposition).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        worldserver.levelEvent(3020, blockposition, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, worldserver);
    }

    public void removeOminous(ServerLevel worldserver, BlockPos blockposition) {
        worldserver.setBlock(blockposition, (BlockState)worldserver.getBlockState(blockposition).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public int getTargetCooldownLength() {
        return this.config.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.config.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public TrialSpawnerStateData getStateData() {
        return this.data;
    }

    public void setState(Level world, TrialSpawnerState trialspawnerstate) {
        this.stateAccessor.setState(world, trialspawnerstate);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(ServerLevel worldserver) {
        return !worldserver.getServer().getGameRules().getBoolean(GameRules.RULE_SPAWNER_BLOCKS_ENABLED) ? false : (this.overridePeacefulAndMobSpawnRule ? true : (worldserver.getDifficulty() == Difficulty.PEACEFUL ? false : worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)));
    }

    public Optional<UUID> spawnMob(ServerLevel worldserver, BlockPos blockposition) {
        RandomSource randomsource = worldserver.getRandom();
        SpawnData mobspawnerdata = this.data.getOrCreateNextSpawnData(this, worldserver.getRandom());
        try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(() -> "spawner@" + String.valueOf(blockposition), LOGGER);){
            Object entityinsentient;
            SpawnData.CustomSpawnRules mobspawnerdata_a;
            ValueInput valueinput = TagValueInput.create((ProblemReporter)problemreporter_j, (HolderLookup.Provider)worldserver.registryAccess(), mobspawnerdata.entityToSpawn());
            Optional<EntityType<?>> optional = EntityType.by(valueinput);
            if (optional.isEmpty()) {
                Optional<UUID> optional2 = Optional.empty();
                return optional2;
            }
            Vec3 vec3d = valueinput.read("Pos", Vec3.CODEC).orElseGet(() -> {
                TrialSpawnerConfig trialspawnerconfig = this.activeConfig();
                return new Vec3((double)blockposition.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)trialspawnerconfig.spawnRange() + 0.5, blockposition.getY() + randomsource.nextInt(3) - 1, (double)blockposition.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)trialspawnerconfig.spawnRange() + 0.5);
            });
            if (!worldserver.noCollision(optional.get().getSpawnAABB(vec3d.x, vec3d.y, vec3d.z))) {
                Optional<UUID> optional3 = Optional.empty();
                return optional3;
            }
            if (!TrialSpawner.inLineOfSight(worldserver, blockposition.getCenter(), vec3d)) {
                Optional<UUID> optional4 = Optional.empty();
                return optional4;
            }
            BlockPos blockposition1 = BlockPos.containing(vec3d);
            if (!SpawnPlacements.checkSpawnRules(optional.get(), worldserver, EntitySpawnReason.TRIAL_SPAWNER, blockposition1, worldserver.getRandom())) {
                Optional<UUID> optional5 = Optional.empty();
                return optional5;
            }
            if (mobspawnerdata.getCustomSpawnRules().isPresent() && !(mobspawnerdata_a = mobspawnerdata.getCustomSpawnRules().get()).isValidPosition(blockposition1, worldserver)) {
                Optional<UUID> optional6 = Optional.empty();
                return optional6;
            }
            Entity entity = EntityType.loadEntityRecursive(valueinput, (Level)worldserver, EntitySpawnReason.TRIAL_SPAWNER, entity1 -> {
                entity1.snapTo(vec3d.x, vec3d.y, vec3d.z, randomsource.nextFloat() * 360.0f, 0.0f);
                return entity1;
            });
            if (entity == null) {
                Optional<UUID> optional7 = Optional.empty();
                return optional7;
            }
            if (entity instanceof Mob) {
                boolean flag;
                entityinsentient = (Mob)entity;
                if (!((Mob)entityinsentient).checkSpawnObstruction(worldserver)) {
                    Optional<UUID> optional8 = Optional.empty();
                    return optional8;
                }
                boolean bl = flag = mobspawnerdata.getEntityToSpawn().size() == 1 && mobspawnerdata.getEntityToSpawn().getString("id").isPresent();
                if (flag) {
                    ((Mob)entityinsentient).finalizeSpawn(worldserver, worldserver.getCurrentDifficultyAt(((Entity)entityinsentient).blockPosition()), EntitySpawnReason.TRIAL_SPAWNER, null);
                }
                ((Mob)entityinsentient).setPersistenceRequired();
                Optional<EquipmentTable> optional1 = mobspawnerdata.getEquipment();
                Objects.requireNonNull(entityinsentient);
                optional1.ifPresent(arg_0 -> entityinsentient.equip(arg_0));
            }
            if (CraftEventFactory.callTrialSpawnerSpawnEvent(entity, blockposition).isCancelled()) {
                entityinsentient = Optional.empty();
                return entityinsentient;
            }
            if (!worldserver.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER)) {
                entityinsentient = Optional.empty();
                return entityinsentient;
            }
            FlameParticle trialspawner_a = this.isOminous ? FlameParticle.OMINOUS : FlameParticle.NORMAL;
            worldserver.levelEvent(3011, blockposition, trialspawner_a.encode());
            worldserver.levelEvent(3012, blockposition1, trialspawner_a.encode());
            worldserver.gameEvent(entity, GameEvent.ENTITY_PLACE, blockposition1);
            Optional<UUID> optional9 = Optional.of(entity.getUUID());
            return optional9;
        }
    }

    public void ejectReward(ServerLevel worldserver, BlockPos blockposition, ResourceKey<LootTable> resourcekey) {
        LootParams lootparams;
        LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(resourcekey);
        ObjectArrayList objectarraylist = loottable.getRandomItems(lootparams = new LootParams.Builder(worldserver).create(LootContextParamSets.EMPTY));
        if (!objectarraylist.isEmpty()) {
            BlockDispenseLootEvent spawnerDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(worldserver, blockposition, null, objectarraylist);
            if (spawnerDispenseLootEvent.isCancelled()) {
                return;
            }
            objectarraylist = new ObjectArrayList(spawnerDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList());
            for (ItemStack itemstack : objectarraylist) {
                DefaultDispenseItemBehavior.spawnItem(worldserver, itemstack, 2, Direction.UP, Vec3.atBottomCenterOf(blockposition).relative(Direction.UP, 1.2));
            }
            worldserver.levelEvent(3014, blockposition, 0);
        }
    }

    public void tickClient(Level world, BlockPos blockposition, boolean flag) {
        RandomSource randomsource;
        TrialSpawnerState trialspawnerstate = this.getState();
        trialspawnerstate.emitParticles(world, blockposition, flag);
        if (trialspawnerstate.hasSpinningMob()) {
            double d0 = Math.max(0L, this.data.nextMobSpawnsAt - world.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + trialspawnerstate.spinningMobSpeed() / (d0 + 200.0)) % 360.0;
        }
        if (trialspawnerstate.isCapableOfSpawning() && (randomsource = world.getRandom()).nextFloat() <= 0.02f) {
            SoundEvent soundeffect = flag ? SoundEvents.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEvents.TRIAL_SPAWNER_AMBIENT;
            world.playLocalSound(blockposition, soundeffect, SoundSource.BLOCKS, randomsource.nextFloat() * 0.25f + 0.75f, randomsource.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        TrialSpawnerState trialspawnerstate1;
        this.isOminous = flag;
        TrialSpawnerState trialspawnerstate = this.getState();
        if (this.data.currentMobs.removeIf(uuid -> TrialSpawner.shouldMobBeUntracked(worldserver, blockposition, uuid))) {
            this.data.nextMobSpawnsAt = worldserver.getGameTime() + (long)this.activeConfig().ticksBetweenSpawn();
        }
        if ((trialspawnerstate1 = trialspawnerstate.tickAndGetNext(blockposition, this, worldserver)) != trialspawnerstate) {
            this.setState(worldserver, trialspawnerstate1);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel worldserver, BlockPos blockposition, UUID uuid) {
        Entity entity = worldserver.getEntity(uuid);
        return entity == null || !entity.isAlive() || !entity.level().dimension().equals(worldserver.dimension()) || entity.blockPosition().distSqr(blockposition) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level world, Vec3 vec3d, Vec3 vec3d1) {
        BlockHitResult movingobjectpositionblock = world.clip(new ClipContext(vec3d1, vec3d, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return movingobjectpositionblock.getBlockPos().equals(BlockPos.containing(vec3d)) || movingobjectpositionblock.getType() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(Level world, BlockPos blockposition, RandomSource randomsource, SimpleParticleType particletype) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)blockposition.getX() + 0.5 + (randomsource.nextDouble() - 0.5) * 2.0;
            double d1 = (double)blockposition.getY() + 0.5 + (randomsource.nextDouble() - 0.5) * 2.0;
            double d2 = (double)blockposition.getZ() + 0.5 + (randomsource.nextDouble() - 0.5) * 2.0;
            world.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            world.addParticle(particletype, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(Level world, BlockPos blockposition, RandomSource randomsource) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)blockposition.getX() + 0.5 + (randomsource.nextDouble() - 0.5) * 2.0;
            double d1 = (double)blockposition.getY() + 0.5 + (randomsource.nextDouble() - 0.5) * 2.0;
            double d2 = (double)blockposition.getZ() + 0.5 + (randomsource.nextDouble() - 0.5) * 2.0;
            double d3 = randomsource.nextGaussian() * 0.02;
            double d4 = randomsource.nextGaussian() * 0.02;
            double d5 = randomsource.nextGaussian() * 0.02;
            world.addParticle(ParticleTypes.TRIAL_OMEN, d0, d1, d2, d3, d4, d5);
            world.addParticle(ParticleTypes.SOUL_FIRE_FLAME, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void addDetectPlayerParticles(Level world, BlockPos blockposition, RandomSource randomsource, int i, ParticleOptions particleparam) {
        for (int j = 0; j < 30 + Math.min(i, 10) * 5; ++j) {
            double d0 = (double)(2.0f * randomsource.nextFloat() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * randomsource.nextFloat() - 1.0f) * 0.65;
            double d2 = (double)blockposition.getX() + 0.5 + d0;
            double d3 = (double)blockposition.getY() + 0.1 + (double)randomsource.nextFloat() * 0.8;
            double d4 = (double)blockposition.getZ() + 0.5 + d1;
            world.addParticle(particleparam, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(Level world, BlockPos blockposition, RandomSource randomsource) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)blockposition.getX() + 0.4 + randomsource.nextDouble() * 0.2;
            double d1 = (double)blockposition.getY() + 0.4 + randomsource.nextDouble() * 0.2;
            double d2 = (double)blockposition.getZ() + 0.4 + randomsource.nextDouble() * 0.2;
            double d3 = randomsource.nextGaussian() * 0.02;
            double d4 = randomsource.nextGaussian() * 0.02;
            double d5 = randomsource.nextGaussian() * 0.02;
            world.addParticle(ParticleTypes.SMALL_FLAME, d0, d1, d2, d3, d4, d5 * 0.25);
            world.addParticle(ParticleTypes.SMOKE, d0, d1, d2, d3, d4, d5);
        }
    }

    public void overrideEntityToSpawn(EntityType<?> entitytypes, Level world) {
        this.data.reset();
        this.config = this.config.overrideEntity(entitytypes);
        this.setState(world, TrialSpawnerState.INACTIVE);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector playerdetector) {
        this.playerDetector = playerdetector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public record FullConfig(Holder<TrialSpawnerConfig> normal, Holder<TrialSpawnerConfig> ominous, int targetCooldownLength, int requiredPlayerRange) {
        public static final MapCodec<FullConfig> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf("normal_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(FullConfig::normal), (App)TrialSpawnerConfig.CODEC.optionalFieldOf("ominous_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(FullConfig::ominous), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(FullConfig::targetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(FullConfig::requiredPlayerRange)).apply((Applicative)instance, FullConfig::new));
        public static final FullConfig DEFAULT = new FullConfig(Holder.direct(TrialSpawnerConfig.DEFAULT), Holder.direct(TrialSpawnerConfig.DEFAULT), 36000, 14);

        public FullConfig overrideEntity(EntityType<?> entitytypes) {
            return new FullConfig(Holder.direct(this.normal.value().withSpawning(entitytypes)), Holder.direct(this.ominous.value().withSpawning(entitytypes)), this.targetCooldownLength, this.requiredPlayerRange);
        }
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static enum FlameParticle {
        NORMAL(ParticleTypes.FLAME),
        OMINOUS(ParticleTypes.SOUL_FIRE_FLAME);

        public final SimpleParticleType particleType;

        private FlameParticle(SimpleParticleType particletype) {
            this.particleType = particletype;
        }

        public static FlameParticle decode(int i) {
            FlameParticle[] atrialspawner_a = FlameParticle.values();
            return i <= atrialspawner_a.length && i >= 0 ? atrialspawner_a[i] : NORMAL;
        }

        public int encode() {
            return this.ordinal();
        }
    }
}

