/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.TickContainerAccess;

public class ImposterProtoChunk
extends ProtoChunk {
    private final LevelChunk wrapped;
    private final boolean allowWrites;

    public ImposterProtoChunk(LevelChunk var0, boolean var1) {
        super(var0.getPos(), UpgradeData.EMPTY, var0.levelHeightAccessor, var0.getLevel().palettedContainerFactory(), var0.getBlendingData());
        this.wrapped = var0;
        this.allowWrites = var1;
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos var0) {
        return this.wrapped.getBlockEntity(var0);
    }

    @Override
    public BlockState getBlockState(BlockPos var0) {
        return this.wrapped.getBlockState(var0);
    }

    @Override
    public FluidState getFluidState(BlockPos var0) {
        return this.wrapped.getFluidState(var0);
    }

    @Override
    public LevelChunkSection getSection(int var0) {
        if (this.allowWrites) {
            return this.wrapped.getSection(var0);
        }
        return super.getSection(var0);
    }

    @Override
    @Nullable
    public BlockState setBlockState(BlockPos var0, BlockState var1, int var2) {
        if (this.allowWrites) {
            return this.wrapped.setBlockState(var0, var1, var2);
        }
        return null;
    }

    @Override
    public void setBlockEntity(BlockEntity var0) {
        if (this.allowWrites) {
            this.wrapped.setBlockEntity(var0);
        }
    }

    @Override
    public void addEntity(Entity var0) {
        if (this.allowWrites) {
            this.wrapped.addEntity(var0);
        }
    }

    @Override
    public void setPersistedStatus(ChunkStatus var0) {
        if (this.allowWrites) {
            super.setPersistedStatus(var0);
        }
    }

    @Override
    public LevelChunkSection[] getSections() {
        return this.wrapped.getSections();
    }

    @Override
    public void setHeightmap(Heightmap.Types var0, long[] var1) {
    }

    private Heightmap.Types fixType(Heightmap.Types var0) {
        if (var0 == Heightmap.Types.WORLD_SURFACE_WG) {
            return Heightmap.Types.WORLD_SURFACE;
        }
        if (var0 == Heightmap.Types.OCEAN_FLOOR_WG) {
            return Heightmap.Types.OCEAN_FLOOR;
        }
        return var0;
    }

    @Override
    public Heightmap getOrCreateHeightmapUnprimed(Heightmap.Types var0) {
        return this.wrapped.getOrCreateHeightmapUnprimed(var0);
    }

    @Override
    public int getHeight(Heightmap.Types var0, int var1, int var2) {
        return this.wrapped.getHeight(this.fixType(var0), var1, var2);
    }

    @Override
    public Holder<Biome> getNoiseBiome(int var0, int var1, int var2) {
        return this.wrapped.getNoiseBiome(var0, var1, var2);
    }

    @Override
    public ChunkPos getPos() {
        return this.wrapped.getPos();
    }

    @Override
    @Nullable
    public StructureStart getStartForStructure(Structure var0) {
        return this.wrapped.getStartForStructure(var0);
    }

    @Override
    public void setStartForStructure(Structure var0, StructureStart var1) {
    }

    @Override
    public Map<Structure, StructureStart> getAllStarts() {
        return this.wrapped.getAllStarts();
    }

    @Override
    public void setAllStarts(Map<Structure, StructureStart> var0) {
    }

    @Override
    public LongSet getReferencesForStructure(Structure var0) {
        return this.wrapped.getReferencesForStructure(var0);
    }

    @Override
    public void addReferenceForStructure(Structure var0, long var1) {
    }

    @Override
    public Map<Structure, LongSet> getAllReferences() {
        return this.wrapped.getAllReferences();
    }

    @Override
    public void setAllReferences(Map<Structure, LongSet> var0) {
    }

    @Override
    public void markUnsaved() {
        this.wrapped.markUnsaved();
    }

    @Override
    public boolean canBeSerialized() {
        return false;
    }

    @Override
    public boolean tryMarkSaved() {
        return false;
    }

    @Override
    public boolean isUnsaved() {
        return false;
    }

    @Override
    public ChunkStatus getPersistedStatus() {
        return this.wrapped.getPersistedStatus();
    }

    @Override
    public void removeBlockEntity(BlockPos var0) {
    }

    @Override
    public void markPosForPostprocessing(BlockPos var0) {
    }

    @Override
    public void setBlockEntityNbt(CompoundTag var0) {
    }

    @Override
    @Nullable
    public CompoundTag getBlockEntityNbt(BlockPos var0) {
        return this.wrapped.getBlockEntityNbt(var0);
    }

    @Override
    @Nullable
    public CompoundTag getBlockEntityNbtForSaving(BlockPos var0, HolderLookup.Provider var1) {
        return this.wrapped.getBlockEntityNbtForSaving(var0, var1);
    }

    @Override
    public void findBlocks(Predicate<BlockState> var0, BiConsumer<BlockPos, BlockState> var1) {
        this.wrapped.findBlocks(var0, var1);
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        if (this.allowWrites) {
            return this.wrapped.getBlockTicks();
        }
        return BlackholeTickAccess.emptyContainer();
    }

    @Override
    public TickContainerAccess<Fluid> getFluidTicks() {
        if (this.allowWrites) {
            return this.wrapped.getFluidTicks();
        }
        return BlackholeTickAccess.emptyContainer();
    }

    @Override
    public ChunkAccess.PackedTicks getTicksForSerialization(long var0) {
        return this.wrapped.getTicksForSerialization(var0);
    }

    @Override
    @Nullable
    public BlendingData getBlendingData() {
        return this.wrapped.getBlendingData();
    }

    @Override
    public CarvingMask getCarvingMask() {
        if (this.allowWrites) {
            return super.getCarvingMask();
        }
        throw Util.pauseInIde(new UnsupportedOperationException("Meaningless in this context"));
    }

    @Override
    public CarvingMask getOrCreateCarvingMask() {
        if (this.allowWrites) {
            return super.getOrCreateCarvingMask();
        }
        throw Util.pauseInIde(new UnsupportedOperationException("Meaningless in this context"));
    }

    public LevelChunk getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean isLightCorrect() {
        return this.wrapped.isLightCorrect();
    }

    @Override
    public void setLightCorrect(boolean var0) {
        this.wrapped.setLightCorrect(var0);
    }

    @Override
    public void fillBiomesFromNoise(BiomeResolver var0, Climate.Sampler var1) {
        if (this.allowWrites) {
            this.wrapped.fillBiomesFromNoise(var0, var1);
        }
    }

    @Override
    public void initializeLightSources() {
        this.wrapped.initializeLightSources();
    }

    @Override
    public ChunkSkyLightSources getSkyLightSources() {
        return this.wrapped.getSkyLightSources();
    }
}

