/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;

public class LevelEntityGetterAdapter<T extends EntityAccess>
implements LevelEntityGetter<T> {
    private final EntityLookup<T> visibleEntities;
    private final EntitySectionStorage<T> sectionStorage;

    public LevelEntityGetterAdapter(EntityLookup<T> var0, EntitySectionStorage<T> var1) {
        this.visibleEntities = var0;
        this.sectionStorage = var1;
    }

    @Override
    @Nullable
    public T get(int var0) {
        return this.visibleEntities.getEntity(var0);
    }

    @Override
    @Nullable
    public T get(UUID var0) {
        return this.visibleEntities.getEntity(var0);
    }

    @Override
    public Iterable<T> getAll() {
        return this.visibleEntities.getAllEntities();
    }

    @Override
    public <U extends T> void get(EntityTypeTest<T, U> var0, AbortableIterationConsumer<U> var1) {
        this.visibleEntities.getEntities(var0, var1);
    }

    @Override
    public void get(AABB var0, Consumer<T> var1) {
        this.sectionStorage.getEntities(var0, AbortableIterationConsumer.forConsumer(var1));
    }

    @Override
    public <U extends T> void get(EntityTypeTest<T, U> var0, AABB var1, AbortableIterationConsumer<U> var2) {
        this.sectionStorage.getEntities(var0, var1, var2);
    }
}

