/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration;

public class EndGatewayFeature
extends Feature<EndGatewayConfiguration> {
    public EndGatewayFeature(Codec<EndGatewayConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<EndGatewayConfiguration> var0) {
        BlockPos var1 = var0.origin();
        WorldGenLevel var2 = var0.level();
        EndGatewayConfiguration var32 = var0.config();
        for (BlockPos var5 : BlockPos.betweenClosed(var1.offset(-1, -2, -1), var1.offset(1, 2, 1))) {
            boolean var9;
            boolean var6 = var5.getX() == var1.getX();
            boolean var7 = var5.getY() == var1.getY();
            boolean var8 = var5.getZ() == var1.getZ();
            boolean bl = var9 = Math.abs(var5.getY() - var1.getY()) == 2;
            if (var6 && var7 && var8) {
                BlockPos var10 = var5.immutable();
                this.setBlock(var2, var10, Blocks.END_GATEWAY.defaultBlockState());
                var32.getExit().ifPresent(var3 -> {
                    BlockEntity var4 = var2.getBlockEntity(var10);
                    if (var4 instanceof TheEndGatewayBlockEntity) {
                        TheEndGatewayBlockEntity var5 = (TheEndGatewayBlockEntity)var4;
                        var5.setExitPosition((BlockPos)var3, var32.isExitExact());
                    }
                });
                continue;
            }
            if (var7) {
                this.setBlock(var2, var5, Blocks.AIR.defaultBlockState());
                continue;
            }
            if (var9 && var6 && var8) {
                this.setBlock(var2, var5, Blocks.BEDROCK.defaultBlockState());
                continue;
            }
            if (!var6 && !var8 || var9) {
                this.setBlock(var2, var5, Blocks.AIR.defaultBlockState());
                continue;
            }
            this.setBlock(var2, var5, Blocks.BEDROCK.defaultBlockState());
        }
        return true;
    }
}

