/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluids;

public abstract class FoliagePlacer {
    public static final Codec<FoliagePlacer> CODEC = BuiltInRegistries.FOLIAGE_PLACER_TYPE.byNameCodec().dispatch(FoliagePlacer::type, FoliagePlacerType::codec);
    protected final IntProvider radius;
    protected final IntProvider offset;

    protected static <P extends FoliagePlacer> Products.P2<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider> foliagePlacerParts(RecordCodecBuilder.Instance<P> var02) {
        return var02.group((App)IntProvider.codec(0, 16).fieldOf("radius").forGetter(var0 -> var0.radius), (App)IntProvider.codec(0, 16).fieldOf("offset").forGetter(var0 -> var0.offset));
    }

    public FoliagePlacer(IntProvider var0, IntProvider var1) {
        this.radius = var0;
        this.offset = var1;
    }

    protected abstract FoliagePlacerType<?> type();

    public void createFoliage(LevelSimulatedReader var0, FoliageSetter var1, RandomSource var2, TreeConfiguration var3, int var4, FoliageAttachment var5, int var6, int var7) {
        this.createFoliage(var0, var1, var2, var3, var4, var5, var6, var7, this.offset(var2));
    }

    protected abstract void createFoliage(LevelSimulatedReader var1, FoliageSetter var2, RandomSource var3, TreeConfiguration var4, int var5, FoliageAttachment var6, int var7, int var8, int var9);

    public abstract int foliageHeight(RandomSource var1, int var2, TreeConfiguration var3);

    public int foliageRadius(RandomSource var0, int var1) {
        return this.radius.sample(var0);
    }

    private int offset(RandomSource var0) {
        return this.offset.sample(var0);
    }

    protected abstract boolean shouldSkipLocation(RandomSource var1, int var2, int var3, int var4, int var5, boolean var6);

    protected boolean shouldSkipLocationSigned(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        int var7;
        int var6;
        if (var5) {
            var6 = Math.min(Math.abs(var1), Math.abs(var1 - 1));
            var7 = Math.min(Math.abs(var3), Math.abs(var3 - 1));
        } else {
            var6 = Math.abs(var1);
            var7 = Math.abs(var3);
        }
        return this.shouldSkipLocation(var0, var6, var2, var7, var4, var5);
    }

    protected void placeLeavesRow(LevelSimulatedReader var0, FoliageSetter var1, RandomSource var2, TreeConfiguration var3, BlockPos var4, int var5, int var6, boolean var7) {
        int var8 = var7 ? 1 : 0;
        BlockPos.MutableBlockPos var9 = new BlockPos.MutableBlockPos();
        for (int var10 = -var5; var10 <= var5 + var8; ++var10) {
            for (int var11 = -var5; var11 <= var5 + var8; ++var11) {
                if (this.shouldSkipLocationSigned(var2, var10, var6, var11, var5, var7)) continue;
                var9.setWithOffset(var4, var10, var6, var11);
                FoliagePlacer.tryPlaceLeaf(var0, var1, var2, var3, var9);
            }
        }
    }

    protected final void placeLeavesRowWithHangingLeavesBelow(LevelSimulatedReader var0, FoliageSetter var1, RandomSource var2, TreeConfiguration var3, BlockPos var4, int var5, int var6, boolean var7, float var8, float var9) {
        this.placeLeavesRow(var0, var1, var2, var3, var4, var5, var6, var7);
        int var10 = var7 ? 1 : 0;
        BlockPos var11 = var4.below();
        BlockPos.MutableBlockPos var12 = new BlockPos.MutableBlockPos();
        for (Direction var14 : Direction.Plane.HORIZONTAL) {
            Direction var15 = var14.getClockWise();
            int var16 = var15.getAxisDirection() == Direction.AxisDirection.POSITIVE ? var5 + var10 : var5;
            var12.setWithOffset(var4, 0, var6 - 1, 0).move(var15, var16).move(var14, -var5);
            for (int var17 = -var5; var17 < var5 + var10; ++var17) {
                boolean var18 = var1.isSet(var12.move(Direction.UP));
                var12.move(Direction.DOWN);
                if (var18 && FoliagePlacer.tryPlaceExtension(var0, var1, var2, var3, var8, var11, var12)) {
                    var12.move(Direction.DOWN);
                    FoliagePlacer.tryPlaceExtension(var0, var1, var2, var3, var9, var11, var12);
                    var12.move(Direction.UP);
                }
                var12.move(var14);
            }
        }
    }

    private static boolean tryPlaceExtension(LevelSimulatedReader var0, FoliageSetter var1, RandomSource var2, TreeConfiguration var3, float var4, BlockPos var5, BlockPos.MutableBlockPos var6) {
        if (var6.distManhattan(var5) >= 7) {
            return false;
        }
        if (var2.nextFloat() > var4) {
            return false;
        }
        return FoliagePlacer.tryPlaceLeaf(var0, var1, var2, var3, var6);
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader var02, FoliageSetter var1, RandomSource var2, TreeConfiguration var3, BlockPos var4) {
        boolean var5 = var02.isStateAtPosition(var4, var0 -> var0.getValueOrElse(BlockStateProperties.PERSISTENT, false));
        if (var5 || !TreeFeature.validTreePos(var02, var4)) {
            return false;
        }
        BlockState var6 = var3.foliageProvider.getState(var2, var4);
        if (var6.hasProperty(BlockStateProperties.WATERLOGGED)) {
            var6 = (BlockState)var6.setValue(BlockStateProperties.WATERLOGGED, var02.isFluidAtPosition(var4, var0 -> var0.isSourceOfType(Fluids.WATER)));
        }
        var1.set(var4, var6);
        return true;
    }

    public static interface FoliageSetter {
        public void set(BlockPos var1, BlockState var2);

        public boolean isSet(BlockPos var1);
    }

    public static final class FoliageAttachment {
        private final BlockPos pos;
        private final int radiusOffset;
        private final boolean doubleTrunk;

        public FoliageAttachment(BlockPos var0, int var1, boolean var2) {
            this.pos = var0;
            this.radiusOffset = var1;
            this.doubleTrunk = var2;
        }

        public BlockPos pos() {
            return this.pos;
        }

        public int radiusOffset() {
            return this.radiusOffset;
        }

        public boolean doubleTrunk() {
            return this.doubleTrunk;
        }
    }
}

