/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class GiantTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<GiantTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(var0 -> GiantTrunkPlacer.trunkPlacerParts(var0).apply((Applicative)var0, GiantTrunkPlacer::new));

    public GiantTrunkPlacer(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    @Override
    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.GIANT_TRUNK_PLACER;
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, int var3, BlockPos var4, TreeConfiguration var5) {
        BlockPos var6 = var4.below();
        GiantTrunkPlacer.setDirtAt(var0, var1, var2, var6, var5);
        GiantTrunkPlacer.setDirtAt(var0, var1, var2, var6.east(), var5);
        GiantTrunkPlacer.setDirtAt(var0, var1, var2, var6.south(), var5);
        GiantTrunkPlacer.setDirtAt(var0, var1, var2, var6.south().east(), var5);
        BlockPos.MutableBlockPos var7 = new BlockPos.MutableBlockPos();
        for (int var8 = 0; var8 < var3; ++var8) {
            this.placeLogIfFreeWithOffset(var0, var1, var2, var7, var5, var4, 0, var8, 0);
            if (var8 >= var3 - 1) continue;
            this.placeLogIfFreeWithOffset(var0, var1, var2, var7, var5, var4, 1, var8, 0);
            this.placeLogIfFreeWithOffset(var0, var1, var2, var7, var5, var4, 1, var8, 1);
            this.placeLogIfFreeWithOffset(var0, var1, var2, var7, var5, var4, 0, var8, 1);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(var4.above(var3), 0, true));
    }

    private void placeLogIfFreeWithOffset(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, BlockPos.MutableBlockPos var3, TreeConfiguration var4, BlockPos var5, int var6, int var7, int var8) {
        var3.setWithOffset(var5, var6, var7, var8);
        this.placeLogIfFree(var0, var1, var2, var3, var4);
    }
}

