/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class VeryBiasedToBottomHeight
extends HeightProvider {
    public static final MapCodec<VeryBiasedToBottomHeight> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)VerticalAnchor.CODEC.fieldOf("min_inclusive").forGetter(var0 -> var0.minInclusive), (App)VerticalAnchor.CODEC.fieldOf("max_inclusive").forGetter(var0 -> var0.maxInclusive), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("inner", (Object)1).forGetter(var0 -> var0.inner)).apply((Applicative)var02, VeryBiasedToBottomHeight::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;
    private final int inner;

    private VeryBiasedToBottomHeight(VerticalAnchor var0, VerticalAnchor var1, int var2) {
        this.minInclusive = var0;
        this.maxInclusive = var1;
        this.inner = var2;
    }

    public static VeryBiasedToBottomHeight of(VerticalAnchor var0, VerticalAnchor var1, int var2) {
        return new VeryBiasedToBottomHeight(var0, var1, var2);
    }

    @Override
    public int sample(RandomSource var0, WorldGenerationContext var1) {
        int var2 = this.minInclusive.resolveY(var1);
        int var3 = this.maxInclusive.resolveY(var1);
        if (var3 - var2 - this.inner + 1 <= 0) {
            LOGGER.warn("Empty height range: {}", (Object)this);
            return var2;
        }
        int var4 = Mth.nextInt(var0, var2 + this.inner, var3);
        int var5 = Mth.nextInt(var0, var2, var4 - 1);
        return Mth.nextInt(var0, var2, var5 - 1 + this.inner);
    }

    @Override
    public HeightProviderType<?> getType() {
        return HeightProviderType.VERY_BIASED_TO_BOTTOM;
    }

    public String toString() {
        return "biased[" + String.valueOf(this.minInclusive) + "-" + String.valueOf(this.maxInclusive) + " inner: " + this.inner + "]";
    }
}

