/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class PoolElementStructurePiece
extends StructurePiece {
    protected final StructurePoolElement element;
    protected BlockPos position;
    private final int groundLevelDelta;
    protected final Rotation rotation;
    private final List<JigsawJunction> junctions = Lists.newArrayList();
    private final StructureTemplateManager structureTemplateManager;
    private final LiquidSettings liquidSettings;

    public PoolElementStructurePiece(StructureTemplateManager var0, StructurePoolElement var1, BlockPos var2, int var3, Rotation var4, BoundingBox var5, LiquidSettings var6) {
        super(StructurePieceType.JIGSAW, 0, var5);
        this.structureTemplateManager = var0;
        this.element = var1;
        this.position = var2;
        this.groundLevelDelta = var3;
        this.rotation = var4;
        this.liquidSettings = var6;
    }

    public PoolElementStructurePiece(StructurePieceSerializationContext var0, CompoundTag var12) {
        super(StructurePieceType.JIGSAW, var12);
        this.structureTemplateManager = var0.structureTemplateManager();
        this.position = new BlockPos(var12.getIntOr("PosX", 0), var12.getIntOr("PosY", 0), var12.getIntOr("PosZ", 0));
        this.groundLevelDelta = var12.getIntOr("ground_level_delta", 0);
        RegistryOps<Tag> var2 = var0.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        this.element = var12.read("pool_element", StructurePoolElement.CODEC, var2).orElseThrow(() -> new IllegalStateException("Invalid pool element found"));
        this.rotation = var12.read("rotation", Rotation.LEGACY_CODEC).orElseThrow();
        this.boundingBox = this.element.getBoundingBox(this.structureTemplateManager, this.position, this.rotation);
        ListTag var3 = var12.getListOrEmpty("junctions");
        this.junctions.clear();
        var3.forEach(var1 -> this.junctions.add(JigsawJunction.deserialize(new Dynamic(var2, var1))));
        this.liquidSettings = var12.read("liquid_settings", LiquidSettings.CODEC).orElse(JigsawStructure.DEFAULT_LIQUID_SETTINGS);
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, CompoundTag var1) {
        var1.putInt("PosX", this.position.getX());
        var1.putInt("PosY", this.position.getY());
        var1.putInt("PosZ", this.position.getZ());
        var1.putInt("ground_level_delta", this.groundLevelDelta);
        RegistryOps<Tag> var2 = var0.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        var1.store("pool_element", StructurePoolElement.CODEC, var2, this.element);
        var1.store("rotation", Rotation.LEGACY_CODEC, this.rotation);
        ListTag var3 = new ListTag();
        for (JigsawJunction var5 : this.junctions) {
            var3.add((Tag)var5.serialize(var2).getValue());
        }
        var1.put("junctions", var3);
        if (this.liquidSettings != JigsawStructure.DEFAULT_LIQUID_SETTINGS) {
            var1.store("liquid_settings", LiquidSettings.CODEC, var2, this.liquidSettings);
        }
    }

    @Override
    public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
        this.place(var0, var1, var2, var3, var4, var6, false);
    }

    public void place(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, BlockPos var5, boolean var6) {
        this.element.place(this.structureTemplateManager, var0, var1, var2, this.position, var5, this.rotation, var4, var3, this.liquidSettings, var6);
    }

    @Override
    public void move(int var0, int var1, int var2) {
        super.move(var0, var1, var2);
        this.position = this.position.offset(var0, var1, var2);
    }

    @Override
    public Rotation getRotation() {
        return this.rotation;
    }

    public String toString() {
        return String.format(Locale.ROOT, "<%s | %s | %s | %s>", this.getClass().getSimpleName(), this.position, this.rotation, this.element);
    }

    public StructurePoolElement getElement() {
        return this.element;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public int getGroundLevelDelta() {
        return this.groundLevelDelta;
    }

    public void addJunction(JigsawJunction var0) {
        this.junctions.add(var0);
    }

    public List<JigsawJunction> getJunctions() {
        return this.junctions;
    }
}

