/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public abstract class ScatteredFeaturePiece
extends StructurePiece {
    protected final int width;
    protected final int height;
    protected final int depth;
    protected int heightPosition = -1;

    protected ScatteredFeaturePiece(StructurePieceType var0, int var1, int var2, int var3, int var4, int var5, int var6, Direction var7) {
        super(var0, 0, StructurePiece.makeBoundingBox(var1, var2, var3, var7, var4, var5, var6));
        this.width = var4;
        this.height = var5;
        this.depth = var6;
        this.setOrientation(var7);
    }

    protected ScatteredFeaturePiece(StructurePieceType var0, CompoundTag var1) {
        super(var0, var1);
        this.width = var1.getIntOr("Width", 0);
        this.height = var1.getIntOr("Height", 0);
        this.depth = var1.getIntOr("Depth", 0);
        this.heightPosition = var1.getIntOr("HPos", 0);
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, CompoundTag var1) {
        var1.putInt("Width", this.width);
        var1.putInt("Height", this.height);
        var1.putInt("Depth", this.depth);
        var1.putInt("HPos", this.heightPosition);
    }

    protected boolean updateAverageGroundHeight(LevelAccessor var0, BoundingBox var1, int var2) {
        if (this.heightPosition >= 0) {
            return true;
        }
        int var3 = 0;
        int var4 = 0;
        BlockPos.MutableBlockPos var5 = new BlockPos.MutableBlockPos();
        for (int var6 = this.boundingBox.minZ(); var6 <= this.boundingBox.maxZ(); ++var6) {
            for (int var7 = this.boundingBox.minX(); var7 <= this.boundingBox.maxX(); ++var7) {
                var5.set(var7, 64, var6);
                if (!var1.isInside(var5)) continue;
                var3 += var0.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, var5).getY();
                ++var4;
            }
        }
        if (var4 == 0) {
            return false;
        }
        this.heightPosition = var3 / var4;
        this.boundingBox.move(0, this.heightPosition - this.boundingBox.minY() + var2, 0);
        return true;
    }

    protected boolean updateHeightPositionToLowestGroundHeight(LevelAccessor var0, int var1) {
        if (this.heightPosition >= 0) {
            return true;
        }
        int var2 = var0.getMaxY() + 1;
        boolean var3 = false;
        BlockPos.MutableBlockPos var4 = new BlockPos.MutableBlockPos();
        for (int var5 = this.boundingBox.minZ(); var5 <= this.boundingBox.maxZ(); ++var5) {
            for (int var6 = this.boundingBox.minX(); var6 <= this.boundingBox.maxX(); ++var6) {
                var4.set(var6, 0, var5);
                var2 = Math.min(var2, var0.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, var4).getY());
                var3 = true;
            }
        }
        if (!var3) {
            return false;
        }
        this.heightPosition = var2;
        this.boundingBox.move(0, this.heightPosition - this.boundingBox.minY() + var1, 0);
        return true;
    }
}

