/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionPieces;

public class WoodlandMansionStructure
extends Structure {
    public static final MapCodec<WoodlandMansionStructure> CODEC = WoodlandMansionStructure.simpleCodec(WoodlandMansionStructure::new);

    public WoodlandMansionStructure(Structure.StructureSettings var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        Rotation var1 = Rotation.getRandom(var0.random());
        BlockPos var2 = this.getLowestYIn5by5BoxOffset7Blocks(var0, var1);
        if (var2.getY() < 60) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(var2, var3 -> this.generatePieces((StructurePiecesBuilder)var3, var0, var2, var1)));
    }

    private void generatePieces(StructurePiecesBuilder var0, Structure.GenerationContext var1, BlockPos var2, Rotation var3) {
        LinkedList var4 = Lists.newLinkedList();
        WoodlandMansionPieces.generateMansion(var1.structureTemplateManager(), var2, var3, var4, var1.random());
        var4.forEach(var0::addPiece);
    }

    @Override
    public void afterPlace(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, PiecesContainer var6) {
        BlockPos.MutableBlockPos var7 = new BlockPos.MutableBlockPos();
        int var8 = var0.getMinY();
        BoundingBox var9 = var6.calculateBoundingBox();
        int var10 = var9.minY();
        for (int var11 = var4.minX(); var11 <= var4.maxX(); ++var11) {
            block1: for (int var12 = var4.minZ(); var12 <= var4.maxZ(); ++var12) {
                var7.set(var11, var10, var12);
                if (var0.isEmptyBlock(var7) || !var9.isInside(var7) || !var6.isInsidePiece(var7)) continue;
                for (int var13 = var10 - 1; var13 > var8; --var13) {
                    var7.setY(var13);
                    if (!var0.isEmptyBlock(var7) && !var0.getBlockState(var7).liquid()) continue block1;
                    var0.setBlock(var7, Blocks.COBBLESTONE.defaultBlockState(), 2);
                }
            }
        }
    }

    @Override
    public StructureType<?> type() {
        return StructureType.WOODLAND_MANSION;
    }
}

