/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;

public class FlyNodeEvaluator
extends WalkNodeEvaluator {
    private final Long2ObjectMap<PathType> pathTypeByPosCache = new Long2ObjectOpenHashMap();
    private static final float SMALL_MOB_SIZE = 1.0f;
    private static final float SMALL_MOB_INFLATED_START_NODE_BOUNDING_BOX = 1.1f;
    private static final int MAX_START_NODE_CANDIDATES = 10;

    @Override
    public void prepare(PathNavigationRegion var0, Mob var1) {
        super.prepare(var0, var1);
        this.pathTypeByPosCache.clear();
        var1.onPathfindingStart();
    }

    @Override
    public void done() {
        this.mob.onPathfindingDone();
        this.pathTypeByPosCache.clear();
        super.done();
    }

    @Override
    public Node getStart() {
        BlockPos var1;
        int var0;
        if (this.canFloat() && this.mob.isInWater()) {
            var0 = this.mob.getBlockY();
            var1 = new BlockPos.MutableBlockPos(this.mob.getX(), (double)var0, this.mob.getZ());
            BlockState var2 = this.currentContext.getBlockState(var1);
            while (var2.is(Blocks.WATER)) {
                ((BlockPos.MutableBlockPos)var1).set(this.mob.getX(), ++var0, this.mob.getZ());
                var2 = this.currentContext.getBlockState(var1);
            }
        } else {
            var0 = Mth.floor(this.mob.getY() + 0.5);
        }
        if (!this.canStartAt(var1 = BlockPos.containing(this.mob.getX(), var0, this.mob.getZ()))) {
            for (BlockPos var3 : this.iteratePathfindingStartNodeCandidatePositions(this.mob)) {
                if (!this.canStartAt(var3)) continue;
                return super.getStartNode(var3);
            }
        }
        return super.getStartNode(var1);
    }

    @Override
    protected boolean canStartAt(BlockPos var0) {
        PathType var1 = this.getCachedPathType(var0.getX(), var0.getY(), var0.getZ());
        return this.mob.getPathfindingMalus(var1) >= 0.0f;
    }

    @Override
    public Target getTarget(double var0, double var2, double var4) {
        return this.getTargetNodeAt(var0, var2, var4);
    }

    @Override
    public int getNeighbors(Node[] var0, Node var1) {
        Node var28;
        Node var27;
        Node var26;
        Node var25;
        Node var24;
        Node var23;
        Node var22;
        Node var21;
        Node var20;
        Node var19;
        Node var18;
        Node var17;
        Node var16;
        Node var15;
        Node var14;
        Node var13;
        Node var12;
        Node var11;
        Node var10;
        Node var9;
        Node var8;
        Node var7;
        Node var6;
        Node var5;
        Node var4;
        int var2 = 0;
        Node var3 = this.findAcceptedNode(var1.x, var1.y, var1.z + 1);
        if (this.isOpen(var3)) {
            var0[var2++] = var3;
        }
        if (this.isOpen(var4 = this.findAcceptedNode(var1.x - 1, var1.y, var1.z))) {
            var0[var2++] = var4;
        }
        if (this.isOpen(var5 = this.findAcceptedNode(var1.x + 1, var1.y, var1.z))) {
            var0[var2++] = var5;
        }
        if (this.isOpen(var6 = this.findAcceptedNode(var1.x, var1.y, var1.z - 1))) {
            var0[var2++] = var6;
        }
        if (this.isOpen(var7 = this.findAcceptedNode(var1.x, var1.y + 1, var1.z))) {
            var0[var2++] = var7;
        }
        if (this.isOpen(var8 = this.findAcceptedNode(var1.x, var1.y - 1, var1.z))) {
            var0[var2++] = var8;
        }
        if (this.isOpen(var9 = this.findAcceptedNode(var1.x, var1.y + 1, var1.z + 1)) && this.hasMalus(var3) && this.hasMalus(var7)) {
            var0[var2++] = var9;
        }
        if (this.isOpen(var10 = this.findAcceptedNode(var1.x - 1, var1.y + 1, var1.z)) && this.hasMalus(var4) && this.hasMalus(var7)) {
            var0[var2++] = var10;
        }
        if (this.isOpen(var11 = this.findAcceptedNode(var1.x + 1, var1.y + 1, var1.z)) && this.hasMalus(var5) && this.hasMalus(var7)) {
            var0[var2++] = var11;
        }
        if (this.isOpen(var12 = this.findAcceptedNode(var1.x, var1.y + 1, var1.z - 1)) && this.hasMalus(var6) && this.hasMalus(var7)) {
            var0[var2++] = var12;
        }
        if (this.isOpen(var13 = this.findAcceptedNode(var1.x, var1.y - 1, var1.z + 1)) && this.hasMalus(var3) && this.hasMalus(var8)) {
            var0[var2++] = var13;
        }
        if (this.isOpen(var14 = this.findAcceptedNode(var1.x - 1, var1.y - 1, var1.z)) && this.hasMalus(var4) && this.hasMalus(var8)) {
            var0[var2++] = var14;
        }
        if (this.isOpen(var15 = this.findAcceptedNode(var1.x + 1, var1.y - 1, var1.z)) && this.hasMalus(var5) && this.hasMalus(var8)) {
            var0[var2++] = var15;
        }
        if (this.isOpen(var16 = this.findAcceptedNode(var1.x, var1.y - 1, var1.z - 1)) && this.hasMalus(var6) && this.hasMalus(var8)) {
            var0[var2++] = var16;
        }
        if (this.isOpen(var17 = this.findAcceptedNode(var1.x + 1, var1.y, var1.z - 1)) && this.hasMalus(var6) && this.hasMalus(var5)) {
            var0[var2++] = var17;
        }
        if (this.isOpen(var18 = this.findAcceptedNode(var1.x + 1, var1.y, var1.z + 1)) && this.hasMalus(var3) && this.hasMalus(var5)) {
            var0[var2++] = var18;
        }
        if (this.isOpen(var19 = this.findAcceptedNode(var1.x - 1, var1.y, var1.z - 1)) && this.hasMalus(var6) && this.hasMalus(var4)) {
            var0[var2++] = var19;
        }
        if (this.isOpen(var20 = this.findAcceptedNode(var1.x - 1, var1.y, var1.z + 1)) && this.hasMalus(var3) && this.hasMalus(var4)) {
            var0[var2++] = var20;
        }
        if (this.isOpen(var21 = this.findAcceptedNode(var1.x + 1, var1.y + 1, var1.z - 1)) && this.hasMalus(var17) && this.hasMalus(var6) && this.hasMalus(var5) && this.hasMalus(var7) && this.hasMalus(var12) && this.hasMalus(var11)) {
            var0[var2++] = var21;
        }
        if (this.isOpen(var22 = this.findAcceptedNode(var1.x + 1, var1.y + 1, var1.z + 1)) && this.hasMalus(var18) && this.hasMalus(var3) && this.hasMalus(var5) && this.hasMalus(var7) && this.hasMalus(var9) && this.hasMalus(var11)) {
            var0[var2++] = var22;
        }
        if (this.isOpen(var23 = this.findAcceptedNode(var1.x - 1, var1.y + 1, var1.z - 1)) && this.hasMalus(var19) && this.hasMalus(var6) && this.hasMalus(var4) && this.hasMalus(var7) && this.hasMalus(var12) && this.hasMalus(var10)) {
            var0[var2++] = var23;
        }
        if (this.isOpen(var24 = this.findAcceptedNode(var1.x - 1, var1.y + 1, var1.z + 1)) && this.hasMalus(var20) && this.hasMalus(var3) && this.hasMalus(var4) && this.hasMalus(var7) && this.hasMalus(var9) && this.hasMalus(var10)) {
            var0[var2++] = var24;
        }
        if (this.isOpen(var25 = this.findAcceptedNode(var1.x + 1, var1.y - 1, var1.z - 1)) && this.hasMalus(var17) && this.hasMalus(var6) && this.hasMalus(var5) && this.hasMalus(var8) && this.hasMalus(var16) && this.hasMalus(var15)) {
            var0[var2++] = var25;
        }
        if (this.isOpen(var26 = this.findAcceptedNode(var1.x + 1, var1.y - 1, var1.z + 1)) && this.hasMalus(var18) && this.hasMalus(var3) && this.hasMalus(var5) && this.hasMalus(var8) && this.hasMalus(var13) && this.hasMalus(var15)) {
            var0[var2++] = var26;
        }
        if (this.isOpen(var27 = this.findAcceptedNode(var1.x - 1, var1.y - 1, var1.z - 1)) && this.hasMalus(var19) && this.hasMalus(var6) && this.hasMalus(var4) && this.hasMalus(var8) && this.hasMalus(var16) && this.hasMalus(var14)) {
            var0[var2++] = var27;
        }
        if (this.isOpen(var28 = this.findAcceptedNode(var1.x - 1, var1.y - 1, var1.z + 1)) && this.hasMalus(var20) && this.hasMalus(var3) && this.hasMalus(var4) && this.hasMalus(var8) && this.hasMalus(var13) && this.hasMalus(var14)) {
            var0[var2++] = var28;
        }
        return var2;
    }

    private boolean hasMalus(@Nullable Node var0) {
        return var0 != null && var0.costMalus >= 0.0f;
    }

    private boolean isOpen(@Nullable Node var0) {
        return var0 != null && !var0.closed;
    }

    @Nullable
    protected Node findAcceptedNode(int var0, int var1, int var2) {
        Node var3 = null;
        PathType var4 = this.getCachedPathType(var0, var1, var2);
        float var5 = this.mob.getPathfindingMalus(var4);
        if (var5 >= 0.0f) {
            var3 = this.getNode(var0, var1, var2);
            var3.type = var4;
            var3.costMalus = Math.max(var3.costMalus, var5);
            if (var4 == PathType.WALKABLE) {
                var3.costMalus += 1.0f;
            }
        }
        return var3;
    }

    @Override
    protected PathType getCachedPathType(int var0, int var1, int var2) {
        return (PathType)((Object)this.pathTypeByPosCache.computeIfAbsent(BlockPos.asLong(var0, var1, var2), var3 -> this.getPathTypeOfMob(this.currentContext, var0, var1, var2, this.mob)));
    }

    @Override
    public PathType getPathType(PathfindingContext var0, int var1, int var2, int var3) {
        PathType var4 = var0.getPathTypeFromState(var1, var2, var3);
        if (var4 == PathType.OPEN && var2 >= var0.level().getMinY() + 1) {
            BlockPos var5 = new BlockPos(var1, var2 - 1, var3);
            PathType var6 = var0.getPathTypeFromState(var5.getX(), var5.getY(), var5.getZ());
            if (var6 == PathType.DAMAGE_FIRE || var6 == PathType.LAVA) {
                var4 = PathType.DAMAGE_FIRE;
            } else if (var6 == PathType.DAMAGE_OTHER) {
                var4 = PathType.DAMAGE_OTHER;
            } else if (var6 == PathType.COCOA) {
                var4 = PathType.COCOA;
            } else if (var6 == PathType.FENCE) {
                if (!var5.equals(var0.mobPosition())) {
                    var4 = PathType.FENCE;
                }
            } else {
                PathType pathType = var4 = var6 == PathType.WALKABLE || var6 == PathType.OPEN || var6 == PathType.WATER ? PathType.OPEN : PathType.WALKABLE;
            }
        }
        if (var4 == PathType.WALKABLE || var4 == PathType.OPEN) {
            var4 = FlyNodeEvaluator.checkNeighbourBlocks(var0, var1, var2, var3, var4);
        }
        return var4;
    }

    private Iterable<BlockPos> iteratePathfindingStartNodeCandidatePositions(Mob var0) {
        boolean var2;
        AABB var1 = var0.getBoundingBox();
        boolean bl = var2 = var1.getSize() < 1.0;
        if (!var2) {
            return List.of(BlockPos.containing(var1.minX, var0.getBlockY(), var1.minZ), BlockPos.containing(var1.minX, var0.getBlockY(), var1.maxZ), BlockPos.containing(var1.maxX, var0.getBlockY(), var1.minZ), BlockPos.containing(var1.maxX, var0.getBlockY(), var1.maxZ));
        }
        double var3 = Math.max(0.0, (double)1.1f - var1.getZsize());
        double var5 = Math.max(0.0, (double)1.1f - var1.getXsize());
        double var7 = Math.max(0.0, (double)1.1f - var1.getYsize());
        AABB var9 = var1.inflate(var5, var7, var3);
        return BlockPos.randomBetweenClosed(var0.getRandom(), 10, Mth.floor(var9.minX), Mth.floor(var9.minY), Mth.floor(var9.minZ), Mth.floor(var9.maxX), Mth.floor(var9.maxY), Mth.floor(var9.maxZ));
    }
}

