/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalForcer {
    public static final int TICKET_RADIUS = 3;
    private static final int NETHER_PORTAL_RADIUS = 16;
    private static final int OVERWORLD_PORTAL_RADIUS = 128;
    private static final int FRAME_HEIGHT = 5;
    private static final int FRAME_WIDTH = 4;
    private static final int FRAME_BOX = 3;
    private static final int FRAME_HEIGHT_START = -1;
    private static final int FRAME_HEIGHT_END = 4;
    private static final int FRAME_WIDTH_START = -1;
    private static final int FRAME_WIDTH_END = 3;
    private static final int FRAME_BOX_START = -1;
    private static final int FRAME_BOX_END = 2;
    private static final int NOTHING_FOUND = -1;
    private final ServerLevel level;

    public PortalForcer(ServerLevel worldserver) {
        this.level = worldserver;
    }

    public Optional<BlockPos> findClosestPortalPosition(BlockPos blockposition, boolean flag, WorldBorder worldborder) {
        return this.findClosestPortalPosition(blockposition, worldborder, flag ? 16 : 128);
    }

    public Optional<BlockPos> findClosestPortalPosition(BlockPos blockposition, WorldBorder worldborder, int i) {
        PoiManager villageplace = this.level.getPoiManager();
        villageplace.ensureLoadedAndValid(this.level, blockposition, i);
        Stream<BlockPos> stream = villageplace.getInSquare(holder -> holder.is(PoiTypes.NETHER_PORTAL), blockposition, i, PoiManager.Occupancy.ANY).map(PoiRecord::getPos);
        Objects.requireNonNull(worldborder);
        return stream.filter(worldborder::isWithinBounds).filter(blockposition1 -> this.level.getBlockState((BlockPos)blockposition1).hasProperty(BlockStateProperties.HORIZONTAL_AXIS)).min(Comparator.comparingDouble(blockposition1 -> blockposition1.distSqr(blockposition)).thenComparingInt(Vec3i::getY));
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos blockposition, Direction.Axis enumdirection_enumaxis) {
        return this.createPortal(blockposition, enumdirection_enumaxis, null, 16);
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos blockposition, Direction.Axis enumdirection_enumaxis, net.minecraft.world.entity.Entity entity, int createRadius) {
        Direction enumdirection = Direction.get(Direction.AxisDirection.POSITIVE, enumdirection_enumaxis);
        double d0 = -1.0;
        BlockPos blockposition1 = null;
        double d1 = -1.0;
        BlockPos blockposition2 = null;
        WorldBorder worldborder = this.level.getWorldBorder();
        int i = Math.min(this.level.getMaxY(), this.level.getMinY() + this.level.getLogicalHeight() - 1);
        boolean j = true;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (BlockPos.MutableBlockPos blockposition_mutableblockposition1 : BlockPos.spiralAround(blockposition, createRadius, Direction.EAST, Direction.SOUTH)) {
            int k = Math.min(i, this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, blockposition_mutableblockposition1.getX(), blockposition_mutableblockposition1.getZ()));
            if (!worldborder.isWithinBounds(blockposition_mutableblockposition1) || !worldborder.isWithinBounds(blockposition_mutableblockposition1.move(enumdirection, 1))) continue;
            blockposition_mutableblockposition1.move(enumdirection.getOpposite(), 1);
            for (int l = k; l >= this.level.getMinY(); --l) {
                int j1;
                blockposition_mutableblockposition1.setY(l);
                if (!this.canPortalReplaceBlock(blockposition_mutableblockposition1)) continue;
                int i1 = l;
                while (l > this.level.getMinY() && this.canPortalReplaceBlock(blockposition_mutableblockposition1.move(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockposition_mutableblockposition1.setY(l);
                if (!this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 0)) continue;
                double d2 = blockposition.distSqr(blockposition_mutableblockposition1);
                if (this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, -1) && this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockposition1 = blockposition_mutableblockposition1.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockposition2 = blockposition_mutableblockposition1.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockposition1 = blockposition2;
            d0 = d1;
        }
        BlockStateListPopulator blockList = new BlockStateListPopulator(this.level);
        if (d0 == -1.0) {
            int l1 = i - 9;
            int k1 = Math.max(this.level.getMinY() - -1, 70);
            if (l1 < k1) {
                return Optional.empty();
            }
            blockposition1 = new BlockPos(blockposition.getX() - enumdirection.getStepX() * 1, Mth.clamp(blockposition.getY(), k1, l1), blockposition.getZ() - enumdirection.getStepZ() * 1).immutable();
            blockposition1 = worldborder.clampToBounds(blockposition1);
            Direction enumdirection1 = enumdirection.getClockWise();
            for (int i2 = -1; i2 < 2; ++i2) {
                for (int j2 = 0; j2 < 2; ++j2) {
                    for (int k2 = -1; k2 < 3; ++k2) {
                        BlockState iblockdata = k2 < 0 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.AIR.defaultBlockState();
                        blockposition_mutableblockposition.setWithOffset(blockposition1, j2 * enumdirection.getStepX() + i2 * enumdirection1.getStepX(), k2, j2 * enumdirection.getStepZ() + i2 * enumdirection1.getStepZ());
                        blockList.setBlock(blockposition_mutableblockposition, iblockdata, 3);
                    }
                }
            }
        }
        for (int l2 = -1; l2 < 3; ++l2) {
            for (int i3 = -1; i3 < 4; ++i3) {
                if (l2 != -1 && l2 != 2 && i3 != -1 && i3 != 3) continue;
                blockposition_mutableblockposition.setWithOffset(blockposition1, l2 * enumdirection.getStepX(), i3, l2 * enumdirection.getStepZ());
                blockList.setBlock(blockposition_mutableblockposition, Blocks.OBSIDIAN.defaultBlockState(), 3);
            }
        }
        BlockState iblockdata1 = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue(NetherPortalBlock.AXIS, enumdirection_enumaxis);
        for (int j3 = 0; j3 < 2; ++j3) {
            for (int k3 = 0; k3 < 3; ++k3) {
                blockposition_mutableblockposition.setWithOffset(blockposition1, j3 * enumdirection.getStepX(), k3, j3 * enumdirection.getStepZ());
                blockList.setBlock(blockposition_mutableblockposition, iblockdata1, 18);
            }
        }
        CraftWorld bworld = this.level.getWorld();
        PortalCreateEvent event = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.NETHER_PAIR);
        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        blockList.updateList();
        return Optional.of(new BlockUtil.FoundRectangle(blockposition1.immutable(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos blockposition_mutableblockposition) {
        BlockState iblockdata = this.level.getBlockState(blockposition_mutableblockposition);
        return iblockdata.canBeReplaced() && iblockdata.getFluidState().isEmpty();
    }

    private boolean canHostFrame(BlockPos blockposition, BlockPos.MutableBlockPos blockposition_mutableblockposition, Direction enumdirection, int i) {
        Direction enumdirection1 = enumdirection.getClockWise();
        for (int j = -1; j < 3; ++j) {
            for (int k = -1; k < 4; ++k) {
                blockposition_mutableblockposition.setWithOffset(blockposition, enumdirection.getStepX() * j + enumdirection1.getStepX() * i, k, enumdirection.getStepZ() * j + enumdirection1.getStepZ() * i);
                if (k < 0 && !this.level.getBlockState(blockposition_mutableblockposition).isSolid()) {
                    return false;
                }
                if (k < 0 || this.canPortalReplaceBlock(blockposition_mutableblockposition)) continue;
                return false;
            }
        }
        return true;
    }
}

