/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<ResourceKey<LootTable>> KEY_CODEC = ResourceKey.codec(Registries.LOOT_TABLE);
    public static final ContextKeySet DEFAULT_PARAM_SET = LootContextParamSets.ALL_PARAMS;
    public static final long RANDOMIZE_SEED = 0L;
    public static final Codec<LootTable> DIRECT_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)LootContextParamSets.CODEC.lenientOptionalFieldOf("type", (Object)DEFAULT_PARAM_SET).forGetter(loottable -> loottable.paramSet), (App)ResourceLocation.CODEC.optionalFieldOf("random_sequence").forGetter(loottable -> loottable.randomSequence), (App)LootPool.CODEC.listOf().optionalFieldOf("pools", List.of()).forGetter(loottable -> loottable.pools), (App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(loottable -> loottable.functions)).apply((Applicative)instance, LootTable::new)));
    public static final Codec<Holder<LootTable>> CODEC = RegistryFileCodec.create(Registries.LOOT_TABLE, DIRECT_CODEC);
    public static final LootTable EMPTY = new LootTable(LootContextParamSets.EMPTY, Optional.empty(), List.of(), List.of());
    private final ContextKeySet paramSet;
    private final Optional<ResourceLocation> randomSequence;
    private final List<LootPool> pools;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;
    public CraftLootTable craftLootTable;

    LootTable(ContextKeySet contextkeyset, Optional<ResourceLocation> optional, List<LootPool> list, List<LootItemFunction> list1) {
        this.paramSet = contextkeyset;
        this.randomSequence = optional;
        this.pools = list;
        this.functions = list1;
        this.compositeFunction = LootItemFunctions.compose(list1);
    }

    public static Consumer<ItemStack> createStackSplitter(ServerLevel worldserver, Consumer<ItemStack> consumer) {
        return itemstack -> {
            if (itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                if (itemstack.getCount() < itemstack.getMaxStackSize()) {
                    consumer.accept((ItemStack)itemstack);
                } else {
                    ItemStack itemstack1;
                    for (int i = itemstack.getCount(); i > 0; i -= itemstack1.getCount()) {
                        itemstack1 = itemstack.copyWithCount(Math.min(itemstack.getMaxStackSize(), i));
                        consumer.accept(itemstack1);
                    }
                }
            }
        };
    }

    public void getRandomItemsRaw(LootParams lootparams, Consumer<ItemStack> consumer) {
        this.getRandomItemsRaw(new LootContext.Builder(lootparams).create(this.randomSequence), consumer);
    }

    public void getRandomItemsRaw(LootContext loottableinfo, Consumer<ItemStack> consumer) {
        LootContext.VisitedEntry<LootTable> loottableinfo_e = LootContext.createVisitedEntry(this);
        if (loottableinfo.pushVisitedElement(loottableinfo_e)) {
            Consumer<ItemStack> consumer1 = LootItemFunction.decorate(this.compositeFunction, consumer, loottableinfo);
            for (LootPool lootselector : this.pools) {
                lootselector.addRandomItems(consumer1, loottableinfo);
            }
            loottableinfo.popVisitedElement(loottableinfo_e);
        } else {
            LOGGER.warn("Detected infinite loop in loot tables");
        }
    }

    public void getRandomItems(LootParams lootparams, long i, Consumer<ItemStack> consumer) {
        this.getRandomItemsRaw(new LootContext.Builder(lootparams).withOptionalRandomSeed(i).create(this.randomSequence), LootTable.createStackSplitter(lootparams.getLevel(), consumer));
    }

    public void getRandomItems(LootParams lootparams, Consumer<ItemStack> consumer) {
        this.getRandomItemsRaw(lootparams, LootTable.createStackSplitter(lootparams.getLevel(), consumer));
    }

    public void getRandomItems(LootContext loottableinfo, Consumer<ItemStack> consumer) {
        this.getRandomItemsRaw(loottableinfo, LootTable.createStackSplitter(loottableinfo.getLevel(), consumer));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams lootparams, RandomSource randomsource) {
        return this.getRandomItems(new LootContext.Builder(lootparams).withOptionalRandomSource(randomsource).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams lootparams, long i) {
        return this.getRandomItems(new LootContext.Builder(lootparams).withOptionalRandomSeed(i).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams lootparams) {
        return this.getRandomItems(new LootContext.Builder(lootparams).create(this.randomSequence));
    }

    private ObjectArrayList<ItemStack> getRandomItems(LootContext loottableinfo) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        Objects.requireNonNull(objectarraylist);
        this.getRandomItems(loottableinfo, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        return objectarraylist;
    }

    public ContextKeySet getParamSet() {
        return this.paramSet;
    }

    public void validate(ValidationContext lootcollector) {
        for (int i = 0; i < this.pools.size(); ++i) {
            this.pools.get(i).validate(lootcollector.forChild(new ProblemReporter.IndexedFieldPathElement("pools", i)));
        }
        for (int j = 0; j < this.functions.size(); ++j) {
            this.functions.get(j).validate(lootcollector.forChild(new ProblemReporter.IndexedFieldPathElement("functions", j)));
        }
    }

    public void fill(Container iinventory, LootParams lootparams, long i) {
        this.fillInventory(iinventory, lootparams, i, false);
    }

    public void fillInventory(Container iinventory, LootParams lootparams, long i, boolean plugin) {
        LootContext loottableinfo = new LootContext.Builder(lootparams).withOptionalRandomSeed(i).create(this.randomSequence);
        ObjectArrayList objectarraylist = this.getRandomItems(loottableinfo);
        RandomSource randomsource = loottableinfo.getRandom();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(iinventory, this, loottableinfo, objectarraylist, plugin);
        if (event.isCancelled()) {
            return;
        }
        objectarraylist = (ObjectArrayList)event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(ObjectArrayList.toList());
        List<Integer> list = this.getAvailableSlots(iinventory, randomsource);
        this.shuffleAndSplitItems((ObjectArrayList<ItemStack>)objectarraylist, list.size(), randomsource);
        for (ItemStack itemstack : objectarraylist) {
            if (list.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.isEmpty()) {
                iinventory.setItem(list.remove(list.size() - 1), ItemStack.EMPTY);
                continue;
            }
            iinventory.setItem(list.remove(list.size() - 1), itemstack);
        }
    }

    private void shuffleAndSplitItems(ObjectArrayList<ItemStack> objectarraylist, int i, RandomSource randomsource) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator iterator = objectarraylist.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            if (itemstack.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (itemstack.getCount() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (i - objectarraylist.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack1 = (ItemStack)list.remove(Mth.nextInt(randomsource, 0, list.size() - 1));
            int j = Mth.nextInt(randomsource, 1, itemstack1.getCount() / 2);
            ItemStack itemstack2 = itemstack1.split(j);
            if (itemstack1.getCount() > 1 && randomsource.nextBoolean()) {
                list.add(itemstack1);
            } else {
                objectarraylist.add((Object)itemstack1);
            }
            if (itemstack2.getCount() > 1 && randomsource.nextBoolean()) {
                list.add(itemstack2);
                continue;
            }
            objectarraylist.add((Object)itemstack2);
        }
        objectarraylist.addAll((Collection)list);
        Util.shuffle(objectarraylist, randomsource);
    }

    private List<Integer> getAvailableSlots(Container iinventory, RandomSource randomsource) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        for (int i = 0; i < iinventory.getContainerSize(); ++i) {
            if (!iinventory.getItem(i).isEmpty()) continue;
            objectarraylist.add((Object)i);
        }
        Util.shuffle(objectarraylist, randomsource);
        return objectarraylist;
    }

    public static Builder lootTable() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPool> pools = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();
        private ContextKeySet paramSet = DEFAULT_PARAM_SET;
        private Optional<ResourceLocation> randomSequence = Optional.empty();

        public Builder withPool(LootPool.Builder lootselector_a) {
            this.pools.add((Object)lootselector_a.build());
            return this;
        }

        public Builder setParamSet(ContextKeySet contextkeyset) {
            this.paramSet = contextkeyset;
            return this;
        }

        public Builder setRandomSequence(ResourceLocation minecraftkey) {
            this.randomSequence = Optional.of(minecraftkey);
            return this;
        }

        @Override
        public Builder apply(LootItemFunction.Builder lootitemfunction_a) {
            this.functions.add((Object)lootitemfunction_a.build());
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public LootTable build() {
            return new LootTable(this.paramSet, this.randomSequence, (List<LootPool>)this.pools.build(), (List<LootItemFunction>)this.functions.build());
        }
    }
}

