/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.OffsetDoubleList;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;

public abstract class VoxelShape {
    protected final DiscreteVoxelShape shape;
    @Nullable
    private VoxelShape[] faces;

    protected VoxelShape(DiscreteVoxelShape var0) {
        this.shape = var0;
    }

    public double min(Direction.Axis var0) {
        int var1 = this.shape.firstFull(var0);
        if (var1 >= this.shape.getSize(var0)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.get(var0, var1);
    }

    public double max(Direction.Axis var0) {
        int var1 = this.shape.lastFull(var0);
        if (var1 <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.get(var0, var1);
    }

    public AABB bounds() {
        if (this.isEmpty()) {
            throw Util.pauseInIde(new UnsupportedOperationException("No bounds for empty shape."));
        }
        return new AABB(this.min(Direction.Axis.X), this.min(Direction.Axis.Y), this.min(Direction.Axis.Z), this.max(Direction.Axis.X), this.max(Direction.Axis.Y), this.max(Direction.Axis.Z));
    }

    public VoxelShape singleEncompassing() {
        if (this.isEmpty()) {
            return Shapes.empty();
        }
        return Shapes.box(this.min(Direction.Axis.X), this.min(Direction.Axis.Y), this.min(Direction.Axis.Z), this.max(Direction.Axis.X), this.max(Direction.Axis.Y), this.max(Direction.Axis.Z));
    }

    protected double get(Direction.Axis var0, int var1) {
        return this.getCoords(var0).getDouble(var1);
    }

    public abstract DoubleList getCoords(Direction.Axis var1);

    public boolean isEmpty() {
        return this.shape.isEmpty();
    }

    public VoxelShape move(Vec3 var0) {
        return this.move(var0.x, var0.y, var0.z);
    }

    public VoxelShape move(Vec3i var0) {
        return this.move(var0.getX(), var0.getY(), var0.getZ());
    }

    public VoxelShape move(double var0, double var2, double var4) {
        if (this.isEmpty()) {
            return Shapes.empty();
        }
        return new ArrayVoxelShape(this.shape, (DoubleList)new OffsetDoubleList(this.getCoords(Direction.Axis.X), var0), (DoubleList)new OffsetDoubleList(this.getCoords(Direction.Axis.Y), var2), (DoubleList)new OffsetDoubleList(this.getCoords(Direction.Axis.Z), var4));
    }

    public VoxelShape optimize() {
        VoxelShape[] var0 = new VoxelShape[]{Shapes.empty()};
        this.forAllBoxes((var1, var3, var5, var7, var9, var11) -> {
            var0[0] = Shapes.joinUnoptimized(var0[0], Shapes.box(var1, var3, var5, var7, var9, var11), BooleanOp.OR);
        });
        return var0[0];
    }

    public void forAllEdges(Shapes.DoubleLineConsumer var0) {
        this.shape.forAllEdges((var1, var2, var3, var4, var5, var6) -> var0.consume(this.get(Direction.Axis.X, var1), this.get(Direction.Axis.Y, var2), this.get(Direction.Axis.Z, var3), this.get(Direction.Axis.X, var4), this.get(Direction.Axis.Y, var5), this.get(Direction.Axis.Z, var6)), true);
    }

    public void forAllBoxes(Shapes.DoubleLineConsumer var0) {
        DoubleList var1 = this.getCoords(Direction.Axis.X);
        DoubleList var2 = this.getCoords(Direction.Axis.Y);
        DoubleList var3 = this.getCoords(Direction.Axis.Z);
        this.shape.forAllBoxes((var4, var5, var6, var7, var8, var9) -> var0.consume(var1.getDouble(var4), var2.getDouble(var5), var3.getDouble(var6), var1.getDouble(var7), var2.getDouble(var8), var3.getDouble(var9)), true);
    }

    public List<AABB> toAabbs() {
        ArrayList var0 = Lists.newArrayList();
        this.forAllBoxes((var1, var3, var5, var7, var9, var11) -> var0.add(new AABB(var1, var3, var5, var7, var9, var11)));
        return var0;
    }

    public double min(Direction.Axis var0, double var1, double var3) {
        int var8;
        Direction.Axis var5 = AxisCycle.FORWARD.cycle(var0);
        Direction.Axis var6 = AxisCycle.BACKWARD.cycle(var0);
        int var7 = this.findIndex(var5, var1);
        int var9 = this.shape.firstFull(var0, var7, var8 = this.findIndex(var6, var3));
        if (var9 >= this.shape.getSize(var0)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.get(var0, var9);
    }

    public double max(Direction.Axis var0, double var1, double var3) {
        int var8;
        Direction.Axis var5 = AxisCycle.FORWARD.cycle(var0);
        Direction.Axis var6 = AxisCycle.BACKWARD.cycle(var0);
        int var7 = this.findIndex(var5, var1);
        int var9 = this.shape.lastFull(var0, var7, var8 = this.findIndex(var6, var3));
        if (var9 <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.get(var0, var9);
    }

    protected int findIndex(Direction.Axis var0, double var1) {
        return Mth.binarySearch(0, this.shape.getSize(var0) + 1, var3 -> var1 < this.get(var0, var3)) - 1;
    }

    @Nullable
    public BlockHitResult clip(Vec3 var0, Vec3 var1, BlockPos var2) {
        if (this.isEmpty()) {
            return null;
        }
        Vec3 var3 = var1.subtract(var0);
        if (var3.lengthSqr() < 1.0E-7) {
            return null;
        }
        Vec3 var4 = var0.add(var3.scale(0.001));
        if (this.shape.isFullWide(this.findIndex(Direction.Axis.X, var4.x - (double)var2.getX()), this.findIndex(Direction.Axis.Y, var4.y - (double)var2.getY()), this.findIndex(Direction.Axis.Z, var4.z - (double)var2.getZ()))) {
            return new BlockHitResult(var4, Direction.getApproximateNearest(var3.x, var3.y, var3.z).getOpposite(), var2, true);
        }
        return AABB.clip(this.toAabbs(), var0, var1, var2);
    }

    public Optional<Vec3> closestPointTo(Vec3 var0) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        Vec3[] var1 = new Vec3[1];
        this.forAllBoxes((var2, var4, var6, var8, var10, var12) -> {
            double var14 = Mth.clamp(var0.x(), var2, var8);
            double var16 = Mth.clamp(var0.y(), var4, var10);
            double var18 = Mth.clamp(var0.z(), var6, var12);
            if (var1[0] == null || var0.distanceToSqr(var14, var16, var18) < var0.distanceToSqr(var1[0])) {
                var1[0] = new Vec3(var14, var16, var18);
            }
        });
        return Optional.of(var1[0]);
    }

    public VoxelShape getFaceShape(Direction var0) {
        VoxelShape var1;
        if (this.isEmpty() || this == Shapes.block()) {
            return this;
        }
        if (this.faces != null) {
            var1 = this.faces[var0.ordinal()];
            if (var1 != null) {
                return var1;
            }
        } else {
            this.faces = new VoxelShape[6];
        }
        this.faces[var0.ordinal()] = var1 = this.calculateFace(var0);
        return var1;
    }

    private VoxelShape calculateFace(Direction var0) {
        Direction.Axis var1 = var0.getAxis();
        if (this.isCubeLikeAlong(var1)) {
            return this;
        }
        Direction.AxisDirection var2 = var0.getAxisDirection();
        int var3 = this.findIndex(var1, var2 == Direction.AxisDirection.POSITIVE ? 0.9999999 : 1.0E-7);
        SliceShape var4 = new SliceShape(this, var1, var3);
        if (var4.isEmpty()) {
            return Shapes.empty();
        }
        if (var4.isCubeLike()) {
            return Shapes.block();
        }
        return var4;
    }

    protected boolean isCubeLike() {
        for (Direction.Axis var3 : Direction.Axis.VALUES) {
            if (this.isCubeLikeAlong(var3)) continue;
            return false;
        }
        return true;
    }

    private boolean isCubeLikeAlong(Direction.Axis var0) {
        DoubleList var1 = this.getCoords(var0);
        return var1.size() == 2 && DoubleMath.fuzzyEquals((double)var1.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)var1.getDouble(1), (double)1.0, (double)1.0E-7);
    }

    public double collide(Direction.Axis var0, AABB var1, double var2) {
        return this.collideX(AxisCycle.between(var0, Direction.Axis.X), var1, var2);
    }

    protected double collideX(AxisCycle var0, AABB var1, double var2) {
        block11: {
            int var17;
            int var15;
            double var10;
            Direction.Axis var5;
            AxisCycle var4;
            block10: {
                if (this.isEmpty()) {
                    return var2;
                }
                if (Math.abs(var2) < 1.0E-7) {
                    return 0.0;
                }
                var4 = var0.inverse();
                var5 = var4.cycle(Direction.Axis.X);
                Direction.Axis var6 = var4.cycle(Direction.Axis.Y);
                Direction.Axis var7 = var4.cycle(Direction.Axis.Z);
                double var8 = var1.max(var5);
                var10 = var1.min(var5);
                int var12 = this.findIndex(var5, var10 + 1.0E-7);
                int var13 = this.findIndex(var5, var8 - 1.0E-7);
                int var14 = Math.max(0, this.findIndex(var6, var1.min(var6) + 1.0E-7));
                var15 = Math.min(this.shape.getSize(var6), this.findIndex(var6, var1.max(var6) - 1.0E-7) + 1);
                int var16 = Math.max(0, this.findIndex(var7, var1.min(var7) + 1.0E-7));
                var17 = Math.min(this.shape.getSize(var7), this.findIndex(var7, var1.max(var7) - 1.0E-7) + 1);
                int var18 = this.shape.getSize(var5);
                if (!(var2 > 0.0)) break block10;
                for (int var19 = var13 + 1; var19 < var18; ++var19) {
                    for (int var20 = var14; var20 < var15; ++var20) {
                        for (int var21 = var16; var21 < var17; ++var21) {
                            if (!this.shape.isFullWide(var4, var19, var20, var21)) continue;
                            double var22 = this.get(var5, var19) - var8;
                            if (var22 >= -1.0E-7) {
                                var2 = Math.min(var2, var22);
                            }
                            return var2;
                        }
                    }
                }
                break block11;
            }
            if (!(var2 < 0.0)) break block11;
            for (int var19 = var12 - 1; var19 >= 0; --var19) {
                for (int var20 = var14; var20 < var15; ++var20) {
                    for (int var21 = var16; var21 < var17; ++var21) {
                        if (!this.shape.isFullWide(var4, var19, var20, var21)) continue;
                        double var22 = this.get(var5, var19 + 1) - var10;
                        if (var22 <= 1.0E-7) {
                            var2 = Math.max(var2, var22);
                        }
                        return var2;
                    }
                }
            }
        }
        return var2;
    }

    public boolean equals(Object var0) {
        return super.equals(var0);
    }

    public String toString() {
        return this.isEmpty() ? "EMPTY" : "VoxelShape[" + String.valueOf(this.bounds()) + "]";
    }
}

