/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.waypoints;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundTrackedWaypointPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.waypoints.Waypoint;

public interface WaypointTransmitter
extends Waypoint {
    public static final int REALLY_FAR_DISTANCE = 332;

    public boolean isTransmittingWaypoint();

    public Optional<Connection> makeWaypointConnectionWith(ServerPlayer var1);

    public Waypoint.Icon waypointIcon();

    public static boolean doesSourceIgnoreReceiver(LivingEntity entityliving, ServerPlayer entityplayer) {
        if (!entityplayer.getBukkitEntity().canSee(entityliving.getBukkitEntity())) {
            return true;
        }
        if (entityplayer.isSpectator()) {
            return false;
        }
        if (!entityliving.isSpectator() && !entityliving.hasIndirectPassenger(entityplayer)) {
            double d0 = Math.min(entityliving.getAttributeValue(Attributes.WAYPOINT_TRANSMIT_RANGE), entityplayer.getAttributeValue(Attributes.WAYPOINT_RECEIVE_RANGE));
            return (double)entityliving.distanceTo(entityplayer) >= d0;
        }
        return true;
    }

    public static boolean isChunkVisible(ChunkPos chunkcoordintpair, ServerPlayer entityplayer) {
        return entityplayer.getChunkTrackingView().isInViewDistance(chunkcoordintpair.x, chunkcoordintpair.z);
    }

    public static boolean isReallyFar(LivingEntity entityliving, ServerPlayer entityplayer) {
        return entityliving.distanceTo(entityplayer) > 332.0f;
    }

    public static interface Connection {
        public void connect();

        public void disconnect();

        public void update();

        public boolean isBroken();
    }

    public static class EntityAzimuthConnection
    implements Connection {
        private final LivingEntity source;
        private final Waypoint.Icon icon;
        private final ServerPlayer receiver;
        private float lastAngle;

        public EntityAzimuthConnection(LivingEntity entityliving, Waypoint.Icon waypoint_a, ServerPlayer entityplayer) {
            this.source = entityliving;
            this.icon = waypoint_a;
            this.receiver = entityplayer;
            Vec3 vec3d = entityplayer.position().subtract(entityliving.position()).rotateClockwise90();
            this.lastAngle = (float)Mth.atan2(vec3d.z(), vec3d.x());
        }

        @Override
        public boolean isBroken() {
            return WaypointTransmitter.doesSourceIgnoreReceiver(this.source, this.receiver) || WaypointTransmitter.isChunkVisible(this.source.chunkPosition(), this.receiver) || !WaypointTransmitter.isReallyFar(this.source, this.receiver);
        }

        @Override
        public void connect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.addWaypointAzimuth(this.source.getUUID(), this.icon, this.lastAngle));
        }

        @Override
        public void disconnect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.removeWaypoint(this.source.getUUID()));
        }

        @Override
        public void update() {
            Vec3 vec3d = this.receiver.position().subtract(this.source.position()).rotateClockwise90();
            float f = (float)Mth.atan2(vec3d.z(), vec3d.x());
            if (Mth.abs(f - this.lastAngle) > (float)Math.PI / 360) {
                this.receiver.connection.send(ClientboundTrackedWaypointPacket.updateWaypointAzimuth(this.source.getUUID(), this.icon, f));
                this.lastAngle = f;
            }
        }
    }

    public static class EntityChunkConnection
    implements ChunkConnection {
        private final LivingEntity source;
        private final Waypoint.Icon icon;
        private final ServerPlayer receiver;
        private ChunkPos lastPosition;

        public EntityChunkConnection(LivingEntity entityliving, Waypoint.Icon waypoint_a, ServerPlayer entityplayer) {
            this.source = entityliving;
            this.icon = waypoint_a;
            this.receiver = entityplayer;
            this.lastPosition = entityliving.chunkPosition();
        }

        @Override
        public int distanceChessboard() {
            return this.lastPosition.getChessboardDistance(this.source.chunkPosition());
        }

        @Override
        public void connect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.addWaypointChunk(this.source.getUUID(), this.icon, this.lastPosition));
        }

        @Override
        public void disconnect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.removeWaypoint(this.source.getUUID()));
        }

        @Override
        public void update() {
            ChunkPos chunkcoordintpair = this.source.chunkPosition();
            if (chunkcoordintpair.getChessboardDistance(this.lastPosition) > 0) {
                this.receiver.connection.send(ClientboundTrackedWaypointPacket.updateWaypointChunk(this.source.getUUID(), this.icon, chunkcoordintpair));
                this.lastPosition = chunkcoordintpair;
            }
        }

        @Override
        public boolean isBroken() {
            return !ChunkConnection.super.isBroken() && !WaypointTransmitter.doesSourceIgnoreReceiver(this.source, this.receiver) ? WaypointTransmitter.isChunkVisible(this.lastPosition, this.receiver) : true;
        }
    }

    public static interface ChunkConnection
    extends Connection {
        public int distanceChessboard();

        @Override
        default public boolean isBroken() {
            return this.distanceChessboard() > 1;
        }
    }

    public static class EntityBlockConnection
    implements BlockConnection {
        private final LivingEntity source;
        private final Waypoint.Icon icon;
        private final ServerPlayer receiver;
        private BlockPos lastPosition;

        public EntityBlockConnection(LivingEntity entityliving, Waypoint.Icon waypoint_a, ServerPlayer entityplayer) {
            this.source = entityliving;
            this.receiver = entityplayer;
            this.icon = waypoint_a;
            this.lastPosition = entityliving.blockPosition();
        }

        @Override
        public void connect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.addWaypointPosition(this.source.getUUID(), this.icon, this.lastPosition));
        }

        @Override
        public void disconnect() {
            this.receiver.connection.send(ClientboundTrackedWaypointPacket.removeWaypoint(this.source.getUUID()));
        }

        @Override
        public void update() {
            BlockPos blockposition = this.source.blockPosition();
            if (blockposition.distManhattan(this.lastPosition) > 0) {
                this.receiver.connection.send(ClientboundTrackedWaypointPacket.updateWaypointPosition(this.source.getUUID(), this.icon, blockposition));
                this.lastPosition = blockposition;
            }
        }

        @Override
        public int distanceManhattan() {
            return this.lastPosition.distManhattan(this.source.blockPosition());
        }

        @Override
        public boolean isBroken() {
            return BlockConnection.super.isBroken() || WaypointTransmitter.doesSourceIgnoreReceiver(this.source, this.receiver);
        }
    }

    public static interface BlockConnection
    extends Connection {
        public int distanceManhattan();

        @Override
        default public boolean isBroken() {
            return this.distanceManhattan() > 1;
        }
    }
}

