/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import org.bukkit.Location;
import org.bukkit.Nameable;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftContainer;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;

public abstract class CraftLootable<T extends RandomizableContainerBlockEntity>
extends CraftContainer<T>
implements Nameable,
Lootable {
    public CraftLootable(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftLootable(CraftLootable<T> state, Location location) {
        super(state, location);
    }

    @Override
    protected void applyTo(T lootable) {
        super.applyTo(lootable);
        if (((RandomizableContainerBlockEntity)this.getSnapshot()).lootTable == null) {
            lootable.setLootTable(null, 0L);
        }
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(((RandomizableContainerBlockEntity)this.getSnapshot()).lootTable);
    }

    public void setLootTable(LootTable table) {
        this.setLootTable(table, this.getSeed());
    }

    public long getSeed() {
        return ((RandomizableContainerBlockEntity)this.getSnapshot()).lootTableSeed;
    }

    public void setSeed(long seed) {
        this.setLootTable(this.getLootTable(), seed);
    }

    private void setLootTable(LootTable table, long seed) {
        ((RandomizableContainerBlockEntity)this.getSnapshot()).setLootTable(CraftLootTable.bukkitToMinecraft(table), seed);
    }

    @Override
    public abstract CraftLootable<T> copy();

    @Override
    public abstract CraftLootable<T> copy(Location var1);
}

