/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.horse.Llama;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftChestedHorse;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryLlama;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;

public class CraftLlama
extends CraftChestedHorse
implements org.bukkit.entity.Llama {
    public CraftLlama(CraftServer server, Llama entity) {
        super(server, entity);
    }

    @Override
    public Llama getHandle() {
        return (Llama)super.getHandle();
    }

    public Llama.Color getColor() {
        return Llama.Color.values()[this.getHandle().getVariant().ordinal()];
    }

    public void setColor(Llama.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.getHandle().setVariant(Llama.Variant.byId(color.ordinal()));
    }

    public LlamaInventory getInventory() {
        return new CraftInventoryLlama(this.getHandle().inventory, this.getHandle().equipment);
    }

    public int getStrength() {
        return this.getHandle().getStrength();
    }

    public void setStrength(int strength) {
        Preconditions.checkArgument((1 <= strength && strength <= 5 ? 1 : 0) != 0, (Object)"strength must be [1,5]");
        if (strength == this.getStrength()) {
            return;
        }
        this.getHandle().setStrengthPublic(strength);
        this.getHandle().createInventory();
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    @Override
    public String toString() {
        return "CraftLlama";
    }
}

