/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R6.CraftArt;
import org.bukkit.craftbukkit.v1_21_R6.CraftFluid;
import org.bukkit.craftbukkit.v1_21_R6.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R6.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R6.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R6.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R6.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R6.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_21_R6.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.Handleable;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static jy registry;
    private final Class<? super B> bukkitClass;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final jx<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, jk<M>, B> minecraftToBukkit;
    private final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater;
    private boolean init;

    public static void setMinecraftRegistry(jy registry) {
        Preconditions.checkState((CraftRegistry.registry == null ? 1 : 0) != 0, (Object)"Registry already set");
        CraftRegistry.registry = registry;
    }

    public static jy getMinecraftRegistry() {
        return registry;
    }

    public static <E> jx<E> getMinecraftRegistry(ami<jx<E>> key) {
        return CraftRegistry.getMinecraftRegistry().f(key);
    }

    public static <B extends Keyed, M> B minecraftToBukkit(M minecraft, ami<jx<M>> registryKey, Registry<B> bukkitRegistry) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        jx registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Keyed bukkit = bukkitRegistry.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow(() -> new IllegalStateException(String.format("Cannot convert '%s' to bukkit representation, since it is not registered.", minecraft))).a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> M bukkitToMinecraft(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Handleable)bukkit).getHandle();
    }

    public static <B extends Keyed, M> jk<M> bukkitToMinecraftHolder(B bukkit, ami<jx<M>> registryKey) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        jx registry = CraftRegistry.getMinecraftRegistry(registryKey);
        jk jk2 = registry.e(CraftRegistry.bukkitToMinecraft(bukkit));
        if (jk2 instanceof jk.c) {
            jk.c holder = (jk.c)jk2;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own registry entry with out properly registering it.");
    }

    private static <M, B> BiFunction<NamespacedKey, jk<M>, B> wrap(BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        return (namespacedKey, holder) -> minecraftToBukkit.apply((NamespacedKey)namespacedKey, (Object)holder.a());
    }

    public static <B extends Keyed> Registry<?> createRegistry(Class<? super B> bukkitClass, jy registryHolder) {
        if (bukkitClass == Art.class) {
            return new CraftRegistry<CraftArt, cvn>(Art.class, registryHolder.f(mp.bh), CraftArt::new, FieldRename.NONE);
        }
        if (bukkitClass == Attribute.class) {
            return new CraftRegistry<CraftAttribute, cfx>(Attribute.class, registryHolder.f(mp.c), CraftAttribute::new, FieldRename.ATTRIBUTE_RENAME);
        }
        if (bukkitClass == Biome.class) {
            return new CraftRegistry<CraftBiome, dst>(Biome.class, registryHolder.f(mp.aN), CraftBiome::new, FieldRename.BIOME_RENAME);
        }
        if (bukkitClass == Enchantment.class) {
            return new CraftRegistry<CraftEnchantment, doe>(Enchantment.class, registryHolder.f(mp.aZ), CraftRegistry.wrap(CraftEnchantment::new), FieldRename.ENCHANTMENT_RENAME);
        }
        if (bukkitClass == Fluid.class) {
            return new CraftRegistry<CraftFluid, ffz>(Fluid.class, registryHolder.f(mp.I), CraftFluid::new, FieldRename.NONE);
        }
        if (bukkitClass == GameEvent.class) {
            return new CraftRegistry<CraftGameEvent, eoq>(GameEvent.class, registryHolder.f(mp.K), CraftRegistry.wrap(CraftGameEvent::new), FieldRename.NONE);
        }
        if (bukkitClass == MusicInstrument.class) {
            return new CraftRegistry<CraftMusicInstrument, dhi>(MusicInstrument.class, registryHolder.f(mp.bc), CraftMusicInstrument::new, FieldRename.NONE);
        }
        if (bukkitClass == MenuType.class) {
            return new CraftRegistry(MenuType.class, registryHolder.f(mp.Z), CraftMenuType::new, FieldRename.NONE);
        }
        if (bukkitClass == PotionEffectType.class) {
            return new CraftRegistry<CraftPotionEffectType, ccv>(PotionEffectType.class, registryHolder.f(mp.aa), CraftRegistry.wrap(CraftPotionEffectType::new), FieldRename.NONE);
        }
        if (bukkitClass == Sound.class) {
            return new CraftRegistry<CraftSound, bcd>(Sound.class, registryHolder.f(mp.at), CraftSound::new, FieldRename.NONE);
        }
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, fan>(Structure.class, registryHolder.f(mp.bm), CraftRegistry.wrap(CraftStructure::new), FieldRename.NONE);
        }
        if (bukkitClass == StructureType.class) {
            return new CraftRegistry<CraftStructureType, faw>(StructureType.class, registryHolder.f(mp.aA), CraftRegistry.wrap(CraftStructureType::new), FieldRename.NONE);
        }
        if (bukkitClass == Villager.Type.class) {
            return new CraftRegistry<CraftVillager.CraftType, czc>(Villager.Type.class, registryHolder.f(mp.aJ), CraftVillager.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Villager.Profession.class) {
            return new CraftRegistry<CraftVillager.CraftProfession, cza>(Villager.Profession.class, registryHolder.f(mp.aI), CraftVillager.CraftProfession::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimMaterial.class) {
            return new CraftRegistry<CraftTrimMaterial, dqe>(TrimMaterial.class, registryHolder.f(mp.bs), CraftTrimMaterial::new, FieldRename.NONE);
        }
        if (bukkitClass == TrimPattern.class) {
            return new CraftRegistry<CraftTrimPattern, dqg>(TrimPattern.class, registryHolder.f(mp.bt), CraftTrimPattern::new, FieldRename.NONE);
        }
        if (bukkitClass == DamageType.class) {
            return new CraftRegistry<CraftDamageType, cck>(DamageType.class, registryHolder.f(mp.aU), CraftDamageType::new, FieldRename.NONE);
        }
        if (bukkitClass == JukeboxSong.class) {
            return new CraftRegistry<CraftJukeboxSong, dhv>(JukeboxSong.class, registryHolder.f(mp.bd), CraftJukeboxSong::new, FieldRename.NONE);
        }
        if (bukkitClass == Wolf.Variant.class) {
            return new CraftRegistry<CraftWolf.CraftVariant, cud>(Wolf.Variant.class, registryHolder.f(mp.bu), CraftWolf.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == BlockType.class) {
            return new CraftRegistry<CraftBlockType, duv>(BlockType.class, registryHolder.f(mp.i), CraftBlockType::new, FieldRename.BLOCK_TYPE_RENAME);
        }
        if (bukkitClass == ItemType.class) {
            return new CraftRegistry<CraftItemType, dhl>(ItemType.class, registryHolder.f(mp.O), CraftItemType::new, FieldRename.ITEM_TYPE_RENAME);
        }
        if (bukkitClass == Frog.Variant.class) {
            return new CraftRegistry<CraftFrog.CraftVariant, csx>(Frog.Variant.class, registryHolder.f(mp.bb), CraftFrog.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cat.Type.class) {
            return new CraftRegistry<CraftCat.CraftType, cqu>(Cat.Type.class, registryHolder.f(mp.aO), CraftCat.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == Pig.Variant.class) {
            return new CraftRegistry<CraftPig.CraftVariant, cro>(Pig.Variant.class, registryHolder.f(mp.bi), CraftPig.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Cow.Variant.class) {
            return new CraftRegistry<CraftCow.CraftVariant, crb>(Cow.Variant.class, registryHolder.f(mp.aT), CraftCow.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == Chicken.Variant.class) {
            return new CraftRegistry<CraftChicken.CraftVariant, cqx>(Chicken.Variant.class, registryHolder.f(mp.aQ), CraftChicken.CraftVariant::new, FieldRename.NONE);
        }
        if (bukkitClass == MapCursor.Type.class) {
            return new CraftRegistry<CraftMapCursor.CraftType, fhq>(MapCursor.Type.class, registryHolder.f(mp.V), CraftMapCursor.CraftType::new, FieldRename.NONE);
        }
        if (bukkitClass == PatternType.class) {
            return new CraftRegistry<CraftPatternType, efv>(PatternType.class, registryHolder.f(mp.aM), CraftPatternType::new, FieldRename.NONE);
        }
        return null;
    }

    public static <B extends Keyed> B get(Registry<B> bukkit, NamespacedKey namespacedKey, ApiVersion apiVersion) {
        if (bukkit instanceof CraftRegistry) {
            CraftRegistry craft = (CraftRegistry)bukkit;
            return craft.get(namespacedKey, apiVersion);
        }
        if (bukkit instanceof Registry.SimpleRegistry) {
            Registry.SimpleRegistry simple = (Registry.SimpleRegistry)bukkit;
            Class bClass = simple.getType();
            if (bClass == EntityType.class) {
                return (B)bukkit.get(FieldRename.ENTITY_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Particle.class) {
                return (B)bukkit.get(FieldRename.PARTICLE_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
        }
        return (B)bukkit.get(namespacedKey);
    }

    public CraftRegistry(Class<? super B> bukkitClass, jx<M> minecraftRegistry, BiFunction<NamespacedKey, jk<M>, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater) {
        this.bukkitClass = bukkitClass;
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
        this.updater = updater;
    }

    public B get(NamespacedKey namespacedKey, ApiVersion apiVersion) {
        return this.get(this.updater.apply(namespacedKey, apiVersion));
    }

    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        if (!this.init) {
            this.init = true;
            try {
                Class.forName(this.bukkitClass.getName());
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("Could not load registry class " + String.valueOf(this.bukkitClass), e2);
            }
            return this.get(namespacedKey);
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.c(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @NotNull
    public B getOrThrow(@NotNull NamespacedKey namespacedKey) {
        B object = this.get(namespacedKey);
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (String)"No %s registry entry found for key %s.", this.minecraftRegistry.g(), (Object)namespacedKey);
        return object;
    }

    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.i().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, jk<M> minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }
}

