/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftBlockEntityState<T extends egg>
extends CraftBlockState
implements TileState {
    private final T tileEntity;
    private final T snapshot;

    public CraftBlockEntityState(World world, T tileEntity) {
        super(world, ((egg)tileEntity).aD_(), ((egg)tileEntity).o());
        this.tileEntity = tileEntity;
        this.snapshot = this.createSnapshot(tileEntity);
        this.load(this.snapshot);
    }

    protected CraftBlockEntityState(CraftBlockEntityState<T> state, Location location) {
        super(state, location);
        this.tileEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.tileEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public void refreshSnapshot() {
        this.load(this.tileEntity);
    }

    protected jy getRegistryAccess() {
        drr worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.L_() : MinecraftServer.getDefaultRegistryAccess();
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        up nbtTagCompound = ((egg)tileEntity).b(this.getRegistryAccess());
        egg snapshot = egg.a(this.getPosition(), this.getHandle(), nbtTagCompound, this.getRegistryAccess());
        return (T)snapshot;
    }

    public Set<ko<?>> applyComponents(km datacomponentmap, kn datacomponentpatch) {
        Set<ko<?>> result = ((egg)this.snapshot).applyComponentsSet(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
        return result;
    }

    public km collectComponents() {
        return ((egg)this.snapshot).t();
    }

    private fip createInput(up nbtTagCompound) {
        return fin.a(bfo.a, (jm.a)this.getRegistryAccess(), nbtTagCompound);
    }

    private fio createOutput() {
        return fio.a(bfo.a, this.getRegistryAccess());
    }

    public void loadData(up nbtTagCompound) {
        this.loadData(this.createInput(nbtTagCompound));
    }

    public void loadData(fip input) {
        ((egg)this.snapshot).b(input);
        this.load(this.snapshot);
    }

    private void copyData(T from, T to2) {
        up nbtTagCompound = ((egg)from).b(this.getRegistryAccess());
        ((egg)to2).b(this.createInput(nbtTagCompound));
    }

    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected egg getTileEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().c_(this.getPosition());
    }

    public up getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return ((egg)this.snapshot).b(this.getRegistryAccess());
    }

    public fip getSnapshotInput() {
        return this.createInput(this.getSnapshotNBT());
    }

    public fio getItemNBT() {
        this.applyTo(this.snapshot);
        fio output = this.createOutput();
        ((egg)this.snapshot).f(output);
        ((egg)this.snapshot).b(output);
        return output;
    }

    public egi<?> getEntityType() {
        return ((egg)this.snapshot).s();
    }

    public up getUpdateNBT() {
        this.applyTo(this.snapshot);
        return ((egg)this.snapshot).a(this.getRegistryAccess());
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(egg tileEntity) {
        return tileEntity != null && this.tileEntity.getClass() == tileEntity.getClass();
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        egg tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo(tile);
            tile.e();
        }
        return result;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return ((egg)this.getSnapshot()).persistentDataContainer;
    }

    @Nullable
    public aao<acr> getUpdatePacket(@NotNull Location location) {
        return new acx(CraftLocation.toBlockPosition(location), ((egg)this.snapshot).s(), this.getUpdateNBT());
    }

    @Override
    public CraftBlockEntityState<T> copy() {
        return new CraftBlockEntityState<T>(this, null);
    }

    @Override
    public CraftBlockEntityState<T> copy(Location location) {
        return new CraftBlockEntityState<T>(this, location);
    }
}

