/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.LevelDebugSynchronizers;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R6.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R6.util.WorldUUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;

public class WorldServer
extends net.minecraft.world.level.World
implements ServerEntityGetter,
GeneratorAccessSeed {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider C = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger D = LogUtils.getLogger();
    private static final int E = 300;
    private static final int F = 65536;
    final List<EntityPlayer> G = Lists.newArrayList();
    private final ChunkProviderServer H;
    private final MinecraftServer I;
    public final WorldDataServer J;
    final EntityTickList K = new EntityTickList();
    private final ServerWaypointManager L;
    public final PersistentEntitySectionManager<Entity> M;
    private final GameEventDispatcher N;
    public boolean e;
    private final SleepStatus O;
    private int P;
    private final PortalTravelAgent Q;
    private final TickListServer<Block> R = new TickListServer(this::d);
    private final TickListServer<FluidType> S = new TickListServer(this::d);
    private final PathTypeCache T = new PathTypeCache();
    final Set<EntityInsentient> U = new ObjectOpenHashSet();
    volatile boolean V;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> W = new ObjectLinkedOpenHashSet();
    private final List<BlockActionData> X = new ArrayList<BlockActionData>(64);
    private boolean Y;
    private final List<MobSpawner> Z;
    @Nullable
    private EnderDragonBattle aa;
    final Int2ObjectMap<EntityComplexPart> ab = new Int2ObjectOpenHashMap();
    private final StructureManager ac;
    private final StructureCheck ad;
    private final boolean ae;
    private final RandomSequences af;
    final LevelDebugSynchronizers ag = new LevelDebugSynchronizers(this);
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;

    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.H.a(x2, z2, false);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, WorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, WorldDimension worlddimension, boolean flag, long i2, List<MobSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.bg(), worlddimension.a(), false, flag, i2, minecraftserver.bp(), gen, biomeProvider, env);
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.c.f().toFile());
        this.ae = flag1;
        this.I = minecraftserver;
        this.Z = list;
        this.J = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.b();
        this.J.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.I.bg().f(Registries.aN));
            if (chunkgenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkgenerator;
                chunkgenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.e);
            } else if (chunkgenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat cpf = (ChunkProviderFlat)chunkgenerator;
                chunkgenerator = new ChunkProviderFlat(cpf.h(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.bd();
        DataFixer datafixer = minecraftserver.aE();
        EntityStorage entitypersistentstorage = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(convertable_conversionsession.f(), resourcekey, "entities"), convertable_conversionsession.a(resourcekey).resolve("entities"), datafixer, flag2, DataFixTypes.u), this, minecraftserver);
        this.M = new PersistentEntitySectionManager<Entity>(Entity.class, new a(), entitypersistentstorage);
        StructureTemplateManager structuretemplatemanager = minecraftserver.be();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.M;
        Objects.requireNonNull(this.M);
        this.H = new ChunkProviderServer(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j2, k2, flag2, persistententitysectionmanager::a, () -> minecraftserver.O().y());
        this.H.h().b();
        this.Q = new PortalTravelAgent(this);
        this.ae();
        this.af();
        this.f = this.y().a(PersistentRaid.a(this.ak()));
        if (!minecraftserver.Y()) {
            iworlddataserver.a(minecraftserver.y());
        }
        long l2 = minecraftserver.bf().x().c();
        this.ad = new StructureCheck(this.H.o(), this.L_(), minecraftserver.be(), resourcekey, chunkgenerator, this.H.i(), this, chunkgenerator.d(), l2, datafixer);
        this.ac = new StructureManager(this, this.J.x(), this.ad);
        this.aa = this.al() == net.minecraft.world.level.World.j && this.ak().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.J.x().c(), this.J.B()) : null;
        this.O = new SleepStatus();
        this.N = new GameEventDispatcher(this);
        this.af = Objects.requireNonNullElseGet(randomsequences, () -> this.y().a(RandomSequences.a));
        this.L = new ServerWaypointManager();
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle enderdragonbattle) {
        this.aa = enderdragonbattle;
    }

    public void a(int i2, int j2, boolean flag, boolean flag1) {
        this.J.a(i2);
        this.J.c(j2);
        this.J.b(j2);
        this.J.b(flag);
        this.J.a(flag1);
    }

    @Override
    public Holder<BiomeBase> a(int i2, int j2, int k2) {
        return this.n().g().d().getNoiseBiome(i2, j2, k2, this.n().i().b());
    }

    public StructureManager b() {
        return this.ac;
    }

    public void a(BooleanSupplier booleansupplier) {
        int i2;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        this.Y = true;
        TickRateManager tickratemanager = this.w();
        boolean flag = tickratemanager.i();
        if (flag) {
            gameprofilerfiller.a("world border");
            this.u().s();
            gameprofilerfiller.b("weather");
            this.az();
            gameprofilerfiller.c();
        }
        if (this.O.a(i2 = this.S().d(GameRules.R)) && this.O.a(i2, this.G)) {
            TimeSkipEvent event = null;
            if (this.S().c(GameRules.m)) {
                long j2 = this.A.c() + 24000L;
                event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.ah());
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.b(this.ah() + event.getSkipAmount());
                }
            }
            if (event == null || !event.isCancelled()) {
                this.ax();
            }
            if (this.S().c(GameRules.x) && this.aj()) {
                this.i();
            }
        }
        this.ae();
        if (flag) {
            this.c();
        }
        gameprofilerfiller.a("tickPending");
        this.timings.doTickPending.startTiming();
        if (!this.am() && flag) {
            long k2 = this.ag();
            gameprofilerfiller.a("blockTicks");
            this.R.a(k2, 65536, this::c);
            gameprofilerfiller.b("fluidTicks");
            this.S.a(k2, 65536, this::a);
            gameprofilerfiller.c();
        }
        this.timings.doTickPending.stopTiming();
        gameprofilerfiller.b("raid");
        if (flag) {
            this.f.a(this);
        }
        gameprofilerfiller.b("chunkSource");
        this.n().a(booleansupplier, true);
        gameprofilerfiller.b("blockEvents");
        if (flag) {
            this.timings.doSounds.startTiming();
            this.aA();
            this.timings.doSounds.stopTiming();
        }
        this.Y = false;
        gameprofilerfiller.c();
        boolean flag1 = true;
        if (flag1) {
            this.j();
        }
        if (flag) {
            ++this.P;
        }
        if (this.P < 300) {
            gameprofilerfiller.a("entities");
            this.timings.tickEntities.startTiming();
            if (this.aa != null && flag) {
                gameprofilerfiller.a("dragonFight");
                this.aa.c();
                gameprofilerfiller.c();
            }
            ActivationRange.activateEntities(this);
            this.timings.entityTick.startTiming();
            this.K.a((Entity entity) -> {
                if (!entity.ec() && !tickratemanager.a((Entity)entity)) {
                    gameprofilerfiller.a("checkDespawn");
                    entity.dR();
                    gameprofilerfiller.c();
                    if (entity instanceof EntityPlayer || this.H.a.i().c(entity.dH().a())) {
                        Entity entity1 = entity.du();
                        if (entity1 != null) {
                            if (!entity1.ec() && entity1.z((Entity)entity)) {
                                return;
                            }
                            entity.cb();
                        }
                        gameprofilerfiller.a("tick");
                        this.a(this::a, entity);
                        gameprofilerfiller.c();
                    }
                }
            });
            this.timings.entityTick.stopTiming();
            this.timings.tickEntities.stopTiming();
            gameprofilerfiller.b("blockEntities");
            this.ad();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("entityManagement");
        this.M.b();
        gameprofilerfiller.c();
        gameprofilerfiller.a("debugSynchronizers");
        if (this.ag.a(DebugSubscriptions.o)) {
            this.s.a((BlockPosition blockposition) -> this.ag.b((BlockPosition)blockposition, DebugSubscriptions.o, blockposition));
        } else {
            this.s.a(null);
        }
        this.ag.a(this.I.bA());
        gameprofilerfiller.c();
    }

    @Override
    public boolean a(long i2) {
        return this.H.a.i().d(i2);
    }

    protected void c() {
        if (this.ae) {
            long i2 = this.A.b() + 1L;
            this.J.a(i2);
            Profiler.a().a("scheduledFunctions");
            this.J.r().a(this.I, i2);
            Profiler.a().c();
            if (this.J.n().c(GameRules.m)) {
                this.b(this.A.c() + 1L);
            }
        }
    }

    public void b(long i2) {
        this.J.b(i2);
    }

    public void a(boolean flag) {
        for (MobSpawner mobspawner : this.Z) {
            mobspawner.a(this, flag);
        }
    }

    private void ax() {
        this.O.a();
        this.G.stream().filter(EntityLiving::gg).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.a(false, false));
    }

    public void a(Chunk chunk, int i2) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("iceandsnow");
        for (int l2 = 0; l2 < i2; ++l2) {
            if (this.z.a(48) != 0) continue;
            this.a(this.a(j2, 0, k2, 15));
        }
        gameprofilerfiller.b("tickBlocks");
        if (i2 > 0) {
            ChunkSection[] achunksection = chunk.d();
            for (int i1 = 0; i1 < achunksection.length; ++i1) {
                ChunkSection chunksection = achunksection[i1];
                if (!chunksection.d()) continue;
                int j1 = chunk.h(i1);
                int k1 = SectionPosition.c(j1);
                for (int l1 = 0; l1 < i2; ++l1) {
                    Fluid fluid;
                    BlockPosition blockposition = this.a(j2, k1, k2, 15);
                    gameprofilerfiller.a("randomTick");
                    IBlockData iblockdata = chunksection.a(blockposition.u() - j2, blockposition.v() - k1, blockposition.w() - k2);
                    if (iblockdata.z()) {
                        iblockdata.b(this, blockposition, this.z);
                    }
                    if ((fluid = iblockdata.y()).f()) {
                        fluid.a(this, blockposition, this.z);
                    }
                    gameprofilerfiller.c();
                }
            }
        }
        gameprofilerfiller.c();
    }

    public void a(Chunk chunk) {
        BlockPosition blockposition;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        boolean flag = this.aj();
        int i2 = chunkcoordintpair.d();
        int j2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("thunder");
        if (flag && this.ai() && this.spigotConfig.thunderChance > 0 && this.z.a(this.spigotConfig.thunderChance) == 0 && this.r(blockposition = this.b(this.a(i2, 0, j2, 15)))) {
            EntityLightning entitylightning;
            EntityHorseSkeleton entityhorseskeleton;
            boolean flag1;
            DifficultyDamageScaler difficultydamagescaler = this.d_(blockposition);
            boolean bl = flag1 = this.S().c(GameRules.f) && this.z.j() < (double)difficultydamagescaler.b() * 0.01 && !this.a_(blockposition.e()).a(TagsBlock.aj);
            if (flag1 && (entityhorseskeleton = EntityTypes.bl.a(this, EntitySpawnReason.h)) != null) {
                entityhorseskeleton.x(true);
                entityhorseskeleton.c_(0);
                entityhorseskeleton.a_(blockposition.u(), blockposition.v(), blockposition.w());
                this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((entitylightning = EntityTypes.aA.a(this, EntitySpawnReason.h)) != null) {
                entitylightning.f(Vec3D.c(blockposition));
                entitylightning.a(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.c();
    }

    @VisibleForTesting
    public void a(BlockPosition blockposition) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, blockposition);
        BlockPosition blockposition2 = blockposition1.e();
        BiomeBase biomebase = this.v(blockposition1).a();
        if (biomebase.a(this, blockposition2)) {
            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition2, Blocks.eq.m(), null);
        }
        if (this.aj()) {
            BiomeBase.Precipitation biomebase_precipitation;
            int i2 = this.S().d(GameRules.V);
            if (i2 > 0 && biomebase.b(this, blockposition1)) {
                IBlockData iblockdata = this.a_(blockposition1);
                if (iblockdata.a(Blocks.ep)) {
                    int j2 = iblockdata.c(BlockSnow.c);
                    if (j2 < Math.min(i2, 8)) {
                        IBlockData iblockdata1 = (IBlockData)iblockdata.b(BlockSnow.c, j2 + 1);
                        Block.a(iblockdata, iblockdata1, this, blockposition1);
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, iblockdata1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, Blocks.ep.m(), null);
                }
            }
            if ((biomebase_precipitation = biomebase.a(blockposition2, this.T())) != BiomeBase.Precipitation.a) {
                IBlockData iblockdata2 = this.a_(blockposition2);
                iblockdata2.b().a(iblockdata2, (net.minecraft.world.level.World)this, blockposition2, biomebase_precipitation);
            }
        }
    }

    private Optional<BlockPosition> G(BlockPosition blockposition) {
        Optional<BlockPosition> optional = this.D().e(holder -> holder.a(PoiTypes.t), blockposition1 -> blockposition1.v() == this.a(HeightMap.Type.b, blockposition1.u(), blockposition1.w()) - 1, blockposition, 128, VillagePlace.Occupancy.c);
        return optional.map(blockposition1 -> blockposition1.b(1));
    }

    protected BlockPosition b(BlockPosition blockposition) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, blockposition);
        Optional<BlockPosition> optional = this.G(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(blockposition1, blockposition1.h(this.ar() + 1)).g(3.0);
        List<EntityLiving> list = this.a(EntityLiving.class, axisalignedbb, (? super T entityliving) -> entityliving != null && entityliving.bX() && this.h(entityliving.dF()));
        if (!list.isEmpty()) {
            return list.get(this.z.a(list.size())).dF();
        }
        if (blockposition1.v() == this.M_() - 1) {
            blockposition1 = blockposition1.b(2);
        }
        return blockposition1;
    }

    public boolean d() {
        return this.Y;
    }

    public boolean e() {
        return this.S().d(GameRules.R) <= 100;
    }

    private void ay() {
        if (this.e() && (!this.q().Y() || this.q().s())) {
            int i2 = this.S().d(GameRules.R);
            IChatMutableComponent ichatbasecomponent = this.O.a(i2) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.O.b(), this.O.b(i2));
            for (EntityPlayer entityplayer : this.G) {
                entityplayer.a(ichatbasecomponent, true);
            }
        }
    }

    public void f() {
        if (!this.G.isEmpty() && this.O.a(this.G)) {
            this.ay();
        }
    }

    public ScoreboardServer g() {
        return this.I.aO();
    }

    public ServerWaypointManager h() {
        return this.L;
    }

    private void az() {
        int idx;
        boolean flag = this.aj();
        if (this.H_().g()) {
            if (this.S().c(GameRules.x)) {
                int i2 = this.J.e();
                int j2 = this.J.g();
                int k2 = this.J.i();
                boolean flag1 = this.A.f();
                boolean flag2 = this.A.h();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? d.a(this.z) : C.a(this.z);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? c.a(this.z) : b.a(this.z);
                    }
                }
                this.J.b(j2);
                this.J.c(k2);
                this.J.a(i2);
                this.J.a(flag1);
                this.J.b(flag2);
            }
            this.x = this.y;
            this.y = this.A.f() ? (this.y += 0.01f) : (this.y -= 0.01f);
            this.y = MathHelper.a(this.y, 0.0f, 1.0f);
            this.v = this.w;
            this.w = this.A.h() ? (this.w += 0.01f) : (this.w -= 0.01f);
            this.w = MathHelper.a(this.w, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.G.size(); ++idx) {
            if (this.G.get(idx).A() != this) continue;
            this.G.get(idx).tickWeather();
        }
        if (flag != this.aj()) {
            for (idx = 0; idx < this.G.size(); ++idx) {
                if (this.G.get(idx).A() != this) continue;
                this.G.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.G.size(); ++idx) {
            if (this.G.get(idx).A() != this) continue;
            this.G.get(idx).updateWeather(this.v, this.w, this.x, this.y);
        }
    }

    @VisibleForTesting
    public void i() {
        this.J.b(false);
        if (!this.J.h()) {
            this.J.c(0);
        }
        this.J.a(false);
        if (!this.J.f()) {
            this.J.b(0);
        }
    }

    public void j() {
        this.P = 0;
    }

    private void a(BlockPosition blockposition, FluidType fluidtype) {
        IBlockData iblockdata = this.a_(blockposition);
        Fluid fluid = iblockdata.y();
        if (fluid.b(fluidtype)) {
            fluid.a(this, blockposition, iblockdata);
        }
    }

    private void c(BlockPosition blockposition, Block block) {
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.a(block)) {
            iblockdata.a(this, blockposition, this.z);
        }
    }

    public void a(Entity entity) {
        if (!ActivationRange.checkIfActive(entity)) {
            ++entity.at;
            entity.inactiveTick();
            return;
        }
        entity.tickTimer.startTiming();
        entity.bL();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        ++entity.at;
        gameprofilerfiller.a(() -> BuiltInRegistries.g.b(entity.ax()).toString());
        gameprofilerfiller.f("tickNonPassenger");
        entity.g();
        entity.postTick();
        gameprofilerfiller.c();
        for (Entity entity1 : entity.di()) {
            this.a(entity, entity1);
        }
        entity.tickTimer.stopTiming();
    }

    private void a(Entity entity, Entity entity1) {
        if (!entity1.ec() && entity1.du() == entity) {
            if (entity1 instanceof EntityHuman || this.K.c(entity1)) {
                entity1.bL();
                ++entity1.at;
                GameProfilerFiller gameprofilerfiller = Profiler.a();
                gameprofilerfiller.a(() -> BuiltInRegistries.g.b(entity1.ax()).toString());
                gameprofilerfiller.f("tickPassenger");
                entity1.t();
                entity1.postTick();
                gameprofilerfiller.c();
                for (Entity entity2 : entity1.di()) {
                    this.a(entity1, entity2);
                }
            }
        } else {
            entity1.cb();
        }
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata) {
        boolean flag;
        IBlockData iblockdata1 = this.a_(blockposition);
        Block block = iblockdata1.b();
        boolean bl = flag = !iblockdata.a(block);
        if (flag) {
            iblockdata.a(this, blockposition, false);
        }
        this.a(blockposition, iblockdata1.b());
        if (iblockdata1.q()) {
            this.b(blockposition, block);
        }
    }

    @Override
    public boolean a(Entity entity, BlockPosition blockposition) {
        EntityHuman entityhuman;
        if (entity instanceof EntityHuman && (this.I.a(this, blockposition, entityhuman = (EntityHuman)entity) || !this.u().a(blockposition))) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    public void a(@Nullable IProgressUpdate iprogressupdate, boolean flag, boolean flag1) {
        ChunkProviderServer chunkproviderserver = this.n();
        if (!flag1) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (iprogressupdate != null) {
                iprogressupdate.a(IChatBaseComponent.c("menu.savingLevel"));
            }
            this.c(flag);
            if (iprogressupdate != null) {
                iprogressupdate.c(IChatBaseComponent.c("menu.savingChunks"));
            }
            chunkproviderserver.a(flag);
            if (flag) {
                this.M.d();
            } else {
                this.M.c();
            }
        }
        this.J.a(this.I.aR().a(this.L_()));
        this.convertable.a(this.I.bg(), this.J, this.I.am().r());
    }

    private void c(boolean flag) {
        if (this.aa != null) {
            this.J.a(this.aa.b());
        }
        WorldPersistentData worldpersistentdata = this.n().m();
        if (flag) {
            worldpersistentdata.b();
        } else {
            worldpersistentdata.a();
        }
    }

    public <T extends Entity> List<? extends T> a(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entitytypetest, predicate, list);
        return list;
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list) {
        this.a(entitytypetest, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list, int i2) {
        this.K().a(entitytypetest, (U entity) -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> k() {
        return this.a(EntityTypes.S, EntityLiving::bX);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int i2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.G) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < i2) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer l() {
        List<EntityPlayer> list = this.a(EntityLiving::bX);
        return list.isEmpty() ? null : list.get(this.z.a(list.size()));
    }

    @Override
    public boolean b(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.c(entityplayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void a(EntityPlayer entityplayer) {
        this.c(entityplayer);
    }

    public void b(EntityPlayer entityplayer) {
        this.c(entityplayer);
    }

    private void c(EntityPlayer entityplayer) {
        Entity entity = this.d(entityplayer.cT());
        if (entity != null) {
            D.warn("Force-added player with duplicate UUID {}", (Object)entityplayer.cT());
            entity.av();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.M.a(entityplayer);
    }

    private boolean addEntity(Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        AsyncCatcher.catchOp("entity add");
        if (entity.ec()) {
            return false;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.M.a(entity);
    }

    public boolean e(Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        Stream<UUID> stream = entity.dk().map(Entity::cT);
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.M;
        Objects.requireNonNull(this.M);
        if (stream.anyMatch(persistententitysectionmanager::a)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void b(Chunk chunk) {
        for (TileEntity tileentity : chunk.J().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                h2.closeInventory();
            }
        }
        chunk.K();
        chunk.c(this);
        this.ag.a(chunk.f());
    }

    public void a(EntityPlayer entityplayer, Entity.RemovalReason entity_removalreason) {
        entityplayer.remove(entity_removalreason, null);
    }

    public boolean strikeLightning(Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int i2, BlockPosition blockposition, int j2) {
        EntityHuman entityhuman = null;
        Entity entity = this.a(i2);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        for (EntityPlayer entityplayer : this.I.am().t()) {
            if (entityplayer == null || entityplayer.A() != this || entityplayer.az() == i2) continue;
            double d0 = (double)blockposition.u() - entityplayer.dK();
            double d1 = (double)blockposition.v() - entityplayer.dM();
            double d2 = (double)blockposition.w() - entityplayer.dQ();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.g.b(new PacketPlayOutBlockBreakAnimation(i2, blockposition, j2));
        }
    }

    @Override
    public void a(@Nullable Entity entity, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        EntityHuman entityhuman1;
        PlayerList playerlist = this.I.am();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        playerlist.a(entityhuman, d0, d1, d2, holder.a().a(f2), this.al(), new PacketPlayOutNamedSoundEffect(holder, soundcategory, d0, d1, d2, f2, f1, i2));
    }

    @Override
    public void a(@Nullable Entity entity, Entity entity1, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        EntityHuman entityhuman1;
        PlayerList playerlist = this.I.am();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        playerlist.a(entityhuman, entity1.dK(), entity1.dM(), entity1.dQ(), holder.a().a(f2), this.al(), new PacketPlayOutEntitySound(holder, soundcategory, entity1, f2, f1, i2));
    }

    @Override
    public void b(int i2, BlockPosition blockposition, int j2) {
        if (this.S().c(GameRules.Y)) {
            this.I.am().t().forEach(entityplayer -> {
                Vec3D vec3d;
                if (entityplayer.A() == this) {
                    Vec3D vec3d1 = Vec3D.b(blockposition);
                    if (entityplayer.g(vec3d1) < (double)MathHelper.i(32)) {
                        vec3d = vec3d1;
                    } else {
                        Vec3D vec3d2 = vec3d1.d(entityplayer.dD()).d();
                        vec3d = entityplayer.dD().e(vec3d2.c(32.0));
                    }
                } else {
                    vec3d = entityplayer.dD();
                }
                entityplayer.g.b(new PacketPlayOutWorldEvent(i2, BlockPosition.a(vec3d), j2, true));
            });
        } else {
            this.a((Entity)null, i2, blockposition, j2);
        }
    }

    @Override
    public void a(@Nullable Entity entity, int i2, BlockPosition blockposition, int j2) {
        EntityHuman entityhuman1;
        PlayerList playerlist = this.I.am();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        playerlist.a(entityhuman, blockposition.u(), blockposition.v(), blockposition.w(), 64.0, this.al(), new PacketPlayOutWorldEvent(i2, blockposition, j2, false));
    }

    public int m() {
        return this.H_().p();
    }

    @Override
    public void a(Holder<GameEvent> holder, Vec3D vec3d, GameEvent.a gameevent_a) {
        this.N.a(holder, vec3d, gameevent_a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, int i2) {
        if (this.V) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.n().a(blockposition);
        this.T.a(blockposition);
        VoxelShape voxelshape = iblockdata.g(this, blockposition);
        VoxelShape voxelshape1 = iblockdata1.g(this, blockposition);
        if (VoxelShapes.c(voxelshape, voxelshape1, OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<EntityInsentient> iterator = this.U.iterator();
            while (iterator.hasNext()) {
                EntityInsentient entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.a(blockposition, iblockdata, iblockdata1, i2);
                    return;
                }
                NavigationAbstract navigationabstract = entityinsentient.S();
                if (!navigationabstract.b(blockposition)) continue;
                list.add(navigationabstract);
            }
            try {
                this.V = true;
                for (NavigationAbstract navigationabstract1 : list) {
                    navigationabstract1.i();
                }
            }
            finally {
                this.V = false;
            }
        }
    }

    @Override
    public void a(BlockPosition blockposition, Block block) {
        this.a(blockposition, block, ExperimentalRedstoneUtils.a(this, null, null));
    }

    @Override
    public void a(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
        this.s.a(blockposition, block, null, orientation);
    }

    @Override
    public void a(BlockPosition blockposition, Block block, EnumDirection enumdirection, @Nullable Orientation orientation) {
        this.s.a(blockposition, block, enumdirection, orientation);
    }

    @Override
    public void b(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
        this.s.a(blockposition, block, orientation);
    }

    @Override
    public void a(IBlockData iblockdata, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        this.s.a(iblockdata, blockposition, block, orientation, flag);
    }

    @Override
    public void a(Entity entity, byte b0) {
        this.n().a(entity, new PacketPlayOutEntityStatus(entity, b0));
    }

    @Override
    public void a(Entity entity, DamageSource damagesource) {
        this.n().a(entity, new ClientboundDamageEventPacket(entity, damagesource));
    }

    public ChunkProviderServer n() {
        return this.H;
    }

    @Override
    public void a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, World.a world_a, ParticleParam particleparam, ParticleParam particleparam1, WeightedList<ExplosionParticleInfo> weightedlist, Holder<SoundEffect> holder) {
        this.explode0(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, particleparam, particleparam1, weightedlist, holder);
    }

    public ServerExplosion explode0(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, World.a world_a, ParticleParam particleparam, ParticleParam particleparam1, WeightedList<ExplosionParticleInfo> weightedlist, Holder<SoundEffect> holder) {
        Explosion.Effect explosion_effect1 = switch (world_a) {
            case World.a.a -> Explosion.Effect.a;
            case World.a.b -> this.a(GameRules.S);
            case World.a.c -> this.S().c(GameRules.d) ? this.a(GameRules.T) : Explosion.Effect.a;
            case World.a.d -> this.a(GameRules.U);
            case World.a.e -> Explosion.Effect.d;
            case World.a.STANDARD -> Explosion.Effect.b;
            default -> throw new MatchException(null, null);
        };
        Vec3D vec3d = new Vec3D(d0, d1, d2);
        ServerExplosion serverexplosion = new ServerExplosion(this, entity, damagesource, explosiondamagecalculator, vec3d, f2, flag, explosion_effect1);
        int i2 = serverexplosion.i();
        if (serverexplosion.wasCanceled) {
            return serverexplosion;
        }
        ParticleParam particleparam2 = serverexplosion.l() ? particleparam : particleparam1;
        for (EntityPlayer entityplayer : this.G) {
            if (!(entityplayer.g(vec3d) < 4096.0)) continue;
            Optional<Vec3D> optional = Optional.ofNullable(serverexplosion.j().get(entityplayer));
            entityplayer.g.b(new PacketPlayOutExplosion(vec3d, f2, i2, optional, particleparam2, holder, weightedlist));
        }
        return serverexplosion;
    }

    private Explosion.Effect a(GameRules.GameRuleKey<GameRules.GameRuleBoolean> gamerules_gamerulekey) {
        return this.S().c(gamerules_gamerulekey) ? Explosion.Effect.c : Explosion.Effect.b;
    }

    @Override
    public void a(BlockPosition blockposition, Block block, int i2, int j2) {
        this.W.add((Object)new BlockActionData(blockposition, block, i2, j2));
    }

    private void aA() {
        this.X.clear();
        while (!this.W.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.W.removeFirst();
            if (this.n(blockactiondata.a())) {
                if (!this.a(blockactiondata)) continue;
                this.I.am().a(null, blockactiondata.a().u(), blockactiondata.a().v(), blockactiondata.a().w(), 64.0, this.al(), new PacketPlayOutBlockAction(blockactiondata.a(), blockactiondata.b(), blockactiondata.c(), blockactiondata.d()));
                continue;
            }
            this.X.add(blockactiondata);
        }
        this.W.addAll(this.X);
    }

    private boolean a(BlockActionData blockactiondata) {
        IBlockData iblockdata = this.a_(blockactiondata.a());
        return iblockdata.a(blockactiondata.b()) ? iblockdata.a((net.minecraft.world.level.World)this, blockactiondata.a(), blockactiondata.c(), blockactiondata.d()) : false;
    }

    public TickListServer<Block> o() {
        return this.R;
    }

    public TickListServer<FluidType> p() {
        return this.S;
    }

    @Override
    @Nonnull
    public MinecraftServer q() {
        return this.I;
    }

    public PortalTravelAgent r() {
        return this.Q;
    }

    public StructureTemplateManager s() {
        return this.I.be();
    }

    public <T extends ParticleParam> int a(T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        return this.sendParticlesSource(null, t0, false, false, d0, d1, d2, i2, d3, d4, d5, d6);
    }

    public <T extends ParticleParam> int a(T t0, boolean flag, boolean flag1, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        return this.sendParticlesSource(null, t0, flag, flag1, d0, d1, d2, i2, d3, d4, d5, d6);
    }

    public <T extends ParticleParam> int sendParticlesSource(EntityPlayer sender, T t0, boolean flag, boolean flag1, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, flag, flag1, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        for (int k2 = 0; k2 < this.G.size(); ++k2) {
            EntityPlayer entityplayer = this.G.get(k2);
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(entityplayer, flag, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer entityplayer, T t0, boolean flag, boolean flag1, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(t0, flag, flag1, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        return this.a(entityplayer, flag, d0, d1, d2, packet);
    }

    private boolean a(EntityPlayer entityplayer, boolean flag, double d0, double d1, double d2, Packet<?> packet) {
        if (entityplayer.A() != this) {
            return false;
        }
        BlockPosition blockposition = entityplayer.dF();
        if (blockposition.a(new Vec3D(d0, d1, d2), flag ? 512.0 : 32.0)) {
            entityplayer.g.b(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity a(int i2) {
        return this.K().a(i2);
    }

    @Override
    @Nullable
    public Entity a(UUID uuid) {
        Entity entity = this.d(uuid);
        if (entity != null) {
            return entity;
        }
        for (WorldServer worldserver : this.q().Q()) {
            Entity entity1;
            if (worldserver == this || (entity1 = worldserver.d(uuid)) == null) continue;
            return entity1;
        }
        return null;
    }

    @Override
    @Nullable
    public EntityHuman b(UUID uuid) {
        return this.q().am().b(uuid);
    }

    @Deprecated
    @Nullable
    public Entity b(int i2) {
        Entity entity = this.K().a(i2);
        return entity != null ? entity : (Entity)this.ab.get(i2);
    }

    @Override
    public Collection<EntityComplexPart> t() {
        return this.ab.values();
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> tagkey, BlockPosition blockposition, int i2, boolean flag) {
        if (!this.J.x().d()) {
            return null;
        }
        Optional optional = this.L_().f(Registries.bm).a(tagkey);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.n().g().a(this, (HolderSet)optional.get(), blockposition, i2, flag);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> predicate, BlockPosition blockposition, int i2, int j2, int k2) {
        return this.n().g().d().a(blockposition, i2, j2, k2, predicate, this.n().i().b(), this);
    }

    @Override
    public WorldBorder u() {
        return this.y().a(WorldBorder.d);
    }

    public CraftingManager v() {
        return this.I.aN();
    }

    @Override
    public TickRateManager w() {
        return this.I.aV();
    }

    @Override
    public boolean x() {
        return this.e;
    }

    public WorldPersistentData y() {
        return this.n().m();
    }

    @Override
    @Nullable
    public WorldMap a(MapId mapid) {
        WorldMap worldmap = this.q().O().y().b(WorldMap.a(mapid));
        if (worldmap != null) {
            worldmap.id = mapid;
        }
        return worldmap;
    }

    public void a(MapId mapid, WorldMap worldmap) {
        worldmap.id = mapid;
        MapInitializeEvent event = new MapInitializeEvent((MapView)worldmap.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.q().O().y().a(WorldMap.a(mapid), worldmap);
    }

    public MapId z() {
        return this.q().O().y().a(PersistentIdCounts.b).a();
    }

    @Override
    public void a(WorldData.a worlddata_a) {
        this.q().setRespawnData(worlddata_a, this);
    }

    @Override
    public WorldData.a A() {
        return this.J.a();
    }

    public LongSet B() {
        return this.H.l();
    }

    public boolean a(int i2, int j2, boolean flag) {
        boolean flag1 = this.H.a(new ChunkCoordIntPair(i2, j2), flag);
        if (flag && flag1) {
            this.d(i2, j2);
        }
        return flag1;
    }

    public List<EntityPlayer> C() {
        return this.G;
    }

    @Override
    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(iblockdata);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(iblockdata1))) {
            BlockPosition blockposition1 = blockposition.j();
            optional.ifPresent(holder -> this.q().execute(() -> {
                this.D().a(blockposition1);
                this.ag.c(blockposition1);
            }));
            optional1.ifPresent(holder -> this.q().execute(() -> {
                VillagePlaceRecord villageplacerecord = this.D().a(blockposition1, (Holder<VillagePlaceType>)holder);
                if (villageplacerecord != null) {
                    this.ag.a(villageplacerecord);
                }
            }));
        }
    }

    public VillagePlace D() {
        return this.n().n();
    }

    public boolean c(BlockPosition blockposition) {
        return this.a(blockposition, 1);
    }

    public boolean a(SectionPosition sectionposition) {
        return this.c(sectionposition.k());
    }

    public boolean a(BlockPosition blockposition, int i2) {
        return i2 > 6 ? false : this.b(SectionPosition.a(blockposition)) <= i2;
    }

    public int b(SectionPosition sectionposition) {
        return this.D().a(sectionposition);
    }

    public PersistentRaid E() {
        return this.f;
    }

    @Nullable
    public Raid d(BlockPosition blockposition) {
        return this.f.a(blockposition, 9216);
    }

    public boolean e(BlockPosition blockposition) {
        return this.d(blockposition) != null;
    }

    public void a(ReputationEvent reputationevent, Entity entity, ReputationHandler reputationhandler) {
        reputationhandler.a(reputationevent, entity);
    }

    public void a(Path path) throws IOException {
        PlayerChunkMap playerchunkmap = this.n().a;
        try (BufferedWriter writer = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.i().a()));
            SpawnerCreature.d spawnercreature_d = this.n().p();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry object2intmap_entry : spawnercreature_d.b().object2IntEntrySet()) {
                    writer.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)object2intmap_entry.getKey()).a(), object2intmap_entry.getIntValue()));
                }
            }
            writer.write(String.format(Locale.ROOT, "entities: %s\n", this.M.f()));
            writer.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.r.size()));
            writer.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.o().a()));
            writer.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.p().a()));
            writer.write("distance_manager: " + playerchunkmap.i().c() + "\n");
            writer.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.n().f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashreport);
        try (BufferedWriter writer1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            writer1.write(crashreport.a(ReportType.c));
        }
        Path path1 = path.resolve("chunks.csv");
        try (BufferedWriter writer2 = Files.newBufferedWriter(path1, new OpenOption[0]);){
            playerchunkmap.a(writer2);
        }
        Path path2 = path.resolve("entity_chunks.csv");
        try (BufferedWriter writer3 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            this.M.a(writer3);
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter writer4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(writer4, this.K().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter writer5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(writer5);
        }
    }

    private static void a(Writer writer, Iterable<Entity> iterable) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (Entity entity : iterable) {
            IChatBaseComponent ichatbasecomponent = entity.ar();
            IChatBaseComponent ichatbasecomponent1 = entity.S_();
            csvwriter.a(entity.dK(), entity.dM(), entity.dQ(), entity.cT(), BuiltInRegistries.g.b(entity.ax()), entity.bX(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("type").a(writer);
        for (TickingBlockEntity tickingblockentity : this.r) {
            BlockPosition blockposition = tickingblockentity.c();
            csvwriter.a(blockposition.u(), blockposition.v(), blockposition.w(), tickingblockentity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox structureboundingbox) {
        this.W.removeIf(blockactiondata -> structureboundingbox.b(blockactiondata.a()));
    }

    @Override
    public float a(EnumDirection enumdirection, boolean flag) {
        return 1.0f;
    }

    public Iterable<Entity> F() {
        return this.K().a();
    }

    public String toString() {
        return "ServerLevel[" + this.J.d() + "]";
    }

    public boolean G() {
        return this.J.y();
    }

    @Override
    public long H() {
        return this.J.x().c();
    }

    @Nullable
    public EnderDragonBattle I() {
        return this.aa;
    }

    @Override
    public WorldServer a() {
        return this;
    }

    @VisibleForTesting
    public String J() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.G.size(), this.M.f(), WorldServer.a(this.M.e().a(), (T entity) -> BuiltInRegistries.g.b(entity.ax()).toString()), this.r.size(), WorldServer.a(this.r, TickingBlockEntity::d), this.o().a(), this.p().a(), this.N());
    }

    private static <T> String a(Iterable<T> iterable, Function<T, String> function) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : iterable) {
                String s2 = function.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<Entity> K() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.M.e();
    }

    public void a(Stream<Entity> stream) {
        this.M.a(stream);
    }

    public void b(Stream<Entity> stream) {
        this.M.b(stream);
    }

    public void c(Chunk chunk) {
        chunk.d(this.F_().b());
    }

    public void a(IChunkAccess ichunkaccess) {
        this.I.execute(() -> this.ad.a(ichunkaccess.f(), ichunkaccess.g()));
    }

    public PathTypeCache L() {
        return this.T;
    }

    public void a(ChunkCoordIntPair chunkcoordintpair, int i2) {
        List<ChunkCoordIntPair> list = ChunkCoordIntPair.a(chunkcoordintpair, i2).toList();
        this.I.b(() -> {
            this.M.a();
            for (ChunkCoordIntPair chunkcoordintpair1 : list) {
                if (this.c(chunkcoordintpair1.a())) continue;
                return false;
            }
            return true;
        });
    }

    public boolean M() {
        return MinecraftServer.isSpawningMonsters(this);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.M.close();
    }

    @Override
    public String N() {
        String s2 = this.H.e();
        return "Chunks[S] W: " + s2 + " E: " + this.M.f();
    }

    public boolean c(long i2) {
        return this.M.a(i2);
    }

    public boolean d(long i2) {
        return this.c(i2) && this.H.a(i2);
    }

    public boolean f(BlockPosition blockposition) {
        return this.M.a(blockposition) && this.H.a.i().c(ChunkCoordIntPair.a(blockposition));
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair) {
        return this.M.a(chunkcoordintpair) && this.M.a(chunkcoordintpair.a());
    }

    public boolean g(BlockPosition blockposition) {
        return this.b(new ChunkCoordIntPair(blockposition));
    }

    public boolean b(ChunkCoordIntPair chunkcoordintpair) {
        return this.H.a.b(chunkcoordintpair);
    }

    public boolean c(ChunkCoordIntPair chunkcoordintpair) {
        return this.M.b(chunkcoordintpair) && this.u().a(chunkcoordintpair);
    }

    @Override
    public FeatureFlagSet O() {
        return this.I.bf().J();
    }

    @Override
    public PotionBrewer P() {
        return this.I.bv();
    }

    @Override
    public FuelValues Q() {
        return this.I.bw();
    }

    public RandomSource a(MinecraftKey minecraftkey) {
        return this.af.a(minecraftkey);
    }

    public RandomSequences R() {
        return this.af;
    }

    public GameRules S() {
        return this.J.n();
    }

    @Override
    public CrashReportSystemDetails a(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = super.a(crashreport);
        crashreportsystemdetails.a("Loaded entity count", () -> String.valueOf(this.M.g()));
        return crashreportsystemdetails;
    }

    @Override
    public int T() {
        return this.H.g().f();
    }

    @Override
    public void a(TileEntity tileentity) {
        super.a(tileentity);
        this.ag.a(tileentity);
    }

    public LevelDebugSynchronizers U() {
        return this.ag;
    }

    private final class a
    implements LevelCallback<Entity> {
        a() {
        }

        @Override
        public void a(Entity entity) {
            WaypointTransmitter waypointtransmitter;
            if (entity instanceof WaypointTransmitter && (waypointtransmitter = (WaypointTransmitter)((Object)entity)).gm()) {
                WorldServer.this.h().a(waypointtransmitter);
            }
        }

        @Override
        public void b(Entity entity) {
            if (entity instanceof WaypointTransmitter) {
                WaypointTransmitter waypointtransmitter = (WaypointTransmitter)((Object)entity);
                WorldServer.this.h().c(waypointtransmitter);
            }
            WorldServer.this.g().a(entity);
        }

        @Override
        public void c(Entity entity) {
            WorldServer.this.K.a(entity);
        }

        @Override
        public void d(Entity entity) {
            WorldServer.this.K.b(entity);
        }

        @Override
        public void e(Entity entity) {
            WaypointTransmitter waypointtransmitter;
            AsyncCatcher.catchOp("entity register");
            WorldServer.this.n().b(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.G.add(entityplayer);
                if (entityplayer.o()) {
                    WorldServer.this.h().a(entityplayer);
                }
                WorldServer.this.f();
            }
            if (entity instanceof WaypointTransmitter && (waypointtransmitter = (WaypointTransmitter)((Object)entity)).gm()) {
                WorldServer.this.h().a(waypointtransmitter);
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.V) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.U.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.s()) {
                    WorldServer.this.ab.put(entitycomplexpart.az(), (Object)entitycomplexpart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.valid = true;
        }

        @Override
        public void f(Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                Streams.stream(WorldServer.this.q().Q()).map(WorldServer::y).forEach(worldData -> {
                    for (Optional<PersistentBase> o2 : worldData.c.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)((Object)o2);
                        map.q.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.p.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().a != entity) continue;
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.ed() != Entity.RemovalReason.a)) {
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory();
                }
            }
            WorldServer.this.n().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.G.remove(entityplayer);
                WorldServer.this.h().c(entityplayer);
                WorldServer.this.f();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.V) {
                    EntityComplexPart[] s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.U.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.s()) {
                    WorldServer.this.ab.remove(entitycomplexpart.az());
                }
            }
            entity.a(DynamicGameEventListener::b);
            WorldServer.this.ag.b(entity);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.G) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
        }

        @Override
        public void g(Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

