/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.HashedStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTestInstanceBlockStatus;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChangeGameModePacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSubscriptionRequestPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromBlockPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerLoadedPacket;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetTestBlockPacket;
import net.minecraft.network.protocol.game.ServerboundTestInstanceBlockActionPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TickThrottler;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Input;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftInput;
import org.bukkit.craftbukkit.v1_21_R6.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_21_R6.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements GameProtocols.a,
PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger h = LogUtils.getLogger();
    private static final int i = -1;
    private static final int j = 4096;
    private static final int k = 80;
    private static final IChatBaseComponent l = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    private static final IChatBaseComponent m = IChatBaseComponent.c("chat.disabled.invalid_command_signature").a(EnumChatFormat.m);
    private static final int n = 1000;
    public EntityPlayer f;
    public final PlayerChunkSender g;
    private int o;
    private int p = -1;
    private final TickThrottler q = new TickThrottler(20, 200);
    private final TickThrottler r = new TickThrottler(20, 1480);
    private double s;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;
    @Nullable
    private net.minecraft.world.entity.Entity y;
    private double z;
    private double A;
    private double B;
    private double C;
    private double D;
    private double E;
    @Nullable
    private Vec3D F;
    private int G;
    private int H;
    private boolean I;
    private int J;
    private boolean K;
    private int L;
    private int M;
    private int N;
    private boolean O;
    @Nullable
    private RemoteChatSession P;
    private SignedMessageChain.b Q;
    private final LastSeenMessagesValidator R = new LastSeenMessagesValidator(20);
    private int S;
    private final MessageSignatureCache T = MessageSignatureCache.a();
    private final FutureChain U;
    private boolean V;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private boolean hasMoved = false;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private int limitedPackets;
    private long lastLimitedPacket = -1L;

    public PlayerConnection(MinecraftServer minecraftserver, NetworkManager networkmanager, EntityPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        super(minecraftserver, networkmanager, commonlistenercookie, entityplayer);
        this.g = new PlayerChunkSender(networkmanager.e());
        this.f = entityplayer;
        entityplayer.g = this;
        entityplayer.Y().a();
        UUID uuid = entityplayer.cT();
        Objects.requireNonNull(minecraftserver);
        this.Q = SignedMessageChain.b.unsigned(uuid, minecraftserver::aC);
        this.U = new FutureChain(minecraftserver.chatExecutor);
    }

    @Override
    public void d() {
        SpigotTimings.playerConnectionTimer.startTiming();
        if (this.p > -1) {
            this.b(new ClientboundBlockChangedAckPacket(this.p));
            this.p = -1;
        }
        if (this.d.J() || !this.p()) {
            this.e();
            this.q.b();
            this.r.b();
            if (this.f.P() > 0L && this.d.au() > 0 && SystemUtils.c() - this.f.P() > TimeUnit.MINUTES.toMillis(this.d.au()) && !this.f.k) {
                this.f.J();
                this.a(IChatBaseComponent.c("multiplayer.disconnect.idling"));
            }
        }
        SpigotTimings.playerConnectionTimer.stopTiming();
    }

    private boolean p() {
        this.l();
        this.f.Y = this.f.dK();
        this.f.Z = this.f.dM();
        this.f.aa = this.f.dQ();
        this.f.h();
        this.f.a(this.s, this.t, this.u, this.f.dX(), this.f.dZ());
        ++this.o;
        this.N = this.M;
        if (this.I && !this.f.gg() && !this.f.cl() && !this.f.eV()) {
            if (++this.J > this.a(this.f)) {
                h.warn("{} was kicked for floating too long!", (Object)this.f.ap());
                this.a(IChatBaseComponent.c("multiplayer.disconnect.flying"));
                return true;
            }
        } else {
            this.I = false;
            this.J = 0;
        }
        this.y = this.f.dp();
        if (this.y != this.f && this.y.dg() == this.f) {
            this.z = this.y.dK();
            this.A = this.y.dM();
            this.B = this.y.dQ();
            this.C = this.y.dK();
            this.D = this.y.dM();
            this.E = this.y.dQ();
            if (this.K && this.y.dg() == this.f) {
                if (++this.L > this.a(this.y)) {
                    h.warn("{} was kicked for floating a vehicle too long!", (Object)this.f.ap());
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.flying"));
                    return true;
                }
            } else {
                this.K = false;
                this.L = 0;
            }
        } else {
            this.y = null;
            this.K = false;
            this.L = 0;
        }
        return false;
    }

    private int a(net.minecraft.world.entity.Entity entity) {
        double d0 = entity.bp();
        if (d0 < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d1 = 0.08 / d0;
        return MathHelper.c(80.0 * Math.max(d1, 1.0));
    }

    public void l() {
        this.s = this.f.dK();
        this.t = this.f.dM();
        this.u = this.f.dQ();
        this.v = this.f.dK();
        this.w = this.f.dM();
        this.x = this.f.dQ();
    }

    @Override
    public boolean c() {
        return this.e.i() && !this.V;
    }

    @Override
    public boolean a(Packet<?> packet) {
        return super.a(packet) ? true : this.V && this.e.i() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile i() {
        return this.f.gz();
    }

    private <T, R> CompletableFuture<R> a(T t0, BiFunction<ITextFilter, T, CompletableFuture<R>> bifunction) {
        return bifunction.apply(this.f.Y(), (ITextFilter)t0).thenApply(object -> {
            if (!this.c()) {
                h.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> a(String s2) {
        return this.a(s2, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> list) {
        return this.a(list, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packetplayinsteervehicle) {
        PlayerConnectionUtils.a(packetplayinsteervehicle, this, this.f.A());
        if (!packetplayinsteervehicle.b().equals(this.f.ah())) {
            PlayerInputEvent event = new PlayerInputEvent((Player)this.f.getBukkitEntity(), (Input)new CraftInput(packetplayinsteervehicle.b()));
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        this.f.a(packetplayinsteervehicle.b());
        if (this.f.hb()) {
            this.f.J();
            boolean shift = packetplayinsteervehicle.b().f();
            if (this.f.cp() != shift) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), shift);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.f.h(shift);
                }
            }
        }
    }

    private static boolean b(double d0, double d1, double d2, float f2, float f1) {
        return Double.isNaN(d0) || Double.isNaN(d1) || Double.isNaN(d2) || !Floats.isFinite((float)f1) || !Floats.isFinite((float)f2);
    }

    private static double a(double d0) {
        return MathHelper.a(d0, -3.0E7, 3.0E7);
    }

    private static double b(double d0) {
        return MathHelper.a(d0, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packetplayinvehiclemove) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packetplayinvehiclemove, this, this.f.A());
        if (PlayerConnection.b(packetplayinvehiclemove.b().a(), packetplayinvehiclemove.b().b(), packetplayinvehiclemove.b().c(), packetplayinvehiclemove.e(), packetplayinvehiclemove.f())) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"));
        } else if (!this.q() && this.f.hb() && (entity = this.f.dp()) != this.f && entity.dg() == this.f && entity == this.y) {
            EntityLiving entityliving;
            WorldServer worldserver = this.f.A();
            double prevX = this.f.dK();
            double prevY = this.f.dM();
            double prevZ = this.f.dQ();
            float prevYaw = this.f.dX();
            float prevPitch = this.f.dZ();
            double d0 = entity.dK();
            double d1 = entity.dM();
            double d2 = entity.dQ();
            double d3 = PlayerConnection.a(packetplayinvehiclemove.b().a());
            double d4 = PlayerConnection.b(packetplayinvehiclemove.b().b());
            double d5 = PlayerConnection.a(packetplayinvehiclemove.b().c());
            float f2 = MathHelper.h(packetplayinvehiclemove.e());
            float f1 = MathHelper.h(packetplayinvehiclemove.f());
            double d6 = d3 - this.z;
            double d7 = d4 - this.A;
            double d8 = d5 - this.B;
            double d9 = entity.dI().h();
            double d10 = d6 * d6 + d7 * d7 + d8 * d8;
            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
            this.lastTick = (int)(System.currentTimeMillis() / 50L);
            ++this.M;
            int i2 = this.M - this.N;
            if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                h.debug(this.f.cV() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                i2 = 1;
            }
            this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
            double speed = this.f.gC().b ? (double)(this.f.gC().m * 20.0f) : (double)(this.f.gC().n * 10.0f);
            speed *= 2.0;
            if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.h()) {
                h.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.ap(), this.f.ap(), d6, d7, d8});
                this.b(PacketPlayOutVehicleMove.a(entity));
                return;
            }
            AxisAlignedBB axisalignedbb = entity.de();
            d6 = d3 - this.C;
            d7 = d4 - this.D;
            d8 = d5 - this.E;
            boolean flag = entity.af;
            if (entity instanceof EntityLiving && (entityliving = (EntityLiving)entity).fe()) {
                entityliving.l();
            }
            entity.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
            double d11 = d7;
            d6 = d3 - entity.dK();
            d7 = d4 - entity.dM();
            if (d7 > -0.5 || d7 < 0.5) {
                d7 = 0.0;
            }
            d8 = d5 - entity.dQ();
            d10 = d6 * d6 + d7 * d7 + d8 * d8;
            boolean flag1 = false;
            if (d10 > SpigotConfig.movedWronglyThreshold) {
                flag1 = true;
                h.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.ap(), this.f.ap(), Math.sqrt(d10)});
            }
            if (flag1 && worldserver.a(entity, axisalignedbb) || this.a(worldserver, entity, axisalignedbb, d3, d4, d5)) {
                entity.a(d0, d1, d2, f2, f1);
                this.f.a(d0, d1, d2, this.f.dX(), this.f.dZ());
                this.b(PacketPlayOutVehicleMove.a(entity));
                entity.aU();
                return;
            }
            entity.a(d3, d4, d5, f2, f1);
            this.f.a(d3, d4, d5, this.f.dX(), this.f.dZ());
            CraftPlayer player = this.getCraftPlayer();
            if (!this.hasMoved) {
                this.lastPosX = prevX;
                this.lastPosY = prevY;
                this.lastPosZ = prevZ;
                this.lastYaw = prevYaw;
                this.lastPitch = prevPitch;
                this.hasMoved = true;
            }
            Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
            Location to = CraftLocation.toBukkit(packetplayinvehiclemove.b(), player.getWorld(), packetplayinvehiclemove.e(), packetplayinvehiclemove.f());
            double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
            float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
            if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fv()) {
                this.lastPosX = to.getX();
                this.lastPosY = to.getY();
                this.lastPosZ = to.getZ();
                this.lastYaw = to.getYaw();
                this.lastPitch = to.getPitch();
                Location oldTo = to.clone();
                PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.teleport(from);
                    return;
                }
                if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                    this.f.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                    return;
                }
                if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                    this.justTeleported = false;
                    return;
                }
            }
            this.f.A().n().a(this.f);
            Vec3D vec3d = new Vec3D(entity.dK() - d0, entity.dM() - d1, entity.dQ() - d2);
            this.a(vec3d);
            entity.a(packetplayinvehiclemove.g(), vec3d);
            entity.a(vec3d.g, vec3d.h, vec3d.i, packetplayinvehiclemove.g());
            this.f.a(vec3d.g, vec3d.h, vec3d.i);
            this.K = d11 >= -0.03125 && !flag && !this.d.aj() && !entity.eh() && !entity.bn() && this.b(entity);
            this.C = entity.dK();
            this.D = entity.dM();
            this.E = entity.dQ();
        }
    }

    private boolean b(net.minecraft.world.entity.Entity entity) {
        return entity.an().a(entity.de().g(0.0625).b(0.0, -0.55, 0.0)).allMatch(BlockBase.BlockData::l);
    }

    @Override
    public void a(PacketPlayInTeleportAccept packetplayinteleportaccept) {
        PlayerConnectionUtils.a(packetplayinteleportaccept, this, this.f.A());
        if (packetplayinteleportaccept.b() == this.G) {
            if (this.F == null) {
                this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.f.a(this.F.g, this.F.h, this.F.i, this.f.dX(), this.f.dZ());
            this.v = this.F.g;
            this.w = this.F.h;
            this.x = this.F.i;
            this.f.T();
            this.F = null;
            this.f.A().n().a(this.f);
        }
    }

    @Override
    public void a(ServerboundPlayerLoadedPacket serverboundplayerloadedpacket) {
        PlayerConnectionUtils.a(serverboundplayerloadedpacket, this, this.f.A());
        this.f.w(true);
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packetplayinrecipedisplayed) {
        PlayerConnectionUtils.a(packetplayinrecipedisplayed, this, this.f.A());
        CraftingManager.d craftingmanager_d = this.d.aN().a(packetplayinrecipedisplayed.b());
        if (craftingmanager_d != null) {
            this.f.L().d(craftingmanager_d.b().a());
        }
    }

    @Override
    public void a(ServerboundSelectBundleItemPacket serverboundselectbundleitempacket) {
        PlayerConnectionUtils.a(serverboundselectbundleitempacket, this, this.f.A());
        this.f.cl.a(serverboundselectbundleitempacket.b(), serverboundselectbundleitempacket.e());
    }

    @Override
    public void a(PacketPlayInRecipeSettings packetplayinrecipesettings) {
        PlayerConnectionUtils.a(packetplayinrecipesettings, this, this.f.A());
        CraftEventFactory.callRecipeBookSettingsEvent(this.f, packetplayinrecipesettings.b(), packetplayinrecipesettings.e(), packetplayinrecipesettings.f());
        this.f.L().a(packetplayinrecipesettings.b(), packetplayinrecipesettings.e(), packetplayinrecipesettings.f());
    }

    @Override
    public void a(PacketPlayInAdvancements packetplayinadvancements) {
        PlayerConnectionUtils.a(packetplayinadvancements, this, this.f.A());
        if (packetplayinadvancements.e() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey minecraftkey = Objects.requireNonNull(packetplayinadvancements.f());
            AdvancementHolder advancementholder = this.d.aF().a(minecraftkey);
            if (advancementholder != null) {
                this.f.U().a(advancementholder);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packetplayintabcomplete) {
        PlayerConnectionUtils.a(packetplayintabcomplete, this, this.f.A());
        if (!(this.q.isIncrementAndUnderThreshold(1, 500) || this.d.am().f(this.f.gA()) || this.d.a(this.f.gA()))) {
            this.a(IChatBaseComponent.c("disconnect.spam"));
            return;
        }
        StringReader stringreader = new StringReader(packetplayintabcomplete.e());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults<CommandListenerWrapper> parseresults = this.d.aJ().a().parse(stringreader, this.f.C());
        this.d.aJ().a().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
            if (suggestions.isEmpty()) {
                return;
            }
            Suggestions suggestions1 = suggestions.getList().size() <= 1000 ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, 1000));
            this.b(new PacketPlayOutTabComplete(packetplayintabcomplete.b(), suggestions1));
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packetplayinsetcommandblock) {
        PlayerConnectionUtils.a(packetplayinsetcommandblock, this, this.f.A());
        if (!this.d.y_()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!this.f.gX()) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = null;
            TileEntityCommand tileentitycommand = null;
            BlockPosition blockposition = packetplayinsetcommandblock.b();
            TileEntity tileentity = this.f.A().c_(blockposition);
            if (tileentity instanceof TileEntityCommand) {
                tileentitycommand = (TileEntityCommand)tileentity;
                commandblocklistenerabstract = tileentitycommand.a();
            }
            String s2 = packetplayinsetcommandblock.e();
            boolean flag = packetplayinsetcommandblock.f();
            if (commandblocklistenerabstract != null) {
                TileEntityCommand.Type tileentitycommand_type = tileentitycommand.l();
                IBlockData iblockdata = this.f.A().a_(blockposition);
                EnumDirection enumdirection = iblockdata.c(BlockCommand.b);
                IBlockData iblockdata2 = switch (packetplayinsetcommandblock.i()) {
                    case TileEntityCommand.Type.a -> Blocks.lD.m();
                    case TileEntityCommand.Type.b -> Blocks.lC.m();
                    default -> Blocks.gC.m();
                };
                IBlockData iblockdata3 = (IBlockData)((IBlockData)iblockdata2.b(BlockCommand.b, enumdirection)).b(BlockCommand.c, packetplayinsetcommandblock.g());
                if (iblockdata3 != iblockdata) {
                    this.f.A().a(blockposition, iblockdata3, 2);
                    tileentity.c(iblockdata3);
                    this.f.A().m(blockposition).a(tileentity);
                }
                commandblocklistenerabstract.a(s2);
                commandblocklistenerabstract.a(flag);
                if (!flag) {
                    commandblocklistenerabstract.b(null);
                }
                tileentitycommand.b(packetplayinsetcommandblock.h());
                if (tileentitycommand_type != packetplayinsetcommandblock.i()) {
                    tileentitycommand.f();
                }
                commandblocklistenerabstract.b();
                if (!UtilColor.b(s2)) {
                    this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{s2}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packetplayinsetcommandminecart) {
        PlayerConnectionUtils.a(packetplayinsetcommandminecart, this, this.f.A());
        if (!this.d.y_()) {
            this.f.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!this.f.gX()) {
            this.f.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = packetplayinsetcommandminecart.a(this.f.A());
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.a(packetplayinsetcommandminecart.b());
                commandblocklistenerabstract.a(packetplayinsetcommandminecart.e());
                if (!packetplayinsetcommandminecart.e()) {
                    commandblocklistenerabstract.b(null);
                }
                commandblocklistenerabstract.b();
                this.f.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{packetplayinsetcommandminecart.b()}));
            }
        }
    }

    @Override
    public void a(ServerboundPickItemFromBlockPacket serverboundpickitemfromblockpacket) {
        boolean flag;
        IBlockData iblockdata;
        ItemStack itemstack;
        WorldServer worldserver = this.f.A();
        PlayerConnectionUtils.a(serverboundpickitemfromblockpacket, this, worldserver);
        BlockPosition blockposition = serverboundpickitemfromblockpacket.b();
        if (this.f.a(blockposition, 1.0) && worldserver.p(blockposition) && !(itemstack = (iblockdata = worldserver.a_(blockposition)).a((IWorldReader)worldserver, blockposition, flag = this.f.gk() && serverboundpickitemfromblockpacket.e())).f()) {
            if (flag && this.f.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                PlayerConnection.a(iblockdata, worldserver, blockposition, itemstack);
            }
            this.a(itemstack);
        }
    }

    private static void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack) {
        TileEntity tileentity;
        TileEntity tileEntity = tileentity = iblockdata.x() ? worldserver.c_(blockposition) : null;
        if (tileentity != null) {
            try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(tileentity.v(), h);){
                TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, worldserver.L_());
                tileentity.f(tagvalueoutput);
                tileentity.b(tagvalueoutput);
                ItemBlock.a(itemstack, tileentity.s(), tagvalueoutput);
                itemstack.b(tileentity.t());
            }
        }
    }

    @Override
    public void a(ServerboundPickItemFromEntityPacket serverboundpickitemfromentitypacket) {
        ItemStack itemstack;
        WorldServer worldserver = this.f.A();
        PlayerConnectionUtils.a(serverboundpickitemfromentitypacket, this, worldserver);
        net.minecraft.world.entity.Entity entity = worldserver.b(serverboundpickitemfromentitypacket.b());
        if (entity != null && this.f.b(entity, 3.0) && (itemstack = entity.dU()) != null && !itemstack.f()) {
            this.a(itemstack);
        }
    }

    private void a(ItemStack itemstack) {
        if (itemstack.a(this.f.A().O())) {
            PlayerInventory playerinventory = this.f.gB();
            int i2 = playerinventory.d(itemstack);
            if (i2 != -1) {
                if (PlayerInventory.e(i2)) {
                    playerinventory.c(i2);
                } else {
                    playerinventory.d(i2);
                }
            } else if (this.f.gk()) {
                playerinventory.c(itemstack);
            }
            this.b(new PacketPlayOutHeldItemSlot(playerinventory.g()));
            this.f.ck.d();
        }
    }

    @Override
    public void a(PacketPlayInItemName packetplayinitemname) {
        PlayerConnectionUtils.a(packetplayinitemname, this, this.f.A());
        Container container = this.f.cl;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil containeranvil = (ContainerAnvil)container;
            if (!containeranvil.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)containeranvil);
                return;
            }
            containeranvil.a(packetplayinitemname.b());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packetplayinbeacon) {
        PlayerConnectionUtils.a(packetplayinbeacon, this, this.f.A());
        Container container = this.f.cl;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon containerbeacon = (ContainerBeacon)container;
            if (!this.f.cl.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cl);
                return;
            }
            containerbeacon.a(packetplayinbeacon.b(), packetplayinbeacon.e());
        }
    }

    @Override
    public void a(PacketPlayInStruct packetplayinstruct) {
        PlayerConnectionUtils.a(packetplayinstruct, this, this.f.A());
        if (this.f.gX()) {
            BlockPosition blockposition = packetplayinstruct.b();
            IBlockData iblockdata = this.f.A().a_(blockposition);
            TileEntity tileentity = this.f.A().c_(blockposition);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.a(packetplayinstruct.f());
                tileentitystructure.a(packetplayinstruct.g());
                tileentitystructure.a(packetplayinstruct.h());
                tileentitystructure.a(packetplayinstruct.i());
                tileentitystructure.a(packetplayinstruct.j());
                tileentitystructure.a(packetplayinstruct.k());
                tileentitystructure.b(packetplayinstruct.l());
                tileentitystructure.a(packetplayinstruct.m());
                tileentitystructure.b(packetplayinstruct.n());
                tileentitystructure.e(packetplayinstruct.o());
                tileentitystructure.f(packetplayinstruct.p());
                tileentitystructure.a(packetplayinstruct.q());
                tileentitystructure.a(packetplayinstruct.r());
                if (tileentitystructure.f()) {
                    String s2 = tileentitystructure.d();
                    if (packetplayinstruct.e() == TileEntityStructure.UpdateType.b) {
                        if (tileentitystructure.D()) {
                            this.f.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{s2}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{s2}), false);
                        }
                    } else if (packetplayinstruct.e() == TileEntityStructure.UpdateType.c) {
                        if (!tileentitystructure.F()) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{s2}), false);
                        } else if (tileentitystructure.a(this.f.A())) {
                            this.f.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{s2}), false);
                        } else {
                            this.f.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{s2}), false);
                        }
                    } else if (packetplayinstruct.e() == TileEntityStructure.UpdateType.d) {
                        if (tileentitystructure.C()) {
                            this.f.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{s2}), false);
                        } else {
                            this.f.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.f.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packetplayinstruct.g()}), false);
                }
                tileentitystructure.e();
                this.f.A().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(ServerboundSetTestBlockPacket serverboundsettestblockpacket) {
        PlayerConnectionUtils.a(serverboundsettestblockpacket, this, this.f.A());
        if (this.f.gX()) {
            BlockPosition blockposition = serverboundsettestblockpacket.b();
            IBlockData iblockdata = this.f.A().a_(blockposition);
            TileEntity tileentity = this.f.A().c_(blockposition);
            if (tileentity instanceof TestBlockEntity) {
                TestBlockEntity testblockentity = (TestBlockEntity)tileentity;
                testblockentity.a(serverboundsettestblockpacket.e());
                testblockentity.a(serverboundsettestblockpacket.f());
                testblockentity.e();
                this.f.A().a(blockposition, iblockdata, testblockentity.o(), 3);
            }
        }
    }

    @Override
    public void a(ServerboundTestInstanceBlockActionPacket serverboundtestinstanceblockactionpacket) {
        TileEntity tileentity;
        PlayerConnectionUtils.a(serverboundtestinstanceblockactionpacket, this, this.f.A());
        BlockPosition blockposition = serverboundtestinstanceblockactionpacket.b();
        if (this.f.gX() && (tileentity = this.f.A().c_(blockposition)) instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity testinstanceblockentity = (TestInstanceBlockEntity)tileentity;
            if (serverboundtestinstanceblockactionpacket.e() != ServerboundTestInstanceBlockActionPacket.a.b && serverboundtestinstanceblockactionpacket.e() != ServerboundTestInstanceBlockActionPacket.a.a) {
                testinstanceblockentity.a(serverboundtestinstanceblockactionpacket.f());
                if (serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.d) {
                    EntityPlayer entityplayer = this.f;
                    Objects.requireNonNull(this.f);
                    testinstanceblockentity.a(entityplayer::a);
                } else if (serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.e) {
                    EntityPlayer entityplayer1 = this.f;
                    Objects.requireNonNull(this.f);
                    testinstanceblockentity.b(entityplayer1::a);
                } else if (serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.f) {
                    EntityPlayer entityplayer2 = this.f;
                    Objects.requireNonNull(this.f);
                    testinstanceblockentity.c(entityplayer2::a);
                } else if (serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.g) {
                    EntityPlayer entityplayer3 = this.f;
                    Objects.requireNonNull(this.f);
                    testinstanceblockentity.d(entityplayer3::a);
                }
                IBlockData iblockdata = this.f.A().a_(blockposition);
                this.f.A().a(blockposition, Blocks.a.m(), iblockdata, 3);
            } else {
                IRegistry<GameTestInstance> iregistry = this.f.ej().f(Registries.bp);
                Optional<ResourceKey<GameTestInstance>> optional = serverboundtestinstanceblockactionpacket.f().a();
                Objects.requireNonNull(iregistry);
                Optional optional1 = optional.flatMap(iregistry::a);
                IChatBaseComponent ichatbasecomponent = optional1.isPresent() ? ((GameTestInstance)((Holder.c)optional1.get()).a()).c() : IChatBaseComponent.c("test_instance.description.no_test").a(EnumChatFormat.m);
                Optional<Object> optional2 = serverboundtestinstanceblockactionpacket.e() == ServerboundTestInstanceBlockActionPacket.a.b ? serverboundtestinstanceblockactionpacket.f().a().flatMap(resourcekey -> TestInstanceBlockEntity.a(this.f.A(), resourcekey)) : Optional.empty();
                this.e.a(new ClientboundTestInstanceBlockStatus(ichatbasecomponent, optional2));
            }
            return;
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packetplayinsetjigsaw) {
        PlayerConnectionUtils.a(packetplayinsetjigsaw, this, this.f.A());
        if (this.f.gX()) {
            BlockPosition blockposition = packetplayinsetjigsaw.b();
            IBlockData iblockdata = this.f.A().a_(blockposition);
            TileEntity tileentity = this.f.A().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(packetplayinsetjigsaw.e());
                tileentityjigsaw.b(packetplayinsetjigsaw.f());
                tileentityjigsaw.a(ResourceKey.a(Registries.bn, packetplayinsetjigsaw.g()));
                tileentityjigsaw.a(packetplayinsetjigsaw.h());
                tileentityjigsaw.a(packetplayinsetjigsaw.i());
                tileentityjigsaw.a(packetplayinsetjigsaw.k());
                tileentityjigsaw.b(packetplayinsetjigsaw.j());
                tileentityjigsaw.e();
                this.f.A().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packetplayinjigsawgenerate) {
        PlayerConnectionUtils.a(packetplayinjigsawgenerate, this, this.f.A());
        if (this.f.gX()) {
            BlockPosition blockposition = packetplayinjigsawgenerate.b();
            TileEntity tileentity = this.f.A().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(this.f.A(), packetplayinjigsawgenerate.e(), packetplayinjigsawgenerate.f());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packetplayintrsel) {
        PlayerConnectionUtils.a(packetplayintrsel, this, this.f.A());
        int i2 = packetplayintrsel.b();
        Container container = this.f.cl;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant containermerchant = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.f, i2, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.f.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)containermerchant);
                return;
            }
            containermerchant.e(i2);
            containermerchant.h(i2);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packetplayinbedit) {
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.a(IChatBaseComponent.b("Book edited too quickly!"));
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i2 = packetplayinbedit.b();
        if (PlayerInventory.e(i2) || i2 == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packetplayinbedit.f();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            list.addAll(packetplayinbedit.e());
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.a((FilteredText)list1.get(0), list1.subList(1, list1.size()), i2) : list1 -> this.a((List<FilteredText>)list1, i2);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.d);
        }
    }

    private void a(List<FilteredText> list, int i2) {
        ItemStack handItem = this.f.gB().a(i2);
        ItemStack itemstack = handItem.v();
        if (itemstack.c(DataComponents.U)) {
            List<Filterable<String>> list1 = list.stream().map(this::a).toList();
            itemstack.b(DataComponents.U, new WritableBookContent(list1));
            CraftEventFactory.handleEditBookEvent(this.f, i2, handItem, itemstack);
        }
    }

    private void a(FilteredText filteredtext, List<FilteredText> list, int i2) {
        ItemStack itemstack = this.f.gB().a(i2);
        if (itemstack.c(DataComponents.U)) {
            ItemStack itemstack1 = itemstack.a((IMaterial)Items.wh);
            itemstack1.e(DataComponents.U);
            List<Filterable<IChatBaseComponent>> list1 = list.stream().map(filteredtext1 -> this.a((FilteredText)filteredtext1).a(IChatBaseComponent::b)).toList();
            itemstack1.b(DataComponents.V, new WrittenBookContent(this.a(filteredtext), this.f.ap(), 0, list1, true));
            CraftEventFactory.handleEditBookEvent(this.f, i2, itemstack, itemstack1);
            this.f.gB().a(i2, itemstack);
        }
    }

    private Filterable<String> a(FilteredText filteredtext) {
        return this.f.Z() ? Filterable.a(filteredtext.b()) : Filterable.a(filteredtext);
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packetplayinentitynbtquery) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packetplayinentitynbtquery, this, this.f.A());
        if (this.f.s(2) && (entity = this.f.A().a(packetplayinentitynbtquery.e())) != null) {
            try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(entity.en(), h);){
                TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, entity.ej());
                entity.d(tagvalueoutput);
                NBTTagCompound nbttagcompound = tagvalueoutput.b();
                this.b(new PacketPlayOutNBTQuery(packetplayinentitynbtquery.b(), nbttagcompound));
            }
        }
    }

    @Override
    public void a(ServerboundContainerSlotStateChangedPacket serverboundcontainerslotstatechangedpacket) {
        CrafterMenu craftermenu;
        IInventory iinventory;
        Container container;
        PlayerConnectionUtils.a(serverboundcontainerslotstatechangedpacket, this, this.f.A());
        if (!this.f.at() && serverboundcontainerslotstatechangedpacket.e() == this.f.cl.l && (container = this.f.cl) instanceof CrafterMenu && (iinventory = (craftermenu = (CrafterMenu)container).m()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)iinventory;
            crafterblockentity.a(serverboundcontainerslotstatechangedpacket.b(), serverboundcontainerslotstatechangedpacket.f());
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packetplayintilenbtquery) {
        PlayerConnectionUtils.a(packetplayintilenbtquery, this, this.f.A());
        if (this.f.s(2)) {
            TileEntity tileentity = this.f.A().c_(packetplayintilenbtquery.e());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.c(this.f.ej()) : null;
            this.b(new PacketPlayOutNBTQuery(packetplayintilenbtquery.b(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInFlying packetplayinflying) {
        PlayerConnectionUtils.a(packetplayinflying, this, this.f.A());
        if (PlayerConnection.b(packetplayinflying.a(0.0), packetplayinflying.b(0.0), packetplayinflying.c(0.0), packetplayinflying.a(0.0f), packetplayinflying.b(0.0f))) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"));
        } else {
            WorldServer worldserver = this.f.A();
            if (!this.f.k && !this.f.fv()) {
                if (this.o == 0) {
                    this.l();
                }
                if (this.f.hb()) {
                    float f2 = MathHelper.h(packetplayinflying.a(this.f.dX()));
                    float f1 = MathHelper.h(packetplayinflying.b(this.f.dZ()));
                    if (this.q()) {
                        this.f.b(f2, f1);
                    } else {
                        double d0 = PlayerConnection.a(packetplayinflying.a(this.f.dK()));
                        double d1 = PlayerConnection.b(packetplayinflying.b(this.f.dM()));
                        double d2 = PlayerConnection.a(packetplayinflying.c(this.f.dQ()));
                        if (this.f.cl()) {
                            this.f.a(this.f.dK(), this.f.dM(), this.f.dQ(), f2, f1);
                            this.f.A().n().a(this.f);
                            this.allowedPlayerTicks = 20;
                        } else {
                            double prevX = this.f.dK();
                            double prevY = this.f.dM();
                            double prevZ = this.f.dQ();
                            float prevYaw = this.f.dX();
                            float prevPitch = this.f.dZ();
                            double d3 = this.f.dK();
                            double d4 = this.f.dM();
                            double d5 = this.f.dQ();
                            double d6 = d0 - this.s;
                            double d7 = d1 - this.t;
                            double d8 = d2 - this.u;
                            double d9 = this.f.dI().h();
                            double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            if (this.f.gg()) {
                                if (d10 > 1.0) {
                                    this.a(this.f.dK(), this.f.dM(), this.f.dQ(), f2, f1);
                                }
                            } else {
                                boolean flag1;
                                boolean flag = this.f.fY();
                                if (worldserver.w().i()) {
                                    ++this.M;
                                    int i2 = this.M - this.N;
                                    this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                    this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                    this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                    if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                        h.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.f.ap(), (Object)i2);
                                        i2 = 1;
                                    }
                                    this.allowedPlayerTicks = packetplayinflying.i || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                                    double speed = this.f.gC().b ? (double)(this.f.gC().m * 20.0f) : (double)(this.f.gC().n * 10.0f);
                                    if (this.a(flag)) {
                                        float f22;
                                        float f3 = f22 = flag ? 300.0f : 100.0f;
                                        if (d10 - d9 > Math.max((double)f22, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0))) {
                                            h.warn("{} moved too quickly! {},{},{}", new Object[]{this.f.ap(), d6, d7, d8});
                                            this.a(this.f.dK(), this.f.dM(), this.f.dQ(), this.f.dX(), this.f.dZ());
                                            return;
                                        }
                                    }
                                }
                                AxisAlignedBB axisalignedbb = this.f.de();
                                d6 = d0 - this.v;
                                d7 = d1 - this.w;
                                d8 = d2 - this.x;
                                boolean bl = flag1 = d7 > 0.0;
                                if (this.f.aS() && !packetplayinflying.b() && flag1) {
                                    this.f.u();
                                }
                                boolean flag2 = this.f.af;
                                this.f.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                                this.f.bc = packetplayinflying.b();
                                double d11 = d7;
                                d6 = d0 - this.f.dK();
                                d7 = d1 - this.f.dM();
                                if (d7 > -0.5 || d7 < 0.5) {
                                    d7 = 0.0;
                                }
                                d8 = d2 - this.f.dQ();
                                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                                boolean flag3 = false;
                                if (!(this.f.S() || !(d10 > SpigotConfig.movedWronglyThreshold) || this.f.gg() || this.f.gQ() || this.f.at())) {
                                    flag3 = true;
                                    h.warn("{} moved wrongly!", (Object)this.f.ap());
                                }
                                if (this.f.ar || this.f.gg() || (!flag3 || !worldserver.a((net.minecraft.world.entity.Entity)this.f, axisalignedbb)) && !this.a(worldserver, this.f, axisalignedbb, d0, d1, d2)) {
                                    this.f.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                    CraftPlayer player = this.getCraftPlayer();
                                    if (!this.hasMoved) {
                                        this.lastPosX = prevX;
                                        this.lastPosY = prevY;
                                        this.lastPosZ = prevZ;
                                        this.lastYaw = prevYaw;
                                        this.lastPitch = prevPitch;
                                        this.hasMoved = true;
                                    }
                                    Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                    Location to = player.getLocation().clone();
                                    if (packetplayinflying.h) {
                                        to.setX(packetplayinflying.a);
                                        to.setY(packetplayinflying.b);
                                        to.setZ(packetplayinflying.c);
                                    }
                                    if (packetplayinflying.i) {
                                        to.setYaw(packetplayinflying.d);
                                        to.setPitch(packetplayinflying.e);
                                    }
                                    double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                    float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                    if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.f.fv()) {
                                        this.lastPosX = to.getX();
                                        this.lastPosY = to.getY();
                                        this.lastPosZ = to.getZ();
                                        this.lastYaw = to.getYaw();
                                        this.lastPitch = to.getPitch();
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event);
                                        if (event.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                            this.f.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                    this.f.a(d0, d1, d2, f2, f1);
                                    boolean flag4 = this.f.fL();
                                    this.I = d11 >= -0.03125 && !flag2 && !this.f.at() && !this.d.aj() && !this.f.gC().c && !this.f.d(MobEffects.y) && !flag && !flag4 && this.b(this.f);
                                    this.f.A().n().a(this.f);
                                    Vec3D vec3d = new Vec3D(this.f.dK() - d3, this.f.dM() - d4, this.f.dQ() - d5);
                                    this.f.a(packetplayinflying.b(), packetplayinflying.e(), vec3d);
                                    this.f.a(vec3d.g, vec3d.h, vec3d.i, packetplayinflying.b());
                                    this.a(vec3d);
                                    if (flag1) {
                                        this.f.l();
                                    }
                                    if (packetplayinflying.b() || this.f.eu() || this.f.fe() || this.f.at() || flag || flag4) {
                                        this.f.hg();
                                    }
                                    this.f.a(this.f.dK() - d3, this.f.dM() - d4, this.f.dQ() - d5);
                                    this.v = this.f.dK();
                                    this.w = this.f.dM();
                                    this.x = this.f.dQ();
                                } else {
                                    this.internalTeleport(d3, d4, d5, f2, f1);
                                    this.f.a(this.f.dK() - d3, this.f.dM() - d4, this.f.dQ() - d5, packetplayinflying.b());
                                    this.f.aU();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean a(boolean flag) {
        if (this.h()) {
            return false;
        }
        if (this.f.S()) {
            return false;
        }
        GameRules gamerules = this.f.A().S();
        return gamerules.c(GameRules.u) ? false : !flag || !gamerules.c(GameRules.v);
    }

    private boolean q() {
        if (this.F != null) {
            if (this.o - this.H > 20) {
                this.H = this.o;
                this.a(this.F.g, this.F.h, this.F.i, this.f.dX(), this.f.dZ());
            }
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.H = this.o;
        return false;
    }

    private boolean a(IWorldReader iworldreader, net.minecraft.world.entity.Entity entity, AxisAlignedBB axisalignedbb, double d0, double d1, double d2) {
        AxisAlignedBB axisalignedbb1 = entity.de().d(d0 - entity.dK(), d1 - entity.dM(), d2 - entity.dQ());
        Iterable<VoxelShape> iterable = iworldreader.a(entity, axisalignedbb1.h(1.0E-5f), axisalignedbb.g());
        VoxelShape voxelshape = VoxelShapes.a(axisalignedbb.h(1.0E-5f));
        for (VoxelShape voxelshape1 : iterable) {
            if (VoxelShapes.c(voxelshape1, voxelshape, OperatorBoolean.i)) continue;
            return true;
        }
        return false;
    }

    public void a(double d0, double d1, double d2, float f2, float f1) {
        this.teleport(d0, d1, d2, f2, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, f2, f1), Collections.emptySet(), cause);
    }

    public void a(PositionMoveRotation positionmoverotation, Set<Relative> set) {
        this.teleport(positionmoverotation, set, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(PositionMoveRotation positionmoverotation, Set<Relative> set, PlayerTeleportEvent.TeleportCause cause) {
        PositionMoveRotation absolutePosition;
        Location to;
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        if (from.equals((Object)(to = CraftLocation.toBukkit((absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this.f), positionmoverotation, set)).a(), this.getCraftPlayer().getWorld(), absolutePosition.c(), absolutePosition.d())))) {
            this.internalTeleport(positionmoverotation, set);
            return true;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            set = Collections.emptySet();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            positionmoverotation = new PositionMoveRotation(CraftLocation.toVec3D(to), Vec3D.c, to.getYaw(), to.getPitch());
        }
        this.internalTeleport(positionmoverotation, set);
        return !event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch());
    }

    private void internalTeleport(double d0, double d1, double d2, float f2, float f1) {
        this.internalTeleport(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, f2, f1), Collections.emptySet());
    }

    public void internalTeleport(PositionMoveRotation positionmoverotation, Set<Relative> set) {
        if (Float.isNaN(positionmoverotation.c())) {
            positionmoverotation = new PositionMoveRotation(positionmoverotation.a(), positionmoverotation.b(), 0.0f, positionmoverotation.d());
        }
        if (Float.isNaN(positionmoverotation.d())) {
            positionmoverotation = new PositionMoveRotation(positionmoverotation.a(), positionmoverotation.b(), positionmoverotation.c(), 0.0f);
        }
        this.justTeleported = true;
        this.H = this.o;
        if (++this.G == Integer.MAX_VALUE) {
            this.G = 0;
        }
        this.f.a(positionmoverotation, set);
        this.F = this.f.dD();
        this.lastPosX = this.F.g;
        this.lastPosY = this.F.h;
        this.lastPosZ = this.F.i;
        this.lastYaw = this.f.dX();
        this.lastPitch = this.f.dZ();
        this.b(PacketPlayOutPosition.a(this.G, positionmoverotation, set));
    }

    @Override
    public void a(PacketPlayInBlockDig packetplayinblockdig) {
        PlayerConnectionUtils.a(packetplayinblockdig, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (this.f.hb()) {
            BlockPosition blockposition = packetplayinblockdig.b();
            this.f.J();
            PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype = packetplayinblockdig.f();
            switch (packetplayinblockdig_enumplayerdigtype) {
                case g: {
                    if (!this.f.at()) {
                        ItemStack itemstack = this.f.b(EnumHand.b);
                        CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                        CraftItemStack offHand = CraftItemStack.asCraftMirror(this.f.b(EnumHand.a));
                        PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                        this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                        if (swapItemsEvent.isCancelled()) {
                            return;
                        }
                        if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                            this.f.a(EnumHand.b, this.f.b(EnumHand.a));
                        } else {
                            this.f.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                        }
                        if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                            this.f.a(EnumHand.a, itemstack);
                        } else {
                            this.f.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                        }
                        this.f.fU();
                    }
                    return;
                }
                case e: {
                    if (!this.f.at()) {
                        if (this.lastDropTick != MinecraftServer.currentTick) {
                            this.dropCount = 0;
                            this.lastDropTick = MinecraftServer.currentTick;
                        } else {
                            ++this.dropCount;
                            if (this.dropCount >= 20) {
                                h.warn(this.f.cV() + " dropped their items too quickly!");
                                this.a(IChatBaseComponent.b("You dropped your items too quickly (Hacking?)"));
                                return;
                            }
                        }
                        this.f.a(false);
                    }
                    return;
                }
                case d: {
                    if (!this.f.at()) {
                        this.f.a(true);
                    }
                    return;
                }
                case f: {
                    this.f.fT();
                    return;
                }
                case a: 
                case b: 
                case c: {
                    this.f.h.a(blockposition, packetplayinblockdig_enumplayerdigtype, packetplayinblockdig.e(), this.f.A().ar(), packetplayinblockdig.g());
                    this.a(packetplayinblockdig.g());
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid player action");
        }
    }

    private static boolean a(EntityPlayer entityplayer, ItemStack itemstack) {
        ItemBucket itembucket;
        if (itemstack.f()) {
            return false;
        }
        Item item = itemstack.h();
        if ((item instanceof ItemBlock || item instanceof ItemBucket && (itembucket = (ItemBucket)item).a() != FluidTypes.a) && !entityplayer.gW().a(itemstack)) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < 30L && this.limitedPackets++ >= 4) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= 30L) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packetplayinuseitem) {
        PlayerConnectionUtils.a(packetplayinuseitem, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (!this.checkLimit(packetplayinuseitem.timestamp)) {
            return;
        }
        if (this.f.hb()) {
            this.a(packetplayinuseitem.f());
            WorldServer worldserver = this.f.A();
            EnumHand enumhand = packetplayinuseitem.b();
            ItemStack itemstack = this.f.b(enumhand);
            if (itemstack.a(worldserver.O())) {
                MovingObjectPositionBlock movingobjectpositionblock = packetplayinuseitem.e();
                Vec3D vec3d = movingobjectpositionblock.g();
                BlockPosition blockposition = movingobjectpositionblock.b();
                if (this.f.a(blockposition, 1.0)) {
                    Vec3D vec3d1 = vec3d.d(Vec3D.b(blockposition));
                    double d0 = 1.0000001;
                    if (Math.abs(vec3d1.a()) < 1.0000001 && Math.abs(vec3d1.b()) < 1.0000001 && Math.abs(vec3d1.c()) < 1.0000001) {
                        EnumDirection enumdirection = movingobjectpositionblock.c();
                        this.f.J();
                        int i2 = this.f.A().ar();
                        if (blockposition.v() <= i2) {
                            if (this.F == null && worldserver.a((net.minecraft.world.entity.Entity)this.f, blockposition)) {
                                EnumInteractionResult.d enuminteractionresult_d;
                                this.f.fU();
                                EnumInteractionResult enuminteractionresult = this.f.h.a(this.f, worldserver, itemstack, enumhand, movingobjectpositionblock);
                                if (enuminteractionresult.a()) {
                                    CriterionTriggers.P.a(this.f, movingobjectpositionblock.b(), itemstack.v());
                                }
                                if (enumdirection == EnumDirection.b && !enuminteractionresult.a() && blockposition.v() >= i2 && PlayerConnection.a(this.f, itemstack)) {
                                    IChatMutableComponent ichatbasecomponent = IChatBaseComponent.a("build.tooHigh", i2).a(EnumChatFormat.m);
                                    this.f.b(ichatbasecomponent, true);
                                } else if (enuminteractionresult instanceof EnumInteractionResult.d && (enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult).e() == EnumInteractionResult.e.c) {
                                    this.f.a(enumhand, true);
                                }
                            }
                        } else {
                            IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.a("build.tooHigh", i2).a(EnumChatFormat.m);
                            this.f.b(ichatbasecomponent1, true);
                        }
                        this.b(new PacketPlayOutBlockChange(worldserver, blockposition));
                        this.b(new PacketPlayOutBlockChange(worldserver, blockposition.a(enumdirection)));
                    } else {
                        h.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.f.gz().name(), vec3d, blockposition});
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packetplayinblockplace) {
        PlayerConnectionUtils.a(packetplayinblockplace, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (!this.checkLimit(packetplayinblockplace.timestamp)) {
            return;
        }
        if (this.f.hb()) {
            this.a(packetplayinblockplace.e());
            WorldServer worldserver = this.f.A();
            EnumHand enumhand = packetplayinblockplace.b();
            ItemStack itemstack = this.f.b(enumhand);
            this.f.J();
            if (!itemstack.f() && itemstack.a(worldserver.O())) {
                EnumInteractionResult.d enuminteractionresult_d;
                boolean cancelled;
                float f2 = MathHelper.h(packetplayinblockplace.f());
                float f1 = MathHelper.h(packetplayinblockplace.g());
                if (f1 != this.f.dZ() || f2 != this.f.dX()) {
                    this.f.b(f2, f1);
                }
                double d0 = this.f.dK();
                double d1 = this.f.dM() + (double)this.f.df();
                double d2 = this.f.dQ();
                Vec3D vec3d = new Vec3D(d0, d1, d2);
                float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
                float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
                float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
                float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
                float f7 = f4 * f5;
                float f8 = f3 * f5;
                double d3 = this.f.hd();
                Vec3D vec3d1 = vec3d.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
                MovingObjectPositionBlock movingobjectposition = this.f.A().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.f));
                if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).d() != MovingObjectPosition.EnumMovingObjectType.b) {
                    PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.f, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                    cancelled = event.useItemInHand() == Event.Result.DENY;
                } else {
                    PlayerInteractEvent event;
                    MovingObjectPositionBlock movingobjectpositionblock = movingobjectposition;
                    cancelled = this.f.h.firedInteract && this.f.h.interactPosition.equals(movingobjectpositionblock.b()) && this.f.h.interactHand == enumhand && ItemStack.c(this.f.h.interactItemStack, itemstack) ? this.f.h.interactResult : (event = CraftEventFactory.callPlayerInteractEvent((EntityHuman)this.f, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.b(), movingobjectpositionblock.c(), itemstack, true, enumhand, movingobjectpositionblock.g())).useItemInHand() == Event.Result.DENY;
                    this.f.h.firedInteract = false;
                }
                if (cancelled) {
                    this.f.getBukkitEntity().updateInventory();
                    return;
                }
                itemstack = this.f.b(enumhand);
                if (itemstack.f()) {
                    return;
                }
                EnumInteractionResult enuminteractionresult = this.f.h.a(this.f, worldserver, itemstack, enumhand);
                if (enuminteractionresult instanceof EnumInteractionResult.d && (enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult).e() == EnumInteractionResult.e.c) {
                    this.f.a(enumhand, true);
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packetplayinspectate) {
        PlayerConnectionUtils.a(packetplayinspectate, this, this.f.A());
        if (this.f.at()) {
            for (WorldServer worldserver : this.d.Q()) {
                net.minecraft.world.entity.Entity entity = packetplayinspectate.a(worldserver);
                if (entity == null) continue;
                this.f.teleportTo(worldserver, entity.dK(), entity.dM(), entity.dQ(), Set.of(), entity.dX(), entity.dZ(), true, PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInBoatMove packetplayinboatmove) {
        PlayerConnectionUtils.a(packetplayinboatmove, this, this.f.A());
        net.minecraft.world.entity.Entity entity = this.f.dv();
        if (entity instanceof AbstractBoat) {
            AbstractBoat abstractboat = (AbstractBoat)entity;
            abstractboat.a(packetplayinboatmove.b(), packetplayinboatmove.e());
        }
    }

    @Override
    public void a(DisconnectionDetails disconnectiondetails) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        h.info("{} lost connection: {}", (Object)this.f.ap(), (Object)disconnectiondetails.a().getString());
        this.r();
        super.a(disconnectiondetails);
    }

    private void r() {
        this.U.close();
        this.f.v();
        String quitMessage = this.d.am().remove(this.f);
        if (quitMessage != null && quitMessage.length() > 0) {
            this.d.am().broadcastMessage(CraftChatMessage.fromString(quitMessage));
        }
        this.f.Y().b();
    }

    public void a(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.p = Math.max(i2, this.p);
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packetplayinhelditemslot) {
        PlayerConnectionUtils.a(packetplayinhelditemslot, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (packetplayinhelditemslot.b() >= 0 && packetplayinhelditemslot.b() < PlayerInventory.i()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.f.gB().g(), packetplayinhelditemslot.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.b(new PacketPlayOutHeldItemSlot(this.f.gB().g()));
                this.f.J();
                return;
            }
            if (this.f.gB().g() != packetplayinhelditemslot.b() && this.f.fP() == EnumHand.a) {
                this.f.fU();
            }
            this.f.gB().c(packetplayinhelditemslot.b());
            this.f.J();
        } else {
            h.warn("{} tried to set an invalid carried item", (Object)this.f.ap());
            this.a(IChatBaseComponent.b("Invalid hotbar selection (Hacking?)"));
        }
    }

    @Override
    public void a(PacketPlayInChat packetplayinchat) {
        if (this.d.al()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.a(packetplayinchat.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packetplayinchat.b(), false, () -> {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.a(packetplayinchat, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.a signedmessagechain_a) {
                    this.a(signedmessagechain_a);
                    return;
                }
                CompletionStage completablefuture = this.a(playerchatmessage.c()).thenApplyAsync(Function.identity(), (Executor)this.d.chatExecutor);
                IChatBaseComponent ichatbasecomponent = this.d.bq().decorate(this.f, playerchatmessage.d());
                this.U.append(completablefuture, filteredtext -> {
                    PlayerChatMessage playerchatmessage1 = playerchatmessage.a(ichatbasecomponent).a(filteredtext.e());
                    this.a(playerchatmessage1);
                });
            }, false);
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket serverboundchatcommandpacket) {
        this.tryHandleChat(serverboundchatcommandpacket.b(), true, () -> {
            if (this.f.w()) {
                return;
            }
            this.b(serverboundchatcommandpacket.b());
            this.detectRateSpam("/" + serverboundchatcommandpacket.b());
        }, true);
    }

    private void b(String s2) {
        String command = "/" + s2;
        h.info(this.f.cV() + " issued server command: " + command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        s2 = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.c(s2);
        if (this.d.aC() && SignableCommand.a(parseresults)) {
            h.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.f.gz().name(), (Object)s2);
            this.f.a(m);
        } else {
            this.d.aJ().a(parseresults, s2);
        }
    }

    @Override
    public void a(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket) {
        Optional<LastSeenMessages> optional = this.a(serverboundchatcommandsignedpacket.h());
        if (!optional.isEmpty()) {
            this.tryHandleChat(serverboundchatcommandsignedpacket.b(), true, () -> {
                if (this.f.w()) {
                    return;
                }
                this.a(serverboundchatcommandsignedpacket, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + serverboundchatcommandsignedpacket.b());
            }, true);
        }
    }

    private void a(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, LastSeenMessages lastseenmessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + serverboundchatcommandsignedpacket.b();
        h.info(this.f.cV() + " issued server command: " + (String)command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.c((String)command);
        try {
            map = serverboundchatcommandsignedpacket.b().equals(command) ? this.a(serverboundchatcommandsignedpacket, SignableCommand.b(parseresults), lastseenmessages) : Collections.emptyMap();
        }
        catch (SignedMessageChain.a signedmessagechain_a) {
            this.a(signedmessagechain_a);
            return;
        }
        CommandSigningContext.a commandsigningcontext = new CommandSigningContext.a(map);
        parseresults = net.minecraft.commands.CommandDispatcher.a(parseresults, commandlistenerwrapper -> commandlistenerwrapper.a(commandsigningcontext, this.U));
        this.d.aJ().a(parseresults, (String)command);
    }

    private void a(SignedMessageChain.a signedmessagechain_a) {
        h.warn("Failed to update secure chat state for {}: '{}'", (Object)this.f.gz().name(), (Object)signedmessagechain_a.a().getString());
        this.f.a(signedmessagechain_a.a().f().a(EnumChatFormat.m));
    }

    private <S> Map<String, PlayerChatMessage> a(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, SignableCommand<S> signablecommand, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        List<ArgumentSignatures.a> list = serverboundchatcommandsignedpacket.g().a();
        List<SignableCommand.a<S>> list1 = signablecommand.a();
        if (list.isEmpty()) {
            return this.b(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.a a2 : list) {
            SignableCommand.a<S> signablecommand_a = signablecommand.a(a2.a());
            if (signablecommand_a == null) {
                this.Q.setChainBroken();
                throw PlayerConnection.a(serverboundchatcommandsignedpacket.b(), list, list1);
            }
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.c(), serverboundchatcommandsignedpacket.e(), serverboundchatcommandsignedpacket.f(), lastseenmessages);
            map.put(signablecommand_a.a(), this.Q.unpack(a2.b(), signedmessagebody));
        }
        for (SignableCommand.a a3 : list1) {
            if (map.containsKey(a3.a())) continue;
            throw PlayerConnection.a(serverboundchatcommandsignedpacket.b(), list, list1);
        }
        return map;
    }

    private <S> Map<String, PlayerChatMessage> b(List<SignableCommand.a<S>> list) throws SignedMessageChain.a {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.a<S> signablecommand_a : list) {
            SignedMessageBody signedmessagebody = SignedMessageBody.a(signablecommand_a.c());
            map.put(signablecommand_a.a(), this.Q.unpack(null, signedmessagebody));
        }
        return map;
    }

    private static <S> SignedMessageChain.a a(String s2, List<ArgumentSignatures.a> list, List<SignableCommand.a<S>> list1) {
        String s1 = list.stream().map(ArgumentSignatures.a::a).collect(Collectors.joining(", "));
        String s22 = list1.stream().map(SignableCommand.a::a).collect(Collectors.joining(", "));
        h.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{s2, s1, s22});
        return new SignedMessageChain.a(m);
    }

    private ParseResults<CommandListenerWrapper> c(String s2) {
        CommandDispatcher<CommandListenerWrapper> commanddispatcher = this.d.aJ().a();
        return commanddispatcher.parse(s2, this.f.C());
    }

    private void tryHandleChat(String s2, boolean flag, Runnable runnable, boolean sync) {
        if (PlayerConnection.d(s2)) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"));
        } else if (this.f.ec() || !flag && this.f.G() == EnumChatVisibility.c) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m), false));
        } else {
            this.f.J();
            if (sync) {
                this.d.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b lastseenmessages_b) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.R;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional;
            try {
                LastSeenMessages lastseenmessages = this.R.a(lastseenmessages_b);
                optional = Optional.of(lastseenmessages);
            }
            catch (LastSeenMessagesValidator.a lastseenmessagesvalidator_a) {
                h.error("Failed to validate message acknowledgements from {}: {}", (Object)this.f.ap(), (Object)lastseenmessagesvalidator_a.getMessage());
                this.a(l);
                return Optional.empty();
            }
            return optional;
        }
    }

    private static boolean d(String s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (UtilColor.a(s2.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String s2, final PlayerChatMessage original, boolean async) {
        if (s2.isEmpty() || this.f.G() == EnumChatVisibility.c) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.a(original);
        if (!async && s2.startsWith("/")) {
            this.handleCommand(s2);
        } else if (this.f.G() != EnumChatVisibility.b) {
            CraftPlayer player = this.getCraftPlayer();
            AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, (Player)player, s2, (Set)new LazyPlayerSet(this.d));
            final String originalFormat = event.getFormat();
            final String originalMessage = event.getMessage();
            this.cserver.getPluginManager().callEvent((Event)event);
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent((Player)player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                Waitable waitable = new Waitable(){

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent((Event)queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            if (!SpigotConfig.bungee && originalFormat.equals(queueEvent.getFormat()) && originalMessage.equals(queueEvent.getMessage()) && queueEvent.getPlayer().getName().equalsIgnoreCase(queueEvent.getPlayer().getDisplayName())) {
                                PlayerConnection.this.d.am().a(original, PlayerConnection.this.f, ChatMessageType.a(ChatMessageType.e, PlayerConnection.this.f));
                                return null;
                            }
                            for (EntityPlayer recipient : PlayerConnection.this.d.am().k) {
                                recipient.getBukkitEntity().sendMessage(PlayerConnection.this.f.cT(), message);
                            }
                        } else {
                            for (Player player : queueEvent.getRecipients()) {
                                player.sendMessage(PlayerConnection.this.f.cT(), message);
                            }
                        }
                        PlayerConnection.this.d.console.sendMessage(message);
                        return null;
                    }
                };
                if (async) {
                    this.d.processQueue.add(waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e3) {
                    throw new RuntimeException("Exception processing chat event", e3.getCause());
                }
            } else {
                if (event.isCancelled()) {
                    return;
                }
                s2 = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
                if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                    if (!SpigotConfig.bungee && originalFormat.equals(event.getFormat()) && originalMessage.equals(event.getMessage()) && event.getPlayer().getName().equalsIgnoreCase(event.getPlayer().getDisplayName())) {
                        this.d.am().a(original, this.f, ChatMessageType.a(ChatMessageType.e, this.f));
                        return;
                    }
                    for (EntityPlayer recipient : this.d.am().k) {
                        recipient.getBukkitEntity().sendMessage(this.f.cT(), s2);
                    }
                } else {
                    for (Player recipient : event.getRecipients()) {
                        recipient.sendMessage(this.f.cT(), s2);
                    }
                }
                this.d.console.sendMessage(s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommand(String s2) {
        SpigotTimings.playerCommandTimer.startTiming();
        if (SpigotConfig.logCommands) {
            h.info(this.f.cV() + " issued server command: " + s2);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)player, s2, (Set)new LazyPlayerSet(this.d));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            SpigotTimings.playerCommandTimer.stopTiming();
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(PlayerConnection.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            SpigotTimings.playerCommandTimer.stopTiming();
        }
    }

    private PlayerChatMessage a(PacketPlayInChat packetplayinchat, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packetplayinchat.b(), packetplayinchat.e(), packetplayinchat.f(), lastseenmessages);
        return this.Q.unpack(packetplayinchat.g(), signedmessagebody);
    }

    private void a(PlayerChatMessage playerchatmessage) {
        String s2 = playerchatmessage.c();
        if (s2.isEmpty()) {
            h.warn(this.f.cV() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s2;
            this.d.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    PlayerConnection.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.f.G() == EnumChatVisibility.b) {
            this.b(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m), false));
        } else {
            this.chat(s2, playerchatmessage, true);
        }
        this.detectRateSpam(s2);
    }

    private void detectRateSpam(String s2) {
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !s2.startsWith(exclude)) continue;
            return;
        }
        if (!(this.q.isIncrementAndUnderThreshold() || this.d.am().f(this.f.gA()) || this.d.a(this.f.gA()))) {
            this.a(IChatBaseComponent.c("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket serverboundchatackpacket) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.R;
        synchronized (lastSeenMessagesValidator) {
            try {
                this.R.a(serverboundchatackpacket.b());
            }
            catch (LastSeenMessagesValidator.a lastseenmessagesvalidator_a) {
                h.error("Failed to validate message acknowledgement offset from {}: {}", (Object)this.f.ap(), (Object)lastseenmessagesvalidator_a.getMessage());
                this.a(l);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packetplayinarmanimation) {
        Block block;
        PlayerConnectionUtils.a(packetplayinarmanimation, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        this.f.J();
        float f1 = this.f.dZ();
        float f2 = this.f.dX();
        double d0 = this.f.dK();
        double d1 = this.f.dM() + (double)this.f.df();
        double d2 = this.f.dQ();
        Location origin = new Location((World)this.f.A().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.f.hd(), this.f.he());
        RayTraceResult result = this.f.A().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.1, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.f.getBukkitEntity() && this.f.getBukkitEntity().canSee((Entity)entity) && !handle.at() && handle.bT() && !handle.A(this.f);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.f, Action.LEFT_CLICK_AIR, this.f.gB().h(), EnumHand.a);
        } else if (this.f.h.b() == EnumGamemode.c && (block = result.getHitBlock()) != null) {
            Vector hitPosition = result.getHitPosition().subtract(block.getLocation().toVector());
            CraftEventFactory.callPlayerInteractEvent((EntityHuman)this.f, Action.LEFT_CLICK_BLOCK, block, result.getHitBlockFace(), this.f.gB().h(), true, EnumHand.a, hitPosition);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent((Player)this.getCraftPlayer(), packetplayinarmanimation.b() == EnumHand.a ? PlayerAnimationType.ARM_SWING : PlayerAnimationType.OFF_ARM_SWING);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.f.a(packetplayinarmanimation.b());
    }

    @Override
    public void a(PacketPlayInEntityAction packetplayinentityaction) {
        PlayerConnectionUtils.a(packetplayinentityaction, this, this.f.A());
        if (this.f.hb()) {
            if (this.f.ec()) {
                return;
            }
            switch (packetplayinentityaction.e()) {
                case b: 
                case c: {
                    PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packetplayinentityaction.e() == PacketPlayInEntityAction.EnumPlayerAction.b);
                    this.cserver.getPluginManager().callEvent((Event)e2);
                    if (!e2.isCancelled()) break;
                    return;
                }
            }
            this.f.J();
            switch (packetplayinentityaction.e()) {
                case b: {
                    this.f.i(true);
                    break;
                }
                case c: {
                    this.f.i(false);
                    break;
                }
                case a: {
                    if (!this.f.gg()) break;
                    this.f.a(false, true);
                    this.F = this.f.dD();
                    break;
                }
                case d: {
                    net.minecraft.world.entity.Entity entity = this.f.dv();
                    if (!(entity instanceof IJumpable)) break;
                    IJumpable ijumpable = (IJumpable)((Object)entity);
                    int i2 = packetplayinentityaction.f();
                    if (!ijumpable.a() || i2 <= 0) break;
                    ijumpable.c(i2);
                    break;
                }
                case e: {
                    net.minecraft.world.entity.Entity entity1 = this.f.dv();
                    if (!(entity1 instanceof IJumpable)) break;
                    IJumpable ijumpable1 = (IJumpable)((Object)entity1);
                    ijumpable1.b();
                    break;
                }
                case f: {
                    net.minecraft.world.entity.Entity entity2 = this.f.du();
                    if (!(entity2 instanceof HasCustomInventoryScreen)) break;
                    HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity2);
                    hascustominventoryscreen.b(this.f);
                    break;
                }
                case g: {
                    if (this.f.gI()) break;
                    this.f.fB();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid client command!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage playerchatmessage, ChatMessageType.a chatmessagetype_a) {
        if (!this.getCraftPlayer().canSeePlayer(playerchatmessage.k().c())) {
            this.a(playerchatmessage.d(), chatmessagetype_a);
            return;
        }
        this.b(new ClientboundPlayerChatPacket(this.S++, playerchatmessage.k().c(), playerchatmessage.k().b(), playerchatmessage.l(), playerchatmessage.m().a(this.T), playerchatmessage.n(), playerchatmessage.o(), chatmessagetype_a));
        MessageSignature messagesignature = playerchatmessage.l();
        if (messagesignature != null) {
            int i2;
            this.T.a(playerchatmessage.m(), playerchatmessage.l());
            LastSeenMessagesValidator lastSeenMessagesValidator = this.R;
            synchronized (lastSeenMessagesValidator) {
                this.R.a(messagesignature);
                i2 = this.R.a();
            }
            if (i2 > 4096) {
                this.a(IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"));
            }
        }
    }

    public void a(IChatBaseComponent ichatbasecomponent, ChatMessageType.a chatmessagetype_a) {
        this.b(new ClientboundDisguisedChatPacket(ichatbasecomponent, chatmessagetype_a));
    }

    public SocketAddress m() {
        return this.e.d();
    }

    public SocketAddress getRawAddress() {
        return this.e.n.remoteAddress();
    }

    public void n() {
        this.V = true;
        this.r();
        this.b(ClientboundStartConfigurationPacket.a);
        this.e.a(ConfigurationProtocols.d);
    }

    @Override
    public void a(ServerboundPingRequestPacket serverboundpingrequestpacket) {
        this.e.a(new ClientboundPongResponsePacket(serverboundpingrequestpacket.b()));
    }

    @Override
    public void a(PacketPlayInUseEntity packetplayinuseentity) {
        PlayerConnectionUtils.a(packetplayinuseentity, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        if (this.f.hb()) {
            final WorldServer worldserver = this.f.A();
            final net.minecraft.world.entity.Entity entity = packetplayinuseentity.a(worldserver);
            if (entity == this.f && !this.f.at()) {
                this.a(IChatBaseComponent.b("Cannot interact with self!"));
                return;
            }
            this.f.J();
            this.f.h(packetplayinuseentity.b());
            if (entity != null) {
                if (!worldserver.u().a(entity.dF())) {
                    return;
                }
                AxisAlignedBB axisalignedbb = entity.de();
                if (this.f.a(axisalignedbb, 3.0)) {
                    packetplayinuseentity.a(new PacketPlayInUseEntity.c(){

                        private void performInteraction(EnumHand enumhand, a playerconnection_a, PlayerInteractEntityEvent event) {
                            ItemStack itemstack = PlayerConnection.this.f.b(enumhand);
                            if (itemstack.a(worldserver.O())) {
                                ItemStack itemstack1 = itemstack.v();
                                ItemStack itemInHand = PlayerConnection.this.f.b(enumhand);
                                boolean triggerLeashUpdate = itemInHand != null && itemInHand.h() == Items.wU && entity instanceof EntityInsentient;
                                Item origItem = PlayerConnection.this.f.gB().h() == null ? null : PlayerConnection.this.f.gB().h().h();
                                PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                                if (entity instanceof Bucketable && entity instanceof EntityLiving && origItem != null && origItem.h() == Items.sl && (event.isCancelled() || PlayerConnection.this.f.gB().h() == null || PlayerConnection.this.f.gB().h().h() != origItem)) {
                                    entity.getBukkitEntity().update(PlayerConnection.this.f);
                                    PlayerConnection.this.f.cl.b();
                                }
                                if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.f.gB().h() == null || PlayerConnection.this.f.gB().h().h() != origItem)) {
                                    PlayerConnection.this.b(new PacketPlayOutAttachEntity(entity, ((EntityInsentient)entity).ak_()));
                                }
                                if (event.isCancelled() || PlayerConnection.this.f.gB().h() == null || PlayerConnection.this.f.gB().h().h() != origItem) {
                                    entity.refreshEntityData(PlayerConnection.this.f);
                                    if (entity instanceof Allay) {
                                        PlayerConnection.this.b(new PacketPlayOutEntityEquipment(entity.az(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((EntityLiving)entity).a((EnumItemSlot)slot).v())).collect(Collectors.toList())));
                                        PlayerConnection.this.f.cl.b();
                                    }
                                }
                                if (event.isCancelled()) {
                                    return;
                                }
                                EnumInteractionResult enuminteractionresult = playerconnection_a.run(PlayerConnection.this.f, entity, enumhand);
                                if (!itemInHand.f() && itemInHand.M() <= -1) {
                                    PlayerConnection.this.f.cl.b();
                                }
                                if (enuminteractionresult instanceof EnumInteractionResult.d) {
                                    EnumInteractionResult.d enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult;
                                    ItemStack itemstack2 = enuminteractionresult_d.c() ? itemstack1 : ItemStack.l;
                                    CriterionTriggers.T.a(PlayerConnection.this.f, itemstack2, entity);
                                    if (enuminteractionresult_d.e() == EnumInteractionResult.e.c) {
                                        PlayerConnection.this.f.a(enumhand, true);
                                    }
                                }
                            }
                        }

                        @Override
                        public void a(EnumHand enumhand) {
                            this.performInteraction(enumhand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                        }

                        @Override
                        public void a(EnumHand enumhand, Vec3D vec3d) {
                            this.performInteraction(enumhand, (entityplayer, entity1, enumhand1) -> entity1.a(entityplayer, vec3d, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(vec3d.g, vec3d.h, vec3d.i), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                        }

                        @Override
                        public void a() {
                            EntityArrow entityarrow;
                            if (!(entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity == PlayerConnection.this.f && !PlayerConnection.this.f.at() || entity instanceof EntityArrow && !(entityarrow = (EntityArrow)entity).cO())) {
                                ItemStack itemstack = PlayerConnection.this.f.b(EnumHand.a);
                                if (!itemstack.a(worldserver.O())) {
                                    return;
                                }
                                PlayerConnection.this.f.e(entity);
                                if (!itemstack.f() && itemstack.M() <= -1) {
                                    PlayerConnection.this.f.cl.b();
                                }
                                return;
                            }
                            PlayerConnection.this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"));
                            h.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.f.ap());
                        }
                    });
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInClientCommand packetplayinclientcommand) {
        PlayerConnectionUtils.a(packetplayinclientcommand, this, this.f.A());
        this.f.J();
        PacketPlayInClientCommand.EnumClientCommand packetplayinclientcommand_enumclientcommand = packetplayinclientcommand.b();
        switch (packetplayinclientcommand_enumclientcommand) {
            case a: {
                if (this.f.k) {
                    this.f.k = false;
                    this.f = this.d.am().respawn(this.f, true, Entity.RemovalReason.e, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    this.l();
                    CriterionTriggers.w.a(this.f, net.minecraft.world.level.World.j, net.minecraft.world.level.World.h);
                    break;
                }
                if (this.f.eU() > 0.0f) {
                    return;
                }
                this.f = this.d.am().respawn(this.f, false, Entity.RemovalReason.a, PlayerRespawnEvent.RespawnReason.DEATH);
                this.l();
                if (!this.d.w_()) break;
                this.f.a(EnumGamemode.d);
                this.f.A().S().b(GameRules.s).set(false, this.f.A());
                break;
            }
            case b: {
                this.f.K().a(this.f);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packetplayinclosewindow) {
        PlayerConnectionUtils.a(packetplayinclosewindow, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.f);
        this.f.s();
    }

    @Override
    public void a(PacketPlayInWindowClick packetplayinwindowclick) {
        PlayerConnectionUtils.a(packetplayinwindowclick, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        this.f.J();
        if (this.f.cl.l == packetplayinwindowclick.b() && this.f.cl.b(this.f)) {
            boolean cancelled = this.f.at();
            if (!this.f.cl.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cl);
            } else {
                short i2 = packetplayinwindowclick.f();
                if (!this.f.cl.a(i2)) {
                    h.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.f.ap(), (int)i2, this.f.cl.k.size()});
                } else {
                    boolean flag = packetplayinwindowclick.e() != this.f.cl.j();
                    this.f.cl.h();
                    if (packetplayinwindowclick.f() < -1 && packetplayinwindowclick.f() != -999) {
                        return;
                    }
                    InventoryView inventory = this.f.cl.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType((int)packetplayinwindowclick.f());
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.l;
                    switch (packetplayinwindowclick.h()) {
                        case a: {
                            if (packetplayinwindowclick.g() == 0) {
                                click = ClickType.LEFT;
                            } else if (packetplayinwindowclick.g() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packetplayinwindowclick.g() != 0 && packetplayinwindowclick.g() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.f() == -999) {
                                if (this.f.cl.g().f()) break;
                                action = packetplayinwindowclick.g() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packetplayinwindowclick.f() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cl.b(packetplayinwindowclick.f());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.g();
                            ItemStack cursor = this.f.cl.g();
                            if (clickedItem.f()) {
                                if (cursor.f()) break;
                                action = packetplayinwindowclick.g() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.f)) break;
                            if (cursor.f()) {
                                action = packetplayinwindowclick.g() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                if (ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packetplayinwindowclick.g() == 0 ? cursor.M() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.k() - clickedItem.M());
                                    if ((toPlace = Math.min(toPlace, slot.c.ap_() - clickedItem.M())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.M()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.M() > slot.a()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.c(cursor, clickedItem) || clickedItem.M() < 0 || clickedItem.M() + cursor.M() > cursor.k()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packetplayinwindowclick.g() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packetplayinwindowclick.g() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packetplayinwindowclick.g() != 0 && packetplayinwindowclick.g() != 1) break;
                            if (packetplayinwindowclick.f() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.f.cl.b(packetplayinwindowclick.f());
                            if (slot != null && slot.a(this.f) && slot.h()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packetplayinwindowclick.g() < 0 || packetplayinwindowclick.g() >= 9) && packetplayinwindowclick.g() != 40) break;
                            click = packetplayinwindowclick.g() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.f.cl.b(packetplayinwindowclick.f());
                            if (clickedSlot.a(this.f)) {
                                boolean canCleanSwap;
                                ItemStack hotbar = this.f.gB().a(packetplayinwindowclick.g());
                                boolean bl = canCleanSwap = hotbar.f() || clickedSlot.c == this.f.gB() && clickedSlot.a(hotbar);
                                if (clickedSlot.h()) {
                                    if (canCleanSwap) {
                                        action = InventoryAction.HOTBAR_SWAP;
                                        break;
                                    }
                                    action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                    break;
                                }
                                if (!clickedSlot.h() && !hotbar.f() && clickedSlot.a(hotbar)) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packetplayinwindowclick.g() == 2) {
                                click = ClickType.MIDDLE;
                                if (packetplayinwindowclick.f() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.f.cl.b(packetplayinwindowclick.f());
                                if (slot != null && slot.h() && this.f.gC().d && this.f.cl.g().f()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (packetplayinwindowclick.f() >= 0) {
                                if (packetplayinwindowclick.g() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.f.cl.b(packetplayinwindowclick.f());
                                    if (slot != null && slot.h() && slot.a(this.f) && !slot.g().f() && slot.g().h() != Item.a(Blocks.a)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packetplayinwindowclick.g() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.f.cl.b(packetplayinwindowclick.f());
                                if (slot != null && slot.h() && slot.a(this.f) && !slot.g().f() && slot.g().h() != Item.a(Blocks.a)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packetplayinwindowclick.g() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.f() < 0 || this.f.cl.g().f()) break;
                            ItemStack cursor = this.f.cl.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.h())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.h()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packetplayinwindowclick.h() == InventoryClickType.f || this.f.cl.w != 0) {
                        this.f.cl.a(packetplayinwindowclick.f(), (int)packetplayinwindowclick.g(), packetplayinwindowclick.h(), this.f);
                    } else if (packetplayinwindowclick.h() != InventoryClickType.f) {
                        org.bukkit.inventory.ItemStack result;
                        Recipe recipe;
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, (int)packetplayinwindowclick.f(), click, action, (int)packetplayinwindowclick.g()) : new InventoryClickEvent(inventory, type, (int)packetplayinwindowclick.f(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packetplayinwindowclick.f() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, (int)packetplayinwindowclick.f(), click, action, (int)packetplayinwindowclick.g()) : new CraftItemEvent(recipe, inventory, type, (int)packetplayinwindowclick.f(), click, action);
                        }
                        if (packetplayinwindowclick.f() == 3 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, (int)packetplayinwindowclick.f(), click, action, (int)packetplayinwindowclick.g()) : new SmithItemEvent(inventory, type, (int)packetplayinwindowclick.f(), click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.f.cl;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.f.cl != oldContainer) {
                            return;
                        }
                        block8 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.f.cl.a(i2, (int)packetplayinwindowclick.g(), packetplayinwindowclick.h(), this.f);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.f.cl.b();
                                        break block8;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.f.g.b(new PacketPlayOutSetSlot(-1, -1, this.f.ck.k(), this.f.cl.g()));
                                        this.f.g.b(new PacketPlayOutSetSlot(this.f.cl.l, this.f.ck.k(), packetplayinwindowclick.f(), this.f.cl.b(packetplayinwindowclick.f()).g()));
                                        break block8;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.f.g.b(new PacketPlayOutSetSlot(this.f.cl.l, this.f.ck.k(), packetplayinwindowclick.f(), this.f.cl.b(packetplayinwindowclick.f()).g()));
                                        break block8;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.f.g.b(new PacketPlayOutSetSlot(-1, -1, this.f.ck.k(), this.f.cl.g()));
                                        break block8;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.f.cl.b();
                        }
                    }
                    for (Int2ObjectMap.Entry int2objectmap_entry : Int2ObjectMaps.fastIterable(packetplayinwindowclick.i())) {
                        this.f.cl.a(int2objectmap_entry.getIntKey(), (HashedStack)int2objectmap_entry.getValue());
                    }
                    this.f.cl.a(packetplayinwindowclick.j());
                    this.f.cl.i();
                    if (flag) {
                        this.f.cl.e();
                    } else {
                        this.f.cl.d();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packetplayinautorecipe) {
        PlayerConnectionUtils.a(packetplayinautorecipe, this, this.f.A());
        this.f.J();
        if (!this.f.at() && this.f.cl.l == packetplayinautorecipe.b()) {
            if (!this.f.cl.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cl);
            } else {
                CraftingManager.d craftingmanager_d = this.d.aN().a(packetplayinautorecipe.e());
                if (craftingmanager_d != null) {
                    Container container;
                    RecipeHolder recipeholder = craftingmanager_d.b();
                    if (this.f.L().b(recipeholder.a()) && (container = this.f.cl) instanceof ContainerRecipeBook) {
                        ContainerRecipeBook containerrecipebook = (ContainerRecipeBook)container;
                        if (recipeholder.b().aq_().c()) {
                            h.debug("Player {} tried to place impossible recipe {}", (Object)this.f, (Object)recipeholder.a().a());
                            return;
                        }
                        Recipe recipe = recipeholder.toBukkitRecipe();
                        if (recipe == null) {
                            return;
                        }
                        PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.f, recipe, packetplayinautorecipe.f());
                        recipeholder = this.d.aN().b(CraftRecipe.toMinecraft(((Keyed)event.getRecipe()).getKey())).orElse(null);
                        if (recipeholder == null) {
                            return;
                        }
                        ContainerRecipeBook.a containerrecipebook_a = containerrecipebook.a(event.isShiftClick(), this.f.gQ(), recipeholder, this.f.A(), this.f.gB());
                        if (containerrecipebook_a == ContainerRecipeBook.a.b) {
                            this.b(new PacketPlayOutAutoRecipe(this.f.cl.l, craftingmanager_d.a().b()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packetplayinenchantitem) {
        PlayerConnectionUtils.a(packetplayinenchantitem, this, this.f.A());
        if (this.f.fv()) {
            return;
        }
        this.f.J();
        if (this.f.cl.l == packetplayinenchantitem.b() && !this.f.at()) {
            if (!this.f.cl.b(this.f)) {
                h.debug("Player {} interacted with invalid menu {}", (Object)this.f, (Object)this.f.cl);
            } else {
                boolean flag = this.f.cl.a((EntityHuman)this.f, packetplayinenchantitem.e());
                if (flag) {
                    this.f.cl.d();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packetplayinsetcreativeslot) {
        PlayerConnectionUtils.a(packetplayinsetcreativeslot, this, this.f.A());
        if (this.f.gk()) {
            boolean flag2;
            boolean flag = packetplayinsetcreativeslot.b() < 0;
            ItemStack itemstack = packetplayinsetcreativeslot.e();
            if (!itemstack.a(this.f.A().O())) {
                return;
            }
            boolean flag1 = packetplayinsetcreativeslot.b() >= 1 && packetplayinsetcreativeslot.b() <= 45;
            boolean bl = flag2 = itemstack.f() || itemstack.M() <= itemstack.k();
            if (flag || flag1 && !ItemStack.a(this.f.ck.b(packetplayinsetcreativeslot.b()).g(), packetplayinsetcreativeslot.e())) {
                CraftInventoryView inventory = this.f.ck.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packetplayinsetcreativeslot.e());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packetplayinsetcreativeslot.b() < 36) {
                    type = packetplayinsetcreativeslot.b() >= 5 && packetplayinsetcreativeslot.b() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packetplayinsetcreativeslot.b(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packetplayinsetcreativeslot.b() >= 0) {
                            this.f.ck.b();
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.f.ck.b(packetplayinsetcreativeslot.b()).e(itemstack);
                this.f.ck.a((int)packetplayinsetcreativeslot.b(), itemstack);
                this.f.ck.d();
            } else if (flag && flag2) {
                if (this.r.c()) {
                    this.r.a();
                    this.f.a(itemstack, true);
                } else {
                    h.warn("Player {} was dropping items too fast in creative mode, ignoring.", (Object)this.f.ap());
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packetplayinupdatesign) {
        List<String> list = Stream.of(packetplayinupdatesign.f()).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(list1 -> this.a(packetplayinupdatesign, (List<FilteredText>)list1), (Executor)this.d);
    }

    private void a(PacketPlayInUpdateSign packetplayinupdatesign, List<FilteredText> list) {
        if (this.f.fv()) {
            return;
        }
        this.f.J();
        WorldServer worldserver = this.f.A();
        BlockPosition blockposition = packetplayinupdatesign.b();
        if (worldserver.D(blockposition)) {
            TileEntity tileentity = worldserver.c_(blockposition);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            tileentitysign.a((EntityHuman)this.f, packetplayinupdatesign.e(), list);
        }
    }

    @Override
    public void a(PacketPlayInAbilities packetplayinabilities) {
        PlayerConnectionUtils.a(packetplayinabilities, this, this.f.A());
        if (this.f.gC().c && this.f.gC().b != packetplayinabilities.b()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.f.getBukkitEntity(), packetplayinabilities.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.f.gC().b = packetplayinabilities.b();
            } else {
                this.f.z();
            }
        }
    }

    @Override
    public void a(ServerboundClientInformationPacket serverboundclientinformationpacket) {
        PlayerConnectionUtils.a(serverboundclientinformationpacket, this, this.f.A());
        boolean flag = this.f.a(PlayerModelPart.g);
        this.f.a(serverboundclientinformationpacket.b());
        if (this.f.a(PlayerModelPart.g) != flag) {
            this.d.am().a(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.h, this.f));
        }
    }

    @Override
    public void a(PacketPlayInDifficultyChange packetplayindifficultychange) {
        PlayerConnectionUtils.a(packetplayindifficultychange, this, this.f.A());
        if (!this.f.s(2) && !this.h()) {
            h.warn("Player {} tried to change difficulty to {} without required permissions", (Object)this.f.gz().name(), (Object)packetplayindifficultychange.b().b());
        } else {
            this.d.a(packetplayindifficultychange.b(), false);
        }
    }

    @Override
    public void a(ServerboundChangeGameModePacket serverboundchangegamemodepacket) {
        PlayerConnectionUtils.a(serverboundchangegamemodepacket, this, this.f.A());
        if (!this.f.s(2)) {
            h.warn("Player {} tried to change game mode to {} without required permissions", (Object)this.f.gz().name(), (Object)serverboundchangegamemodepacket.b().e().getString());
        } else {
            CommandGamemode.a(this.f, serverboundchangegamemodepacket.b());
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packetplayindifficultylock) {
        PlayerConnectionUtils.a(packetplayindifficultylock, this, this.f.A());
        if (this.f.s(2) || this.h()) {
            this.d.b(packetplayindifficultylock.b());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket serverboundchatsessionupdatepacket) {
        PlayerConnectionUtils.a(serverboundchatsessionupdatepacket, this, this.f.A());
        RemoteChatSession.a remotechatsession_a = serverboundchatsessionupdatepacket.b();
        ProfilePublicKey.a profilepublickey_a = this.P != null ? this.P.d().b() : null;
        ProfilePublicKey.a profilepublickey_a1 = remotechatsession_a.b();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.b().isBefore(profilepublickey_a.b())) {
                this.a(ProfilePublicKey.a);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.d.av().a();
                    if (signaturevalidator == null) {
                        h.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.f.gz().name());
                        return;
                    }
                    this.a(remotechatsession_a.a(this.f.gz(), signaturevalidator));
                }
                catch (ProfilePublicKey.b profilepublickey_b) {
                    h.error("Failed to validate profile key: {}", (Object)profilepublickey_b.getMessage());
                    this.a(profilepublickey_b.a());
                }
            }
        }
    }

    @Override
    public void a(ServerboundConfigurationAcknowledgedPacket serverboundconfigurationacknowledgedpacket) {
        if (!this.V) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.e.a(ConfigurationProtocols.b, new ServerConfigurationPacketListenerImpl(this.d, this.e, this.a(this.f.E()), this.f));
    }

    @Override
    public void a(ServerboundChunkBatchReceivedPacket serverboundchunkbatchreceivedpacket) {
        PlayerConnectionUtils.a(serverboundchunkbatchreceivedpacket, this, this.f.A());
        this.g.a(serverboundchunkbatchreceivedpacket.b());
    }

    @Override
    public void a(ServerboundDebugSubscriptionRequestPacket serverbounddebugsubscriptionrequestpacket) {
        PlayerConnectionUtils.a(serverbounddebugsubscriptionrequestpacket, this, this.f.A());
        this.f.a(serverbounddebugsubscriptionrequestpacket.b());
    }

    private void a(RemoteChatSession remotechatsession) {
        this.P = remotechatsession;
        this.Q = remotechatsession.a(this.f.cT());
        this.U.append(() -> {
            this.f.a(remotechatsession);
            this.d.am().a(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), List.of(this.f)));
        });
    }

    @Override
    public void a(ServerboundClientTickEndPacket serverboundclienttickendpacket) {
        PlayerConnectionUtils.a(serverboundclienttickendpacket, this, this.f.A());
        if (!this.O) {
            this.f.a(Vec3D.c);
        }
        this.O = false;
    }

    private void a(Vec3D vec3d) {
        if (vec3d.h() > (double)1.0E-5f) {
            this.f.J();
        }
        this.f.a(vec3d);
        this.O = true;
    }

    @Override
    public boolean a() {
        return this.f.gk();
    }

    @Override
    public EntityPlayer o() {
        return this.f;
    }

    @FunctionalInterface
    private static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

