/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.command.ColouredConsoleSender;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class PlayerList {
    public static final File a = new File("banned-players.json");
    public static final File b = new File("banned-ips.json");
    public static final File c = new File("ops.json");
    public static final File d = new File("whitelist.json");
    public static final IChatBaseComponent e = IChatBaseComponent.c("chat.filtered_full");
    public static final IChatBaseComponent f = IChatBaseComponent.c("multiplayer.disconnect.duplicate_login");
    private static final Logger g = LogUtils.getLogger();
    private static final int h = 600;
    private static final SimpleDateFormat i = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer j;
    public final List<EntityPlayer> k = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> l = Maps.newHashMap();
    private final GameProfileBanList m;
    private final IpBanList n;
    private final OpList o;
    private final WhiteList p;
    public final WorldNBTStorage s;
    private final LayeredRegistryAccess<RegistryLayer> t;
    private int u;
    private int v;
    private boolean w;
    private int x;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();

    public PlayerList(MinecraftServer minecraftserver, LayeredRegistryAccess<RegistryLayer> layeredregistryaccess, WorldNBTStorage worldnbtstorage, NotificationService notificationservice) {
        this.cserver = minecraftserver.server = new CraftServer((DedicatedServer)minecraftserver, this);
        minecraftserver.console = ColouredConsoleSender.getInstance();
        this.j = minecraftserver;
        this.t = layeredregistryaccess;
        this.s = worldnbtstorage;
        this.p = new WhiteList(d, notificationservice);
        this.o = new OpList(c, notificationservice);
        this.m = new GameProfileBanList(a, notificationservice);
        this.n = new IpBanList(b, notificationservice);
    }

    public void a(NetworkManager networkmanager, EntityPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        NameAndId nameandid = entityplayer.gA();
        UserNameToIdResolver usernametoidresolver = this.j.av().f();
        Optional<NameAndId> optional = usernametoidresolver.a(nameandid.a());
        String s2 = optional.map(NameAndId::b).orElse(nameandid.b());
        String lastKnownName = entityplayer.getBukkitEntity().getLastKnownName();
        if (lastKnownName != null) {
            s2 = lastKnownName;
        }
        usernametoidresolver.a(nameandid);
        WorldServer worldserver = entityplayer.A();
        String s1 = networkmanager.a(this.j.br());
        WorldData worlddata = worldserver.F_();
        PlayerConnection playerconnection = new PlayerConnection(this.j, networkmanager, entityplayer, commonlistenercookie);
        networkmanager.a(GameProtocols.b.a(RegistryFriendlyByteBuf.a(this.j.bg()), playerconnection), playerconnection);
        GameRules gamerules = worldserver.S();
        boolean flag = gamerules.c(GameRules.F);
        boolean flag1 = gamerules.c(GameRules.r);
        boolean flag2 = gamerules.c(GameRules.y);
        playerconnection.b(new PacketPlayOutLogin(entityplayer.az(), worlddata.k(), this.j.P(), this.n(), worldserver.spigotConfig.viewDistance, worldserver.spigotConfig.simulationDistance, flag1, !flag, flag2, entityplayer.b(worldserver), this.j.aC()));
        entityplayer.getBukkitEntity().sendSupportedChannels();
        playerconnection.b(new PacketPlayOutServerDifficulty(worlddata.p(), worlddata.q()));
        playerconnection.b(new PacketPlayOutAbilities(entityplayer.gC()));
        playerconnection.b(new PacketPlayOutHeldItemSlot(entityplayer.gB().g()));
        CraftingManager craftingmanager = this.j.aN();
        playerconnection.b(new PacketPlayOutRecipeUpdate(craftingmanager.b(), craftingmanager.c()));
        this.d(entityplayer);
        entityplayer.K().c();
        entityplayer.L().a(entityplayer);
        this.a(worldserver.g(), entityplayer);
        this.j.ax();
        IChatMutableComponent ichatmutablecomponent = entityplayer.gz().name().equalsIgnoreCase(s2) ? IChatBaseComponent.a("multiplayer.player.joined", entityplayer.S_()) : IChatBaseComponent.a("multiplayer.player.joined.renamed", entityplayer.S_(), s2);
        ichatmutablecomponent.a(EnumChatFormat.o);
        String joinMessage = CraftChatMessage.fromComponent(ichatmutablecomponent);
        playerconnection.a(entityplayer.dK(), entityplayer.dM(), entityplayer.dQ(), entityplayer.dX(), entityplayer.dZ());
        ServerPing serverping = this.j.aw();
        if (serverping != null && !commonlistenercookie.d()) {
            entityplayer.a(serverping);
        }
        this.k.add(entityplayer);
        this.playersByName.put(entityplayer.cV().toLowerCase(Locale.ROOT), entityplayer);
        this.l.put(entityplayer.cT(), entityplayer);
        CraftPlayer bukkitPlayer = entityplayer.getBukkitEntity();
        entityplayer.cl.transferTo(entityplayer.cl, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, joinMessage);
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!entityplayer.g.c()) {
            return;
        }
        joinMessage = playerJoinEvent.getJoinMessage();
        if (joinMessage != null && joinMessage.length() > 0) {
            for (IChatBaseComponent line : CraftChatMessage.fromString(joinMessage)) {
                this.j.am().a(line, false);
            }
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(List.of(entityplayer));
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            EntityPlayer entityplayer1 = this.k.get(i2);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                entityplayer1.g.b(packet);
            }
            if (!bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            entityplayer.g.b(ClientboundPlayerInfoUpdatePacket.a(List.of(entityplayer1)));
        }
        entityplayer.sentListPacket = true;
        entityplayer.refreshEntityData(entityplayer);
        this.a(entityplayer, worldserver);
        if (entityplayer.A() == worldserver && !worldserver.C().contains(entityplayer)) {
            worldserver.a(entityplayer);
            this.j.aR().a(entityplayer);
        }
        worldserver = entityplayer.A();
        this.c(entityplayer);
        entityplayer.c();
        this.j.E().a(entityplayer);
        g.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{entityplayer.ap(), s1, entityplayer.az(), worldserver.J.d(), entityplayer.dK(), entityplayer.dM(), entityplayer.dQ()});
    }

    public void a(ScoreboardServer scoreboardserver, EntityPlayer entityplayer) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam scoreboardteam : scoreboardserver.f()) {
            entityplayer.g.b(PacketPlayOutScoreboardTeam.a(scoreboardteam, true));
        }
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            ScoreboardObjective scoreboardobjective = scoreboardserver.a(displayslot);
            if (scoreboardobjective == null || set.contains(scoreboardobjective)) continue;
            for (Packet<?> packet : scoreboardserver.d(scoreboardobjective)) {
                entityplayer.g.b(packet);
            }
            set.add(scoreboardobjective);
        }
    }

    public void a(final WorldServer worldserver) {
        worldserver.u().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder worldborder, double d0) {
                PlayerList.this.a(new ClientboundSetBorderSizePacket(worldborder), worldserver.al());
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1, long i2) {
                PlayerList.this.a(new ClientboundSetBorderLerpSizePacket(worldborder), worldserver.al());
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1) {
                PlayerList.this.a(new ClientboundSetBorderCenterPacket(worldborder), worldserver.al());
            }

            @Override
            public void a(WorldBorder worldborder, int i2) {
                PlayerList.this.a(new ClientboundSetBorderWarningDelayPacket(worldborder), worldserver.al());
            }

            @Override
            public void b(WorldBorder worldborder, int i2) {
                PlayerList.this.a(new ClientboundSetBorderWarningDistancePacket(worldborder), worldserver.al());
            }

            @Override
            public void b(WorldBorder worldborder, double d0) {
            }

            @Override
            public void c(WorldBorder worldborder, double d0) {
            }
        });
    }

    public Optional<NBTTagCompound> loadPlayerData(EntityHuman nameandid) {
        NBTTagCompound nbttagcompound = this.j.bf().v();
        if (this.j.a(nameandid.gA()) && nbttagcompound != null) {
            g.debug("loading single player");
            return Optional.of(nbttagcompound);
        }
        return this.s.load(nameandid);
    }

    protected void a(EntityPlayer entityplayer) {
        AdvancementDataPlayer advancementdataplayer;
        if (!entityplayer.getBukkitEntity().isPersistent()) {
            return;
        }
        this.s.a(entityplayer);
        ServerStatisticManager serverstatisticmanager = entityplayer.K();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.a();
        }
        if ((advancementdataplayer = entityplayer.U()) != null) {
            advancementdataplayer.b();
        }
    }

    public String remove(EntityPlayer entityplayer) {
        Object entity;
        WorldServer worldserver = entityplayer.A();
        entityplayer.a(StatisticList.j);
        if (entityplayer.cl != entityplayer.ck) {
            entityplayer.r();
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)entityplayer.getBukkitEntity(), (String)(entityplayer.kickLeaveMessage != null ? entityplayer.kickLeaveMessage : "\u00a7e" + entityplayer.cV() + " left the game"));
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        entityplayer.h();
        this.a(entityplayer);
        if (entityplayer.cl() && ((Entity)(entity = entityplayer.dp())).do()) {
            g.debug("Removing player mount");
            entityplayer.cb();
            ((Entity)entity).dl().forEach(entity1 -> entity1.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT));
        }
        entityplayer.av();
        for (EntityEnderPearl entityenderpearl : entityplayer.aj()) {
            entityenderpearl.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT);
        }
        worldserver.a(entityplayer, Entity.RemovalReason.d);
        entityplayer.U().a();
        this.k.remove(entityplayer);
        this.playersByName.remove(entityplayer.cV().toLowerCase(Locale.ROOT));
        this.j.aR().b(entityplayer);
        UUID uuid = entityplayer.cT();
        EntityPlayer entityplayer1 = this.l.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.l.remove(uuid);
            this.j.E().b(entityplayer);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(entityplayer.cT()));
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            EntityPlayer entityplayer2 = this.k.get(i2);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.g.b(packet);
                continue;
            }
            entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return playerQuitEvent.getQuitMessage();
    }

    @Nullable
    public EntityPlayer canPlayerLogin(LoginListener loginlistener, GameProfile gameprofile) {
        NameAndId nameandid = new NameAndId(gameprofile);
        UUID uuid = gameprofile.id();
        Set set = Sets.newIdentityHashSet();
        for (EntityPlayer entityplayer : this.k) {
            if (!entityplayer.cT().equals(uuid)) continue;
            set.add(entityplayer);
        }
        for (EntityPlayer entityplayer2 : set) {
            this.a(entityplayer2);
            entityplayer2.g.a(f);
        }
        SocketAddress socketaddress = loginlistener.g.d();
        EntityPlayer entity = new EntityPlayer(this.j, this.j.a(net.minecraft.world.level.World.h), gameprofile, ClientInformation.a());
        entity.transferCookieConnection = loginlistener;
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)player, loginlistener.g.hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.g.n.remoteAddress()).getAddress());
        if (this.m.a(nameandid)) {
            GameProfileBanEntry gameprofilebanentry = (GameProfileBanEntry)this.m.c(nameandid);
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned.reason", gameprofilebanentry.e());
            if (gameprofilebanentry.c() != null) {
                ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned.expiration", new Object[]{i.format(gameprofilebanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent));
        } else if (!this.a(nameandid)) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.c("multiplayer.disconnect.not_whitelisted");
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, SpigotConfig.whitelistMessage);
        } else if (this.n.a(socketaddress)) {
            IpBanEntry ipbanentry = this.n.b(socketaddress);
            IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("multiplayer.disconnect.banned_ip.reason", ipbanentry.e());
            if (ipbanentry.c() != null) {
                ichatmutablecomponent1.b(IChatBaseComponent.a("multiplayer.disconnect.banned_ip.expiration", new Object[]{i.format(ipbanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent1));
        } else if (this.k.size() >= this.n() && !this.b(nameandid)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, SpigotConfig.serverFullMessage);
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.disconnect(event.getKickMessage());
            return null;
        }
        return entity;
    }

    public boolean disconnectAllPlayersWithProfile(UUID uuid, EntityPlayer player) {
        return player == null;
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, flag, entity_removalreason, reason, null);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason, Location location) {
        BlockPosition blockposition;
        IBlockData iblockdata;
        Object worlddata_a;
        WorldServer worldserver2;
        TeleportTransition teleporttransition;
        entityplayer.cb();
        this.k.remove(entityplayer);
        this.playersByName.remove(entityplayer.cV().toLowerCase(Locale.ROOT));
        entityplayer.A().a(entityplayer, entity_removalreason);
        EntityPlayer entityplayer1 = entityplayer;
        WorldServer fromWorld = entityplayer.A();
        entityplayer.k = false;
        entityplayer1.g = entityplayer.g;
        entityplayer1.a(entityplayer, flag);
        entityplayer1.e(entityplayer.az());
        entityplayer1.a(entityplayer.as());
        for (String s2 : entityplayer.aA()) {
            entityplayer1.a(s2);
        }
        if (location == null) {
            teleporttransition = entityplayer.findRespawnPositionAndUseSpawnBlock(!flag, TeleportTransition.a, reason);
            if (!flag) {
                entityplayer.reset();
            }
        } else {
            teleporttransition = new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), Vec3D.c, location.getYaw(), location.getPitch(), TeleportTransition.a);
        }
        if (teleporttransition == null) {
            return entityplayer;
        }
        WorldServer worldserver = teleporttransition.b();
        entityplayer1.spawnIn(worldserver, flag);
        entityplayer1.ee();
        entityplayer1.h(false);
        Vec3D vec3d = teleporttransition.c();
        entityplayer1.forceSetPositionRotation(vec3d.g, vec3d.h, vec3d.i, teleporttransition.e(), teleporttransition.f());
        if (teleporttransition.g()) {
            entityplayer1.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
            entityplayer1.setRespawnPosition(null, false, PlayerSpawnChangeEvent.Cause.RESET);
        }
        byte b0 = (byte)(flag ? 1 : 0);
        WorldServer worldserver1 = entityplayer1.A();
        WorldData worlddata = worldserver1.F_();
        entityplayer1.g.b(new PacketPlayOutRespawn(entityplayer1.b(worldserver1), b0));
        entityplayer1.g.b(new PacketPlayOutViewDistance(worldserver1.spigotConfig.viewDistance));
        entityplayer1.g.b(new ClientboundSetSimulationDistancePacket(worldserver1.spigotConfig.simulationDistance));
        entityplayer1.g.teleport(CraftLocation.toBukkit(entityplayer1.dD(), (World)worldserver1.getWorld(), entityplayer1.dX(), entityplayer1.dZ()));
        entityplayer1.g.b(new PacketPlayOutSpawnPosition(worldserver.A()));
        entityplayer1.g.b(new PacketPlayOutServerDifficulty(worlddata.p(), worlddata.q()));
        entityplayer1.g.b(new PacketPlayOutExperience(entityplayer1.ct, entityplayer1.cs, entityplayer1.cr));
        this.c(entityplayer1);
        this.a(entityplayer1, worldserver);
        this.d(entityplayer1);
        if (!entityplayer.g.isDisconnected()) {
            worldserver.b(entityplayer1);
            this.k.add(entityplayer1);
            this.playersByName.put(entityplayer1.cV().toLowerCase(Locale.ROOT), entityplayer1);
            this.l.put(entityplayer1.cT(), entityplayer1);
        }
        entityplayer1.x(entityplayer1.eU());
        EntityPlayer.RespawnConfig entityplayer_respawnconfig = entityplayer1.V();
        if (!flag && entityplayer_respawnconfig != null && (worldserver2 = this.j.a(((WorldData.a)(worlddata_a = entityplayer_respawnconfig.a())).a())) != null && (iblockdata = worldserver2.a_(blockposition = ((WorldData.a)worlddata_a).b())).a(Blocks.ql)) {
            entityplayer1.g.b(new PacketPlayOutNamedSoundEffect(SoundEffects.xq, SoundCategory.e, blockposition.u(), blockposition.v(), blockposition.w(), 1.0f, 1.0f, worldserver.I_().g()));
        }
        this.e(entityplayer);
        entityplayer.z();
        for (MobEffect mobEffect : entityplayer.eR()) {
            entityplayer.g.b(new PacketPlayOutEntityEffect(entityplayer.az(), mobEffect, false));
        }
        entityplayer.h(worldserver);
        if (fromWorld != worldserver) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)entityplayer.getBukkitEntity(), (World)fromWorld.getWorld());
            this.j.server.getPluginManager().callEvent((Event)event);
        }
        if (entityplayer.g.isDisconnected()) {
            this.a(entityplayer);
        }
        return entityplayer1;
    }

    public void c(EntityPlayer entityplayer) {
        this.a((EntityLiving)entityplayer, entityplayer.g);
    }

    public void a(EntityLiving entityliving, PlayerConnection playerconnection) {
        for (MobEffect mobeffect : entityliving.eR()) {
            playerconnection.b(new PacketPlayOutEntityEffect(entityliving.az(), mobeffect, false));
        }
    }

    public void d(EntityPlayer entityplayer) {
        int i2 = this.j.b(entityplayer.gA());
        this.a(entityplayer, i2);
    }

    public void d() {
        if (++this.x > 600) {
            for (int i2 = 0; i2 < this.k.size(); ++i2) {
                final EntityPlayer target = this.k.get(i2);
                target.g.b(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.e), this.k.stream().filter(new Predicate<EntityPlayer>(){

                    @Override
                    public boolean test(EntityPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
            }
            this.x = 0;
        }
    }

    public void a(Packet<?> packet) {
        for (EntityPlayer entityplayer : this.k) {
            entityplayer.g.b(packet);
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            EntityPlayer entityplayer = this.k.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.k.get((int)i2).g.b(packet);
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        for (int i2 = 0; i2 < world.C().size(); ++i2) {
            ((EntityPlayer)world.C().get((int)i2)).g.b(packet);
        }
    }

    public void a(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> resourcekey) {
        for (EntityPlayer entityplayer : this.k) {
            if (entityplayer.A().al() != resourcekey) continue;
            entityplayer.g.b(packet);
        }
    }

    public void a(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeam scoreboardteambase = entityhuman.cD();
        if (scoreboardteambase != null) {
            for (String s2 : ((ScoreboardTeamBase)scoreboardteambase).h()) {
                EntityPlayer entityplayer = this.a(s2);
                if (entityplayer == null || entityplayer == entityhuman) continue;
                entityplayer.a(ichatbasecomponent);
            }
        }
    }

    public void b(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeam scoreboardteambase = entityhuman.cD();
        if (scoreboardteambase == null) {
            this.a(ichatbasecomponent, false);
        } else {
            for (int i2 = 0; i2 < this.k.size(); ++i2) {
                EntityPlayer entityplayer = this.k.get(i2);
                if (entityplayer.cD() == scoreboardteambase) continue;
                entityplayer.a(ichatbasecomponent);
            }
        }
    }

    public String[] e() {
        String[] astring = new String[this.k.size()];
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            astring[i2] = this.k.get(i2).gz().name();
        }
        return astring;
    }

    public GameProfileBanList f() {
        return this.m;
    }

    public IpBanList g() {
        return this.n;
    }

    public void d(NameAndId nameandid) {
        this.a(nameandid, Optional.empty(), Optional.empty());
    }

    public void a(NameAndId nameandid, Optional<Integer> optional, Optional<Boolean> optional1) {
        this.o.a(new OpListEntry(nameandid, optional.orElse(this.j.k()), optional1.orElse(this.o.b(nameandid))));
        EntityPlayer entityplayer = this.b(nameandid.a());
        if (entityplayer != null) {
            this.d(entityplayer);
        }
    }

    public void e(NameAndId nameandid) {
        EntityPlayer entityplayer;
        if (this.o.a(nameandid) && (entityplayer = this.b(nameandid.a())) != null) {
            this.d(entityplayer);
        }
    }

    private void a(EntityPlayer entityplayer, int i2) {
        if (entityplayer.g != null) {
            byte b0 = i2 <= 0 ? (byte)24 : (i2 >= 4 ? (byte)28 : (byte)((byte)(24 + i2)));
            entityplayer.g.b(new PacketPlayOutEntityStatus(entityplayer, b0));
        }
        entityplayer.getBukkitEntity().recalculatePermissions();
        this.j.aJ().a(entityplayer);
    }

    public boolean a(NameAndId nameandid) {
        return !this.o() || this.o.d(nameandid) || this.p.d(nameandid);
    }

    public boolean f(NameAndId nameandid) {
        return this.o.d(nameandid) || this.j.a(nameandid) && this.j.bf().l() || this.w;
    }

    @Nullable
    public EntityPlayer a(String s2) {
        return this.playersByName.get(s2.toLowerCase(Locale.ROOT));
    }

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, double d3, ResourceKey<net.minecraft.world.level.World> resourcekey, Packet<?> packet) {
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            double d6;
            double d5;
            double d4;
            EntityPlayer entityplayer = this.k.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || entityplayer == entityhuman || entityplayer.A().al() != resourcekey || !((d4 = d0 - entityplayer.dK()) * d4 + (d5 = d1 - entityplayer.dM()) * d5 + (d6 = d2 - entityplayer.dQ()) * d6 < d3 * d3)) continue;
            entityplayer.g.b(packet);
        }
    }

    public void h() {
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            this.a(this.k.get(i2));
        }
    }

    public WhiteList i() {
        return this.p;
    }

    public String[] j() {
        return this.p.b();
    }

    public OpList k() {
        return this.o;
    }

    public String[] l() {
        return this.o.b();
    }

    public void a() {
    }

    public void a(EntityPlayer entityplayer, WorldServer worldserver) {
        WorldBorder worldborder = worldserver.u();
        entityplayer.g.b(new ClientboundInitializeBorderPacket(worldborder));
        entityplayer.g.b(new PacketPlayOutUpdateTime(worldserver.ag(), worldserver.ah(), worldserver.S().c(GameRules.m)));
        entityplayer.g.b(new PacketPlayOutSpawnPosition(worldserver.A()));
        if (worldserver.aj()) {
            entityplayer.setPlayerWeather(WeatherType.DOWNFALL, false);
            entityplayer.updateWeather(-worldserver.w, worldserver.w, -worldserver.y, worldserver.y);
        }
        entityplayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.o, 0.0f));
        this.j.aV().a(entityplayer);
    }

    public void e(EntityPlayer entityplayer) {
        entityplayer.ck.b();
        entityplayer.getBukkitEntity().updateScaledHealth();
        entityplayer.refreshEntityData(entityplayer);
        entityplayer.g.b(new PacketPlayOutHeldItemSlot(entityplayer.gB().g()));
        int i2 = entityplayer.A().S().c(GameRules.r) ? 22 : 23;
        entityplayer.g.b(new PacketPlayOutEntityStatus(entityplayer, (byte)i2));
        float immediateRespawn = entityplayer.A().S().c(GameRules.F) ? 1.0f : 0.0f;
        entityplayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.m, immediateRespawn));
    }

    public int m() {
        return this.k.size();
    }

    public int n() {
        return this.j.t();
    }

    public boolean o() {
        return this.j.aT();
    }

    public List<EntityPlayer> b(String s2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.k) {
            if (!entityplayer.D().equals(s2)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int p() {
        return this.u;
    }

    public int q() {
        return this.v;
    }

    public MinecraftServer c() {
        return this.j;
    }

    @Nullable
    public NBTTagCompound r() {
        return null;
    }

    public void a(boolean flag) {
        this.w = flag;
    }

    public void s() {
        for (EntityPlayer player : this.k) {
            player.g.a(CraftChatMessage.fromStringOrEmpty(this.j.server.getShutdownMessage()));
        }
    }

    public void broadcastMessage(IChatBaseComponent[] iChatBaseComponents) {
        for (IChatBaseComponent component : iChatBaseComponents) {
            this.a(component, false);
        }
    }

    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.a(ichatbasecomponent, (EntityPlayer entityplayer) -> ichatbasecomponent, flag);
    }

    public void a(IChatBaseComponent ichatbasecomponent, Function<EntityPlayer, IChatBaseComponent> function, boolean flag) {
        this.j.a(ichatbasecomponent);
        for (EntityPlayer entityplayer : this.k) {
            IChatBaseComponent ichatbasecomponent1 = function.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.b(ichatbasecomponent1, flag);
        }
    }

    public void a(PlayerChatMessage playerchatmessage, CommandListenerWrapper commandlistenerwrapper, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(commandlistenerwrapper);
        this.a(playerchatmessage, commandlistenerwrapper::a, commandlistenerwrapper.i(), chatmessagetype_a);
    }

    public void a(PlayerChatMessage playerchatmessage, EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(entityplayer);
        this.a(playerchatmessage, entityplayer::c, entityplayer, chatmessagetype_a);
    }

    private void a(PlayerChatMessage playerchatmessage, Predicate<EntityPlayer> predicate, @Nullable EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        boolean flag = this.a(playerchatmessage);
        this.j.a(playerchatmessage.d(), chatmessagetype_a, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.a(playerchatmessage);
        boolean flag1 = false;
        for (EntityPlayer entityplayer1 : this.k) {
            boolean flag2 = predicate.test(entityplayer1);
            entityplayer1.a(outgoingchatmessage, flag2, chatmessagetype_a);
            flag1 |= flag2 && playerchatmessage.j();
        }
        if (flag1 && entityplayer != null) {
            entityplayer.a(e);
        }
    }

    private boolean a(PlayerChatMessage playerchatmessage) {
        return playerchatmessage.i() && !playerchatmessage.a(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer entityhuman) {
        GameProfile gameprofile = entityhuman.gz();
        UUID uuid = gameprofile.id();
        ServerStatisticManager serverstatisticmanager = entityhuman.K();
        return serverstatisticmanager == null ? this.getPlayerStats(uuid, gameprofile.name()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverstatisticmanager;
        EntityPlayer entityhuman = this.b(uuid);
        ServerStatisticManager serverStatisticManager = serverstatisticmanager = entityhuman == null ? null : entityhuman.K();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.j.a(SavedFile.b).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtils.a(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtils.b(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatisticManager(this.j, file1);
        }
        return serverstatisticmanager;
    }

    public AdvancementDataPlayer f(EntityPlayer entityplayer) {
        UUID uuid = entityplayer.cT();
        AdvancementDataPlayer advancementdataplayer = entityplayer.U();
        if (advancementdataplayer == null) {
            Path path = this.j.a(SavedFile.a).resolve(String.valueOf(uuid) + ".json");
            advancementdataplayer = new AdvancementDataPlayer(this.j.aE(), this, this.j.aF(), path, entityplayer);
        }
        advancementdataplayer.a(entityplayer);
        return advancementdataplayer;
    }

    public void a(int i2) {
        this.u = i2;
        this.a(new PacketPlayOutViewDistance(i2));
        for (WorldServer worldserver : this.j.Q()) {
            if (worldserver == null) continue;
            worldserver.n().a(i2);
        }
    }

    public void b(int i2) {
        this.v = i2;
        this.a(new ClientboundSetSimulationDistancePacket(i2));
        for (WorldServer worldserver : this.j.Q()) {
            if (worldserver == null) continue;
            worldserver.n().b(i2);
        }
    }

    public List<EntityPlayer> t() {
        return this.k;
    }

    @Nullable
    public EntityPlayer b(UUID uuid) {
        return this.l.get(uuid);
    }

    @Nullable
    public EntityPlayer c(String s2) {
        for (EntityPlayer entityplayer : this.k) {
            if (!entityplayer.gz().name().equalsIgnoreCase(s2)) continue;
            return entityplayer;
        }
        return null;
    }

    public boolean b(NameAndId nameandid) {
        return false;
    }

    public void u() {
        for (EntityPlayer player : this.k) {
            player.U().a(this.j.aF());
            player.U().a(player, false);
        }
        this.a(new ClientboundUpdateTagsPacket(TagNetworkSerialization.a(this.t)));
        this.reloadRecipes();
    }

    public void reloadRecipes() {
        CraftingManager craftingmanager = this.j.aN();
        PacketPlayOutRecipeUpdate packetplayoutrecipeupdate = new PacketPlayOutRecipeUpdate(craftingmanager.b(), craftingmanager.c());
        for (EntityPlayer entityplayer : this.k) {
            entityplayer.g.b(packetplayoutrecipeupdate);
            entityplayer.L().a(entityplayer);
        }
    }

    public boolean v() {
        return this.w;
    }
}

